/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.controller;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.activity.model.ActivityAndStreaks;
import com.infinite.focus.server.activity.model.Page;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.activity.request.GetMoodInsightsPostByStudentIdsRequest;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.studentstreak.service.category.StreakCategoryService;
import com.infinite.focus.server.studentstreak.service.content.StreakContentService;
import com.infinite.focus.server.studentstreak.service.resourcelibrary.StreakResourceLibraryService;
import com.infinite.focus.server.utils.DateUtils;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/activity"})
public class ActivityController {
    private final MessageService messageService;
    private final MoodRepository moodRepository;
    private final StreakCategoryService streakCategoryService;
    private final StreakContentService streakContentService;
    private final StreakResourceLibraryService streakResourceLibraryService;
    private final RestComponent restComponent;
    private final LessonRepository lessonRepository;
    private final ActivityRepository activityRepository;
    private final ActivityService activityService;

    public ActivityController(MessageService messageService, MoodRepository moodRepository, StreakCategoryService streakCategoryService, StreakContentService streakContentService, StreakResourceLibraryService streakResourceLibraryService, RestComponent restComponent, ActivityRepository activityRepository, LessonRepository lessonRepository, ActivityService activityService) {
        this.messageService = messageService;
        this.moodRepository = moodRepository;
        this.streakCategoryService = streakCategoryService;
        this.streakContentService = streakContentService;
        this.streakResourceLibraryService = streakResourceLibraryService;
        this.restComponent = restComponent;
        this.activityRepository = activityRepository;
        this.lessonRepository = lessonRepository;
        this.activityService = activityService;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<ActivityAndStreaks> createActivity(@RequestBody Activity request) {
        ActivityAndStreaks activityAndStreaks = new ActivityAndStreaks();
        Student student = this.restComponent.getStudentById(request.getStudent_id().longValue());
        if (student != null && student.isDemo()) {
            long id = this.activityRepository.getLastRecordId() + 1L;
            request.setActivity_id(id);
            activityAndStreaks.setActivity(request);
            return new ResponseEntity((Object)activityAndStreaks, HttpStatus.OK);
        }
        if (request.getStudent_id() != null) {
            Student s = this.restComponent.getStudentById(request.getStudent_id().longValue());
            request.setStudent(s);
        }
        if (request.getInstructor_id() != null) {
            Instructor i = this.restComponent.getInstructorById(request.getInstructor_id().longValue());
            request.setInstructor(i);
        }
        if (request.getActivity_type_id() == 2L) {
            Lesson lesson = this.lessonRepository.findByVideoUrl(request.getVideo_url());
            request.setEntity_id(lesson.getLesson_id());
        }
        if (request.getActivity_type_id() == 4L) {
            MoodUpdateAndStreak moodUpdateAndStreak;
            if (request.getPage().equals((Object)Page.HOME)) {
                moodUpdateAndStreak = this.updateMood(request.getStudent_id().longValue(), request.getMood_update_after(), request.getLevel_of_focus_after(), request.getEnd_date_time());
                if (moodUpdateAndStreak.getStreak() != null) {
                    activityAndStreaks.getStreaks().add(moodUpdateAndStreak.getStreak());
                }
            } else {
                MoodUpdateAndStreak moodUpdateAndStreak1;
                moodUpdateAndStreak = this.updateMood(request.getStudent_id().longValue(), request.getMood_update_before(), request.getLevel_of_focus_before(), request.getStart_date_time());
                if (moodUpdateAndStreak.getStreak() != null) {
                    activityAndStreaks.getStreaks().add(moodUpdateAndStreak.getStreak());
                }
                if ((moodUpdateAndStreak1 = this.updateMood(request.getStudent_id().longValue(), request.getMood_update_after(), request.getLevel_of_focus_after(), request.getEnd_date_time())).getStreak() != null) {
                    activityAndStreaks.getStreaks().add(moodUpdateAndStreak1.getStreak());
                }
            }
        }
        System.out.println("StartDate " + DateUtils.dailyDateFormat.format(request.getStart_date_time()) + " End Date " + DateUtils.dailyDateFormat.format(request.getEnd_date_time()));
        Activity activity = (Activity)this.activityRepository.save((Object)request);
        if (activity.getActivity_type_id() == 4L && activity.getStudent_id() != null && activity.getStudent_id() > 0L) {
            Streak streakGrowthMindsets;
            Streak streakMindfulnessVideos;
            Streak streakMindfulStretches;
            Streak streakCopingCues;
            Streak streakEnergizingExercises;
            Streak streakSELCurriculumArticle;
            Streak streakAllCompetencies;
            List activities = this.activityRepository.findByActivityTypeIdAndStudentIdOrderByActivityIdASC(4L, activity.getStudent_id().longValue());
            Streak streakClymbTime = this.streakResourceLibraryService.addStreakClymbTime(activity.getStudent_id().longValue(), activities);
            if (streakClymbTime != null) {
                activityAndStreaks.getStreaks().add(streakClymbTime);
            }
            if ((streakAllCompetencies = this.streakCategoryService.addStreakAllCompetencies(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakAllCompetencies);
            }
            if ((streakSELCurriculumArticle = this.streakContentService.addStreakSELCurriculumArticle(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakSELCurriculumArticle);
            }
            if ((streakEnergizingExercises = this.streakContentService.addStreakEnergizingExercises(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakEnergizingExercises);
            }
            if ((streakCopingCues = this.streakContentService.addStreakCopingCues(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakCopingCues);
            }
            if ((streakMindfulStretches = this.streakContentService.addStreakMindfulStretches(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakMindfulStretches);
            }
            if ((streakMindfulnessVideos = this.streakContentService.addStreakMindfulnessVideos(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakMindfulnessVideos);
            }
            if ((streakGrowthMindsets = this.streakContentService.addStreakGrowthMindsets(activity.getStudent_id(), activities)) != null) {
                activityAndStreaks.getStreaks().add(streakGrowthMindsets);
            }
        }
        activityAndStreaks.setActivity(activity);
        if (request.getActivity_type_id() == 4L && request.getPage().equals((Object)Page.HOME)) {
            activityAndStreaks.setAsk_for_help(this.restComponent.getAskForHelpByStudentId(request.getStudent_id().longValue()));
        }
        return new ResponseEntity((Object)activityAndStreaks, HttpStatus.OK);
    }

    private MoodUpdateAndStreak updateMood(long student_id, String text, float level_of_focus, Date createdAt) {
        MoodDTO mood = this.moodRepository.findByMood(text.trim());
        if (mood == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.mood.is.not.found"));
        }
        MoodUpdate moodUpdate = new MoodUpdate();
        moodUpdate.setStudent_id(student_id);
        moodUpdate.setMood_id(mood.getMood_id());
        moodUpdate.setText(mood.getMood());
        moodUpdate.setText_es(mood.getMood_es());
        moodUpdate.setLevel_of_focus(level_of_focus);
        MoodUpdateAndStreak moodUpdateAndStreak = this.restComponent.createMoodUpdate(moodUpdate);
        moodUpdateAndStreak.getMoodUpdate().setCreatedAt(createdAt);
        return moodUpdateAndStreak;
    }

    @GetMapping(value={"/set-video-duration-in-activity-in-seconds"})
    public ResponseEntity<List<Activity>> setVideoDurationInActivityInSe() {
        List activities = this.activityRepository.getAllVideoActivities();
        for (Activity activity : activities) {
            if (activity.getWatch_duration() != 0L) continue;
            long diffInActivity = this.activityRepository.getDifferenceBetweenStartDateTimeAndEndDateTimeInSecondsByActivityId(Long.valueOf(activity.getActivity_id()));
            activity.setWatch_duration(diffInActivity);
            this.activityRepository.save((Object)activity);
        }
        return new ResponseEntity((Object)activities, HttpStatus.OK);
    }

    @PostMapping(value={"/get-mood-insights-post-by-student-ids"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, Object>> getMoodInsightsPostByStudentIds(@RequestBody GetMoodInsightsPostByStudentIdsRequest request) {
        return new ResponseEntity((Object)this.activityService.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(request.getStudent_ids(), request.getFromDate(), request.getToDate(), request.getLanguage()), HttpStatus.OK);
    }
}

