/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dailyappreciation.repository;

import com.infinite.focus.server.dailyappreciation.dto.DailyAppreciationDTO;
import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationCoreRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DailyAppreciationCoreRepositoryImpl
implements DailyAppreciationCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public DailyAppreciationCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static DailyAppreciationDTO mapRow(ResultSet rs, int i) throws SQLException {
        return DailyAppreciationDTO.builder().daily_appreciation_update_id(rs.getLong("daily_appreciation_update_id")).student_id(rs.getLong("student_id")).text(rs.getString("text")).text_es(rs.getString("text_es")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public Page<DailyAppreciationDTO> findPageByStudentId(long student_id, Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM daily_appreciation WHERE student_id = ? ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, (rs, rowNum) -> rs.getInt(1), new Object[]{student_id});
        StringBuilder querySql = new StringBuilder("SELECT * FROM daily_appreciation WHERE student_id = ? ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), DailyAppreciationCoreRepositoryImpl::mapRow, new Object[]{student_id});
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }
}

