/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.service;

import com.infinite.focus.server.fcm.model.NotificationType;
import com.infinite.focus.server.home.request.GetNotificationsRequest;
import com.infinite.focus.server.message.repository.MessageRepository;
import com.infinite.focus.server.notification.entity.Notification;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.notification.service.NotificationService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificationServiceImpl
implements NotificationService {
    private final EntityManager entityManager;
    private final NotificationRepository notificationRepository;
    private final MessageRepository messageRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final RestComponent restComponent;

    public NotificationServiceImpl(EntityManager entityManager, NotificationRepository notificationRepository, MessageRepository messageRepository, RealTimeMessageService realTimeMessageService, RestComponent restComponent) {
        this.entityManager = entityManager;
        this.notificationRepository = notificationRepository;
        this.messageRepository = messageRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.restComponent = restComponent;
    }

    public List<Notification> getNotifications(GetNotificationsRequest request) {
        Predicate genderPredicate;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((List)request.getStudentIds())) {
            genderPredicate = qb.in((Expression)root.get("student_id")).value((Object)request.getStudentIds());
            predicates.add(genderPredicate);
        } else {
            genderPredicate = qb.notEqual((Expression)root.get("student_id"), (Object)0);
            predicates.add(genderPredicate);
        }
        predicates.add(qb.equal((Expression)root.get("instructor_id"), (Object)request.getInstructor_id()));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dayWitTimeFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)request.getFromDate()), (Comparable)DateUtils.getToDateWithoutTime((Date)request.getToDate())));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.desc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List notifications = typedQuery.getResultList();
        System.out.println("Notification Count = " + notifications.size());
        return notifications;
    }

    public Page<Notification> getNotificationsByInstructorId(GetNotificationsRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getStudentIds())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student_id")).value((Object)request.getStudentIds());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((Set)request.getNotification_types())) {
            CriteriaBuilder.In notificationTypePredicate = qb.in((Expression)root.get("notification_type")).value((Object)request.getNotification_types());
            predicates.add(notificationTypePredicate);
        }
        if (request.getViewed() != null) {
            predicates.add(qb.equal((Expression)root.get("viewed_instructor"), (Object)request.getViewed()));
        }
        predicates.add(qb.equal((Expression)root.get("instructor_id"), (Object)request.getInstructor_id()));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dayWitTimeFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)request.getFromDate()), (Comparable)DateUtils.getToDateWithoutTime((Date)request.getToDate())));
        }
        query.where(predicates.toArray(new Predicate[0]));
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(request.getSortBy()))});
        }
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Notification.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        for (Notification notification : pagedResult) {
            notification.setViewed_instructor(true);
            this.notificationRepository.save((Object)notification);
        }
        return pagedResult;
    }

    public Page<Notification> getNotificationsByParentIds(List<Long> studentIds, List<Long> parentIds, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate, Boolean viewed) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student_id")).value(studentIds);
            predicates.add(genderPredicate);
        }
        if (viewed != null) {
            predicates.add(qb.equal((Expression)root.get("viewed_parent"), (Object)viewed));
        }
        predicates.add(qb.in((Expression)root.get("parent_id")).value(parentIds));
        if (fromDate != null && toDate != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(fromDate) + " - ToDate " + DateUtils.dayWitTimeFormat.format(toDate));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)fromDate), (Comparable)DateUtils.getToDateWithoutTime((Date)toDate)));
        }
        query.where(predicates.toArray(new Predicate[0]));
        if (orderBy.equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(sortBy))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(sortBy))});
        }
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Notification.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        for (Notification notification : pagedResult) {
            notification.setViewed_parent(true);
            this.notificationRepository.save((Object)notification);
        }
        return pagedResult;
    }

    @Async
    public void sendSOSAlertNotificationToInstructor(long instructor_id, long student_id, long parent_id, String student_name, String grade) {
        Notification n = new Notification();
        n.setInstructor_id(instructor_id);
        n.setParent_id(parent_id);
        n.setStudent_id(student_id);
        n.setNotification_type(NotificationType.SOS_ALERT);
        n.setTitle(this.messageRepository.getMessage().getSos_alert_title());
        n.setTitle_es(this.messageRepository.getMessage().getSos_alert_title_es());
        n.setText(this.messageRepository.getMessage().getSos_alert_message().replace("<grade>", grade));
        n.setText_es(this.messageRepository.getMessage().getSos_alert_message_es().replace("<grade>", grade));
        n.setFormat_text(student_name);
        this.notificationRepository.save((Object)n);
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getFormat_text() + " " + n.getText() + "\"}";
        this.realTimeMessageService.sendMessage(Long.valueOf(instructor_id), json_message);
    }

    public void sendEmotionNotification(long student_id, String student_name, long instructor_id, long parent_id, long corporate_id, String text, String text_es) {
        Notification n = new Notification();
        n.setStudent_id(student_id);
        n.setInstructor_id(instructor_id);
        n.setParent_id(parent_id);
        n.setText(text);
        n.setText_es(text_es);
        n.setFormat_text(student_name);
        this.notificationRepository.save((Object)n);
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getFormat_text() + " " + n.getText() + "\"}";
        this.restComponent.setNewNotificationsForInstructor(Long.valueOf(instructor_id), true);
        this.realTimeMessageService.sendMessage(Long.valueOf(instructor_id), json_message);
        if (parent_id > 0L) {
            this.restComponent.setNewNotificationsForParent(parent_id, true);
            this.realTimeMessageService.sendMessage(Long.valueOf(parent_id), json_message);
        }
        if (corporate_id > 0L) {
            this.restComponent.setNewNotificationsForCorporate(corporate_id, true);
            this.realTimeMessageService.sendMessage(Long.valueOf(corporate_id), json_message);
        }
    }
}

