/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosrequest.service;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.instructor.response.GetInstructorEmailResponse;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.response.GetSchoolEmailResponse;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.repository.SOSRequestRepository;
import com.infinite.focus.server.sosrequest.request.SOSAnswerRequest;
import com.infinite.focus.server.sosrequest.service.SOSRequestService;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestForInstructorWrapper;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestWrapper;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SOSRequestServiceImpl
implements SOSRequestService {
    @Autowired
    MessageService messageService;
    @Autowired
    private SOSRequestRepository sosRequestRepository;
    @Autowired
    private RestComponent restComponent;

    public SOSRequestWrapper create(long student_id, long ask_for_help_id, List<SOSAnswerRequest> answers) {
        if (ask_for_help_id > 0L) {
            AskForHelpDTO askForHelpDTO = this.restComponent.getAskForHelpById(ask_for_help_id);
            if (askForHelpDTO == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.ask.for.help.id.is.not.valid"));
            }
            if (askForHelpDTO.getSos_request_id() > 0L) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("sos.request.is.already.submitted.for.the.ask.for.help.id"));
            }
        }
        int activeQuestionCount = (int)this.restComponent.getActiveSOSQuestionCount();
        if (AppUtils.isNullOrEmpty(answers)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("options.are.not.found"));
        }
        if (answers.size() != activeQuestionCount) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("all.active.questions.answers.are.not.found"));
        }
        SOSRequestDTO sosRequestDTO = this.sosRequestRepository.create(student_id, ask_for_help_id);
        ArrayList<SOSAnswerDTO> sosAnswerDTOS = new ArrayList<SOSAnswerDTO>();
        for (SOSAnswerRequest sosAnswerRequest : answers) {
            for (Long sos_option_id : sosAnswerRequest.getSos_option_ids()) {
                sosAnswerDTOS.add(SOSAnswerDTO.builder().sos_answer_id(0L).sos_request_id(sosRequestDTO.getSos_request_id()).sos_question_id(sosAnswerRequest.getSos_question_id()).sos_option_id(sos_option_id.longValue()).build());
            }
        }
        List answerDTOS = this.restComponent.createSOSAnswers(sosAnswerDTOS);
        if (ask_for_help_id > 0L) {
            this.restComponent.setSOSRequestId(ask_for_help_id, sosRequestDTO.getSos_request_id());
        }
        return SOSRequestWrapper.builder().request(sosRequestDTO).answers(answerDTOS).build();
    }

    public SOSRequestDTO getSOSRequestByAskForHelpId(long ask_for_help_id) {
        AskForHelpDTO askForHelpDTO = this.restComponent.getAskForHelpById(ask_for_help_id);
        if (askForHelpDTO != null) {
            return this.sosRequestRepository.findById(askForHelpDTO.getSos_request_id());
        }
        return null;
    }

    @Async
    public void setSOSNotificationToInstructor(long instructor_id, long student_id, long parent_id, String student_name, String grade) {
        this.restComponent.sendSOSAlertNotificationToInstructor(instructor_id, student_id, parent_id, student_name, grade);
    }

    @Async
    public void setSOSEmailToInstructor(long instructor_id, String student_name, String grade, String language) {
        GetInstructorEmailResponse getInstructorEmailResponse = this.restComponent.getInstructorEmailByInstructorId(instructor_id);
        this.restComponent.sendSOSEmailToOrganization(getInstructorEmailResponse.getEmail(), student_name, grade, language);
    }

    @Async
    public void setSOSEmailToOrganization(long school_id, String student_name, String grade, String language) {
        GetSchoolEmailResponse getSchoolEmailResponse = this.restComponent.getSchoolEmailBySchoolId(school_id);
        this.restComponent.sendSOSEmailToOrganization(getSchoolEmailResponse.getEmail(), student_name, grade, language);
    }

    public int getSOSRequestNotViewedCountByInstructorId(long instructor_id) {
        HashSet student_ids = new HashSet(this.restComponent.getStudentIdsByInstructorId(instructor_id));
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestByInstructorId(long instructor_id, String name, List<Long> students_ids, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        HashSet ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)name)) {
            ids.addAll(this.restComponent.getStudentsByInstructorIdAndStudentName(instructor_id, name).stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()));
        } else {
            ids.addAll(this.restComponent.getStudentIdsByInstructorId(instructor_id));
        }
        if (!AppUtils.isNullOrEmpty(students_ids)) {
            List filtered = ids.stream().filter(students_ids::contains).collect(Collectors.toList());
            ids.clear();
            ids.addAll(filtered);
        }
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(ids, fromDate, toDate, (Pageable)paging);
        List standardDTOS = this.restComponent.getAllStandards();
        List studentDTOS = this.restComponent.getStudentsByIds(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList()));
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed()) {
                this.sosRequestRepository.updateViewed(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id().longValue() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id().longValue()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public int getSOSRequestNotViewedCountBySchoolId(long school_id) {
        Set student_ids = this.restComponent.getStudentIdsBySchoolId(school_id);
        if (AppUtils.isNullOrEmpty((Set)student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountForSchoolByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestBySchoolIdAndStudentDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Set student_ids = this.restComponent.getStudentIdsBySchoolIdAndStudentDemographics(school_id, name, ages, genders, ethnicity, gradeIds, classIds);
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(student_ids, fromDate, toDate, (Pageable)paging);
        List studentDTOS = this.restComponent.getStudentsByIds(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList()));
        List standardDTOS = this.restComponent.getAllStandards();
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed_by_school()) {
                this.sosRequestRepository.updateViewedForSchool(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id().longValue() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id().longValue()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }
}

