/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.duration;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.duration.StreakDurationService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreakDurationServiceImpl
implements StreakDurationService {
    @Autowired
    StreakRepository streakRepository;
    @Autowired
    StudentStreakRepository studentStreakRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    StreakHelper streakHelper;

    public void addStreakDays(StudentView student) {
        Account account = this.accountRepository.findByAccountId(student.getAccount_id().longValue());
        long days = DateUtils.getDaysCountBetweenFromDateAndToDate((Date)account.getCreatedAt(), (Date)new Date());
        List streaks = this.streakRepository.findByStreakType(StreakType.DAYS_STREAK.name());
        for (Streak streak : streaks) {
            List activities;
            if ((long)streak.getOccurrence() != days || AppUtils.isNullOrEmpty((List)(activities = this.activityRepository.findByActivityTypeIdAndStudentIdAndBetweenFromDateAndToDateOrderByActivityIdASC(1L, student.getStudent_id().longValue(), DateUtils.getDateInString((Date)account.getCreatedAt()), DateUtils.getDateInString((Date)new Date())))) || this.studentStreakRepository.findByStudentIdAndStreakId(student.getStudent_id(), Long.valueOf(streak.getStreak_id())) != null) continue;
            this.streakHelper.saveStudentStreak(student.getStudent_id().longValue(), streak);
        }
    }

    public void addStreakWeek(StudentView student) {
        Account account = this.accountRepository.findByAccountId(student.getAccount_id().longValue());
        long weeks = DateUtils.getWeeksCountBetweenFromDateAndToDate((Date)account.getCreatedAt(), (Date)new Date());
        List streaks = this.streakRepository.findByStreakType(StreakType.WEEK_STREAK.name());
        for (Streak streak : streaks) {
            List activities;
            if ((long)streak.getOccurrence() != weeks || AppUtils.isNullOrEmpty((List)(activities = this.activityRepository.findByActivityTypeIdAndStudentIdAndBetweenFromDateAndToDateOrderByActivityIdASC(1L, student.getStudent_id().longValue(), DateUtils.getDateInString((Date)account.getCreatedAt()), DateUtils.getDateInString((Date)new Date())))) || this.studentStreakRepository.findByStudentIdAndStreakId(student.getStudent_id(), Long.valueOf(streak.getStreak_id())) != null) continue;
            this.streakHelper.saveStudentStreak(student.getStudent_id().longValue(), streak);
        }
    }

    public void addStreakMonth(StudentView student) {
        Account account = this.accountRepository.findByAccountId(student.getAccount_id().longValue());
        long months = DateUtils.getMonthsCountBetweenFromDateAndToDate((Date)account.getCreatedAt(), (Date)new Date());
        List streaks = this.streakRepository.findByStreakType(StreakType.MONTH_STREAK.name());
        for (Streak streak : streaks) {
            List activities;
            if ((long)streak.getOccurrence() != months || AppUtils.isNullOrEmpty((List)(activities = this.activityRepository.findByActivityTypeIdAndStudentIdAndBetweenFromDateAndToDateOrderByActivityIdASC(1L, student.getStudent_id().longValue(), DateUtils.getDateInString((Date)account.getCreatedAt()), DateUtils.getDateInString((Date)new Date())))) || this.studentStreakRepository.findByStudentIdAndStreakId(student.getStudent_id(), Long.valueOf(streak.getStreak_id())) != null) continue;
            this.streakHelper.saveStudentStreak(student.getStudent_id().longValue(), streak);
        }
    }
}

