/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentbadge.service;

import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.badge.repository.BadgeRepository;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.fcm.StudentPushNotification;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.fcm.model.NotificationType;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentbadge.entity.StudentBadge;
import com.infinite.focus.server.studentbadge.model.AssignedByType;
import com.infinite.focus.server.studentbadge.repository.StudentBadgeRepository;
import com.infinite.focus.server.studentbadge.service.StudentBadgeService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class StudentBadgeServiceImpl
implements StudentBadgeService {
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    StudentBadgeRepository studentBadgeRepository;
    @Autowired
    StudentPushNotificationRepository studentPushNotificationRepository;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    BadgeRepository badgeRepository;
    @Autowired
    ConfigurationRepository configurationRepository;

    @Async
    @Transactional
    public void assignBadgeToStudents(List<Long> student_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        for (long id : student_ids) {
            StudentBadge studentBadge = new StudentBadge();
            studentBadge.setStudent_id(id);
            studentBadge.setAssigned_by_type(assigned_by_type);
            studentBadge.setAssigned_by_id(assigned_by_id);
            studentBadge.setBadge_id(badge_id);
            Badge badge = this.badgeRepository.findByBadgeId(Long.valueOf(badge_id));
            if (badge != null) {
                title = badge.getTitle();
                title_es = badge.getTitle_es();
                description = badge.getDescription();
                description_es = badge.getDescription_es();
            }
            studentBadge.setTitle(title);
            studentBadge.setTitle_es(title_es);
            studentBadge.setDescription(description);
            studentBadge.setDescription_es(description_es);
            this.studentBadgeRepository.save((Object)studentBadge);
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(id);
            studentPushNotification.setNotification_type(NotificationType.BADGE_RECEIVED);
            studentPushNotification.setTitle("Badge Received");
            studentPushNotification.setTitle_es("Insignia Recibida");
            studentPushNotification.setMessage("gave you a badge: " + title);
            studentPushNotification.setMessage_es("te dio una insignia: " + title);
            studentPushNotification.setFormat_text(name);
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
            this.realTimeMessageService.sendTitleAndMessage(id, studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
            Student student = this.studentRepository.findByStudentId(Long.valueOf(id));
            student.setNew_notificaitons(true);
            this.studentRepository.save((Object)student);
        }
    }

    @Async
    @Transactional
    public void assignBadgeToClasses(List<Long> class_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        HashSet student_ids = new HashSet();
        for (long id : class_ids) {
            Set ids = this.classRepository.findStudentViewsByClassId(id).stream().map(StudentView::getStudent_id).collect(Collectors.toSet());
            student_ids.addAll(ids);
        }
        if (!AppUtils.isNullOrEmpty(student_ids)) {
            this.assignBadgeToStudents(new ArrayList(student_ids), assigned_by_type, assigned_by_id, name, badge_id, title, title_es, description, title_es);
        }
    }

    public Page<StudentBadge> getStudentBadgeByStudentId(Long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.studentBadgeRepository.findByStudentId(student_id, (Pageable)paging);
        return pagedResult;
    }

    public List<Badge> getStudentBadgeByStudentId(Long student_id) {
        String badgeImagesPath = this.configurationRepository.getConfiguration().getBadge_images_path();
        List badges = this.badgeRepository.findAllBadgesOrderByBadgeIdAsc();
        ArrayList<Badge> badgeWithIdZero = new ArrayList<Badge>();
        block0: for (StudentBadge studentBadge : this.studentBadgeRepository.findByStudentIdOrderByStudentBadgeIdDESC(student_id)) {
            Badge badge2 = this.badgeRepository.findByBadgeId(Long.valueOf(studentBadge.getBadge_id()));
            if (badge2 != null) {
                for (Badge item : badges) {
                    if (item.getBadge_id() != studentBadge.getBadge_id()) continue;
                    item.setCount(item.getCount() + 1L);
                    continue block0;
                }
                continue;
            }
            Badge badgeWitZeroId = new Badge();
            badgeWitZeroId.setTitle(studentBadge.getTitle());
            badgeWitZeroId.setTitle_es(studentBadge.getTitle_es());
            badgeWitZeroId.setDescription(studentBadge.getDescription());
            badgeWitZeroId.setDescription_es(studentBadge.getDescription_es());
            badgeWitZeroId.setImage("Badge.png");
            badgeWitZeroId.setCount(1L);
            badgeWitZeroId.setShould_show_on_front(true);
            badgeWitZeroId.setCreatedAt(studentBadge.getCreatedAt());
            badgeWithIdZero.add(badgeWitZeroId);
        }
        badges.addAll(badgeWithIdZero);
        return badges.stream().peek(badge -> badge.setImage(badgeImagesPath + badge.getImage())).sorted((c1, c2) -> Long.compare(c2.getCount(), c1.getCount())).collect(Collectors.toList());
    }
}

