/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.wallpost;

import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.wallpost.StreakWallPostService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.repository.WallPostRepository;
import com.infinite.focus.server.wallpostattachment.repository.WallPostAttachmentRepository;
import com.infinite.focus.server.wallpostreaction.repository.WallPostReactionRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreakWallPostServiceImpl
implements StreakWallPostService {
    @Autowired
    WallPostRepository wallPostRepository;
    @Autowired
    WallPostAttachmentRepository wallPostAttachmentRepository;
    @Autowired
    WallPostReactionRepository wallPostReactionRepository;
    @Autowired
    StreakRepository streakRepository;
    @Autowired
    StudentStreakRepository studentStreakRepository;
    @Autowired
    StreakHelper streakHelper;

    public Streak addStreakWallPost(long student_id) {
        List wallPosts = this.wallPostRepository.findByStudentId(student_id).stream().filter(wallPost -> AppUtils.isNullOrEmpty((List)this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(wallPost.getWall_post_id())))).collect(Collectors.toList());
        List streaks = this.streakRepository.findByStreakType(StreakType.WOW_POST.name());
        for (Streak streak : streaks) {
            if (streak.getOccurrence() != wallPosts.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }

    public Streak addStreakWallPostPicture(long student_id) {
        List wallPosts = this.wallPostRepository.findByStudentId(student_id).stream().filter(wallPost -> !AppUtils.isNullOrEmpty((List)this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(wallPost.getWall_post_id())))).collect(Collectors.toList());
        List streaks = this.streakRepository.findByStreakType(StreakType.WOW_POST_PICTURE.name());
        for (Streak streak : streaks) {
            if (streak.getOccurrence() != wallPosts.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }

    public Streak addStreakWallPostReaction(long student_id) {
        List wallPostReactions = this.wallPostReactionRepository.findByStudentId(student_id);
        List streaks = this.streakRepository.findByStreakType(StreakType.WOW_REACTION.name());
        for (Streak streak : streaks) {
            if (streak.getOccurrence() != wallPostReactions.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }
}

