/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpushnotification.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedPushNotification;
import com.infinite.focus.server.studentpushnotification.service.StudentPushNotificationService;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StudentPushNotificationServiceImpl
implements StudentPushNotificationService {
    private final MessageService messageService;
    private final ConfigurationRepository configurationRepository;
    private final StudentPushNotificationRepository studentPushNotificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final StudentRepository studentRepository;
    private final RestComponent restComponent;

    public StudentPushNotificationServiceImpl(MessageService messageService, ConfigurationRepository configurationRepository, StudentPushNotificationRepository studentPushNotificationRepository, RealTimeMessageService realTimeMessageService, StudentRepository studentRepository, RestComponent restComponent) {
        this.messageService = messageService;
        this.configurationRepository = configurationRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.studentRepository = studentRepository;
        this.restComponent = restComponent;
    }

    public void sendWOWPostNotification(Long student_id) {
        if (this.studentPushNotificationRepository.findByStudentIdAndNotificationType(student_id, NotificationType.WOW_POST.toString()) == null) {
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(student_id.longValue());
            studentPushNotification.setNotification_type(NotificationType.WOW_POST);
            studentPushNotification.setTitle(this.configurationRepository.getConfiguration().getWow_post_title());
            studentPushNotification.setMessage(this.configurationRepository.getConfiguration().getWow_post_message());
            studentPushNotification.setTitle_es(this.configurationRepository.getConfiguration().getWow_post_title_es());
            studentPushNotification.setMessage_es(this.configurationRepository.getConfiguration().getWow_post_message_es());
            studentPushNotification.setCreatedAt(new Date());
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
            try {
                Student student = this.studentRepository.findByStudentId(student_id);
                student.setNew_notificaitons(true);
                this.studentRepository.save((Object)student);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.realTimeMessageService.sendTitleAndMessage(student_id.longValue(), studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
        }
    }

    public boolean isThereNewNotificationAvailable(String approvedDate, Long student_id) {
        StudentPushNotification studentPushNotification = this.studentPushNotificationRepository.findTopFirstGreaterThanEqualToStudentApproveDateAndStudentId(approvedDate, student_id);
        return !studentPushNotification.isViewed();
    }

    public void send(long student_id, NotificationType notification_type, String format_text, String title, String message, String title_es, String message_es) {
        Student student = this.restComponent.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(student.getStudent_id());
        studentPushNotification.setNotification_type(notification_type);
        studentPushNotification.setFormat_text(format_text);
        studentPushNotification.setTitle(title);
        studentPushNotification.setTitle_es(title_es);
        studentPushNotification.setMessage(message);
        studentPushNotification.setMessage_es(message_es);
        if (!student.isDemo()) {
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
        }
        this.realTimeMessageService.sendTitleAndMessage(student_id, studentPushNotification.getTitle(), studentPushNotification.getMessage());
        ArrayList<Long> student_ids = new ArrayList<Long>();
        student_ids.add(student_id);
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
    }

    public StudentPushNotification createBadgeReceived(long student_id, NotificationType notificationType, String title, String message, String title_es, String message_es, String format_text) {
        StudentPushNotification studentPushNotification = new StudentPushNotification();
        studentPushNotification.setStudent_id(student_id);
        studentPushNotification.setNotification_type(notificationType);
        studentPushNotification.setTitle(title);
        studentPushNotification.setTitle_es(title_es);
        studentPushNotification.setMessage(message);
        studentPushNotification.setMessage_es(message_es);
        studentPushNotification.setFormat_text(format_text);
        return studentPushNotification;
    }

    public void badgeReceived(List<BadgeReceivedPushNotification> badgeReceivedPushNotifications) {
        ArrayList<StudentPushNotification> studentPushNotifications = new ArrayList<StudentPushNotification>();
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        ArrayList<Long> student_ids = new ArrayList<Long>();
        for (BadgeReceivedPushNotification badgeReceivedPushNotification : badgeReceivedPushNotifications) {
            StudentPushNotification studentPushNotification = this.createBadgeReceived(badgeReceivedPushNotification.getStudent_id(), NotificationType.BADGE_RECEIVED, "Badge Received", "gave you a badge: " + badgeReceivedPushNotification.getTitle(), "Insignia Recibida", "te dio una insignia: " + badgeReceivedPushNotification.getTitle_es(), badgeReceivedPushNotification.getFormat_text());
            studentPushNotifications.add(studentPushNotification);
            PushNotificationDTO pushNotificationDTO = PushNotificationDTO.builder().push_notification_id(0L).account_id(badgeReceivedPushNotification.getAccount_id()).title(studentPushNotification.getTitle()).message(studentPushNotification.getMessage()).screen_type(studentPushNotification.getNotification_type()).build();
            pushNotificationDTOS.add(pushNotificationDTO);
            student_ids.add(badgeReceivedPushNotification.getStudent_id());
        }
        this.studentPushNotificationRepository.saveAll(studentPushNotifications);
        this.restComponent.setNewNotificationsForStudent(student_ids, true);
        try {
            this.restComponent.sendFirebasePushNotification(SendFirebasePushNotificationRequest.builder().push_notifications(pushNotificationDTOS).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (StudentPushNotification studentPushNotification : studentPushNotifications) {
                this.realTimeMessageService.sendTitleAndMessage(studentPushNotification.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getFormat_text() + " " + studentPushNotification.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

