/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.content;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.content.StreakContentService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreakContentServiceImpl
implements StreakContentService {
    @Autowired
    PostRepository postRepository;
    @Autowired
    StreakRepository streakRepository;
    @Autowired
    StudentStreakRepository studentStreakRepository;
    @Autowired
    StreakHelper streakHelper;

    public Streak addStreakSELCurriculumArticle(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.SEL_CURRICULUM_ARTICLE);
    }

    public Streak addStreakEnergizingExercises(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.ENERGIZING_EXERCISES);
    }

    public Streak addStreakCopingCues(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.COPING_CUES);
    }

    public Streak addStreakMindfulStretches(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFUL_STRETCHES);
    }

    public Streak addStreakMindfulnessVideos(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFULNESS_VIDEOS);
    }

    public Streak addStreakGrowthMindsets(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.GROWTH_MINDSETS);
    }

    private Streak addStreakByStreakType(long student_id, List<Activity> activities, StreakType streakType) {
        Set posts;
        if (!AppUtils.isNullOrEmpty(activities) && !AppUtils.isNullOrEmpty(posts = activities.stream().map(activity -> this.postRepository.findById(activity.getEntity_id())).filter(post -> post.getContents().stream().filter(content -> content.getStreak_type().equals((Object)streakType)).findFirst().orElse(null) != null).map(PostDTO::getPost_id).collect(Collectors.toSet()))) {
            List streaks = this.streakRepository.findByStreakType(streakType.name());
            for (Streak streak : streaks) {
                if (streak.getOccurrence() != posts.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
                return this.streakHelper.saveStudentStreak(student_id, streak);
            }
        }
        return null;
    }
}

