/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpost.controller;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.infinite.focus.server.admin.entity.Admin;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.entity.Notification;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.streak.entity.Streak;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.service.wallpost.StreakWallPostService;
import com.infinite.focus.server.toppicks.entity.TopPicks;
import com.infinite.focus.server.toppicks.repository.TopPicksRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.model.Reaction;
import com.infinite.focus.server.wallpost.model.WallPostType;
import com.infinite.focus.server.wallpost.repository.WallPostRepository;
import com.infinite.focus.server.wallpost.request.AddWallPostReactionRequest;
import com.infinite.focus.server.wallpost.request.AddWallPostViewRequest;
import com.infinite.focus.server.wallpost.request.CheckBadWordsInStringRequest;
import com.infinite.focus.server.wallpost.request.GetAllPostsRequest;
import com.infinite.focus.server.wallpost.request.GetWallPostsWithBadWordsRequest;
import com.infinite.focus.server.wallpost.request.RespondRequest;
import com.infinite.focus.server.wallpost.request.WallPostDeleteRequest;
import com.infinite.focus.server.wallpost.request.WallPostsDeleteRequest;
import com.infinite.focus.server.wallpost.response.AddWallPostReactionResponse;
import com.infinite.focus.server.wallpost.response.CreateWallPostResponse;
import com.infinite.focus.server.wallpost.response.GetWallPostsWithBadWordsResponse;
import com.infinite.focus.server.wallpost.service.WallPostService;
import com.infinite.focus.server.wallpost.wrapper.WallPostProfileWrapper;
import com.infinite.focus.server.wallpost.wrapper.WallPostRequestWrapper;
import com.infinite.focus.server.wallpost.wrapper.WallPostWrapper;
import com.infinite.focus.server.wallpostattachment.entity.WallPostAttachment;
import com.infinite.focus.server.wallpostattachment.repository.WallPostAttachmentRepository;
import com.infinite.focus.server.wallpostrequest.entity.WallPostRequest;
import com.infinite.focus.server.wallpostrequest.request.WallPostRequestRepository;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/wall"})
public class WallPostController {
    private final StudentRepository studentRepository;
    private final InstructorRepository instructorRepository;
    private final SchoolRepository schoolRepository;
    private final WallPostRepository wallPostRepository;
    private final WallPostAttachmentRepository wallPostAttachmentRepository;
    private final WallPostRequestRepository wallPostRequestRepository;
    private final TopPicksRepository topPicksRepository;
    private final WallPostService wallPostService;
    private final AuthService authService;
    private final StudentPushNotificationRepository studentPushNotificationRepository;
    private final StreakWallPostService streakWallPostService;
    private final NotificationRepository notificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final ParentService parentService;
    private final StreakRepository streakRepository;
    private final PostRepository postRepository;
    private final StreakHelper streakHelper;
    private final MessageService messageService;
    private final RestComponent restComponent;

    public WallPostController(StudentRepository studentRepository, InstructorRepository instructorRepository, SchoolRepository schoolRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, TopPicksRepository topPicksRepository, WallPostService wallPostService, AuthService authService, StudentPushNotificationRepository studentPushNotificationRepository, StreakWallPostService streakWallPostService, NotificationRepository notificationRepository, RealTimeMessageService realTimeMessageService, ParentService parentService, StreakRepository streakRepository, PostRepository postRepository, StreakHelper streakHelper, MessageService messageService, RestComponent restComponent) {
        this.studentRepository = studentRepository;
        this.instructorRepository = instructorRepository;
        this.schoolRepository = schoolRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.topPicksRepository = topPicksRepository;
        this.wallPostService = wallPostService;
        this.authService = authService;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.streakWallPostService = streakWallPostService;
        this.notificationRepository = notificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.parentService = parentService;
        this.streakRepository = streakRepository;
        this.postRepository = postRepository;
        this.streakHelper = streakHelper;
        this.messageService = messageService;
        this.restComponent = restComponent;
    }

    @PostMapping(value={"/respond/request"})
    public ResponseEntity<WallPost> respondRequest(@RequestHeader(value="Authorization") String token, @RequestBody RespondRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.wallPostService.approveRejectWallPost(request), HttpStatus.OK);
    }

    @PostMapping(value={"/respond/request/by/wall/post/id"})
    public ResponseEntity<WallPost> respondRequestByWallPostId(@RequestHeader(value="Authorization") String token, @RequestBody RespondRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.wallPostService.approveRejectWallPostByWallPostId(request), HttpStatus.OK);
    }

    @GetMapping(value={"/add/like"})
    public ResponseEntity<WallPost> addLike(@RequestParam(value="wall_post_id", defaultValue="aEn24") Long wall_post_id) {
        WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
        if (wp == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        wp.setLikes(wp.getLikes() + 1);
        return new ResponseEntity(this.wallPostRepository.save((Object)wp), HttpStatus.OK);
    }

    @PostMapping(value={"/add/reaction"})
    public ResponseEntity<AddWallPostReactionResponse> addReaction(@RequestHeader(value="Authorization") String token, @RequestBody AddWallPostReactionRequest request) {
        Student student = this.authService.isStudent(token);
        WallPost wallPost = this.wallPostService.addWallPostReaction(student.getStudent_id(), request.getWall_post_id(), request.getReaction());
        if (student.getStudent_id() != wallPost.getStudent_id()) {
            StudentPushNotification studentPushNotification = new StudentPushNotification();
            studentPushNotification.setStudent_id(wallPost.getStudent_id());
            studentPushNotification.setNotification_type(NotificationType.WOW_REACTION);
            String message = "reacted " + this.getReactionCodeByReaction(request.getReaction());
            message = !AppUtils.isNullOrEmpty((String)wallPost.getText()) ? message + " on your WoW post: " + wallPost.getText() : message + " on your WoW post";
            studentPushNotification.setTitle("Received reaction on WoW Post");
            studentPushNotification.setTitle_es("Recibiste una reacci\u00f3n en tu publicaci\u00f3n del Muro de las Maravillas.");
            studentPushNotification.setMessage(message);
            String message_es = "reaccion\u00f3 " + this.getReactionCodeByReaction(request.getReaction());
            message_es = !AppUtils.isNullOrEmpty((String)wallPost.getText()) ? message_es + " en tu publicaci\u00f3n del Muro de las Maravillas: " + wallPost.getText() : message_es + " en tu publicaci\u00f3n del Muro de las Maravillas.";
            studentPushNotification.setMessage_es(message_es);
            studentPushNotification.setFormat_text(student.getFirst_name().trim() + " " + student.getLast_name().trim());
            this.studentPushNotificationRepository.save((Object)studentPushNotification);
            this.realTimeMessageService.sendTitleAndMessage(wallPost.getStudent_id(), studentPushNotification.getTitle(), studentPushNotification.getMessage());
        }
        AddWallPostReactionResponse addWallPostReactionResponse = new AddWallPostReactionResponse();
        addWallPostReactionResponse.setWall_post(wallPost);
        Streak streak = this.streakWallPostService.addStreakWallPostReaction(student.getStudent_id());
        addWallPostReactionResponse.setStreak(streak);
        return new ResponseEntity((Object)addWallPostReactionResponse, HttpStatus.OK);
    }

    @PostMapping(value={"/add/view"})
    public ResponseEntity<List<WallPost>> addReaction(@RequestHeader(value="Authorization") String token, @RequestBody AddWallPostViewRequest request) {
        Student student = this.authService.isStudent(token);
        List wallPosts = this.wallPostRepository.findAllWallPostIds(request.getWall_post_ids()).stream().filter(wallPost -> wallPost.getStudent_id() != student.getStudent_id()).peek(wallPost -> wallPost.setViews(wallPost.getViews() + 1L)).collect(Collectors.toList());
        this.wallPostRepository.saveAll(wallPosts);
        return new ResponseEntity(wallPosts, HttpStatus.OK);
    }

    @PostMapping(value={"/check/bad/words/in/string"})
    public ResponseEntity<Message> checkBadWordsInString(@RequestBody CheckBadWordsInStringRequest request) {
        Message message = new Message();
        ArrayList badWords = this.wallPostService.getWallPostBadWordFilterComponent().badWordsFoundCompareWordsOnly(request.getString_with_bad_words());
        if (!AppUtils.isNullOrEmpty((List)badWords)) {
            message.setMessage("Bad words are: " + StringUtils.join((Iterable)badWords, (String)","));
        } else {
            message.setMessage("There is no any bad word in string.");
        }
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    private String getReactionCodeByReaction(String reactionText) {
        Reaction reaction = Reaction.valueOf((String)reactionText);
        if (reaction.equals((Object)Reaction.STAR)) {
            reactionText = "&#x2B50";
        } else if (reaction.equals((Object)Reaction.EXCITED)) {
            reactionText = "&#x1F60D";
        } else if (reaction.equals((Object)Reaction.LAUGHTER)) {
            reactionText = "&#x1F602";
        } else if (reaction.equals((Object)Reaction.THUMBS_UP)) {
            reactionText = "&#x1F44D";
        } else if (reaction.equals((Object)Reaction.CELEBRATION)) {
            reactionText = "&#x1f973";
        }
        return reactionText;
    }

    @GetMapping(value={"/get/requests"})
    public ResponseEntity<List<WallPostRequestWrapper>> getRequests(@RequestHeader(value="Authorization") String token) {
        Instructor instructor = this.authService.getInstructorByToken(token);
        Parent parent = this.authService.getParentByToken(token);
        ArrayList<WallPostRequestWrapper> list = new ArrayList<WallPostRequestWrapper>();
        ArrayList wallPostRequests = new ArrayList();
        if (instructor != null) {
            wallPostRequests.addAll(this.wallPostRequestRepository.findByInstructorId(Long.valueOf(instructor.getInstructor_id())));
        } else if (parent != null) {
            wallPostRequests.addAll(this.wallPostRequestRepository.findByParentId(parent.getParent_id()));
        }
        for (WallPostRequest r : wallPostRequests) {
            WallPostRequestWrapper rw = new WallPostRequestWrapper();
            rw.setWallPostRequest(r);
            WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)r.getWall_post_id());
            Student student = this.studentRepository.findByStudentId(Long.valueOf(wp.getStudent_id()));
            wp.setStudent(student);
            if (wp.getWall_post_type().equals((Object)WallPostType.STREAK)) {
                Streak streak = this.streakRepository.findByStreakId(Long.valueOf(wp.getStreak_id()));
                rw.setStreak(this.streakHelper.getStreakFromStreak(streak));
            }
            if (wp.getWall_post_type().equals((Object)WallPostType.RESOURCE_LIBRARY)) {
                PostDTO post = this.postRepository.findById(wp.getPost_id());
                rw.setPost(post);
            }
            WallPostWrapper wr = new WallPostWrapper();
            Boolean thereAnyBadWordInText = this.wallPostService.getWallPostBadWordFilterComponent().isThereAnyBadWordInText(wp.getText());
            wr.setHasBadWords(thereAnyBadWordInText.booleanValue());
            if (student.getSchool() != null) {
                wr.setAuto_approve_wall_posts(student.getSchool().isAuto_approve_wall_posts());
            }
            wr.setWallPost(wp);
            wr.setAttachments(this.wallPostService.getWallPostAttachmentsByWallPostId(Long.valueOf(wp.getWall_post_id())));
            rw.setWallPost(wr);
            list.add(rw);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/instructor/posts"})
    public ResponseEntity<Page<WallPostProfileWrapper>> getWallPostsByInstructorId(@RequestHeader(value="Authorization") String token, @RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10000") Integer pageSize, @RequestParam(value="sortBy", defaultValue="approved_date") String sortBy, @RequestParam(value="orderBy", defaultValue="desc") String orderBy) {
        Instructor instructor = this.authService.isInstructor(token);
        return new ResponseEntity((Object)this.wallPostService.getWallPostsByInstructorId(instructor_id.longValue(), pageNo, pageSize, sortBy, orderBy), HttpStatus.OK);
    }

    @PostMapping(value={"/get/all/posts"})
    public ResponseEntity<Page<Object>> getWallPosts(@RequestHeader(value="Authorization") String token, @RequestBody GetAllPostsRequest request) {
        School school;
        this.authService.isAuthenticated(token);
        Student student = null;
        Instructor instructor = null;
        Admin admin = this.authService.getAdmin(token);
        if (admin == null && ((instructor = this.authService.getInstructorByToken(token)) != null ? (school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()))) != null && !school.isEnable_wow() : (student = this.authService.getStudentByToken(token)) != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()))) != null && !school.isEnable_wow())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.show.wow.posts.at.this.point.of.time.please.try.again.later"));
        }
        return new ResponseEntity((Object)this.wallPostService.getWallPosts(student, instructor, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), HttpStatus.OK);
    }

    @PostMapping(value={"/get/posts/by/student"})
    public ResponseEntity<Page<Object>> getWallPostsByStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetAllPostsRequest request) {
        School school;
        this.authService.isAuthenticated(token);
        Student student = this.authService.getStudentByToken(token);
        if (student != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()))) != null && !school.isEnable_wow()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.show.wow.posts.at.this.point.of.time.please.try.again.later"));
        }
        return new ResponseEntity((Object)this.wallPostService.getWallPostsByStudent(student, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), HttpStatus.OK);
    }

    @PostMapping(value={"/get/my/child/posts"})
    public ResponseEntity<Page<Object>> getWallPostsByParent(@RequestHeader(value="Authorization") String token, @RequestBody GetAllPostsRequest request) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity((Object)this.wallPostService.getMyChildPosts(parent, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), HttpStatus.OK);
    }

    @GetMapping(value={"/sync-wall-post-requests"})
    public ResponseEntity<List<WallPostRequest>> syncWallPostRequests(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.wallPostService.syncWallPostRequests(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/post"})
    @ResponseBody
    public ResponseEntity<CreateWallPostResponse> createPost(@RequestHeader(value="Authorization") String token, @RequestBody WallPostWrapper request) {
        Streak streakWallPostPicture;
        WallPost wallPost;
        School school;
        Student s = this.authService.getStudentByToken(token);
        if (s != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(s.getSchool_id()))) != null && !school.isEnable_wow()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.save.this.wow.post.at.this.point.of.time.please.try.again.later"));
        }
        Student student = this.studentRepository.findByStudentId(Long.valueOf(request.getWallPost().getStudent_id()));
        if (student == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        boolean auto_approve_wall_posts = false;
        if (student.getSchool() != null && student.getSchool().isAuto_approve_wall_posts()) {
            boolean bl = auto_approve_wall_posts = student.getInstructor() != null && student.getInstructor().isAuto_approve_wall_posts();
        }
        if (this.wallPostService.getWallPostBadWordFilterComponent().isThereAnyBadWordInText(request.getWallPost().getText()).booleanValue()) {
            auto_approve_wall_posts = false;
            this.restComponent.sendStudentPushNotification(student.getStudent_id(), NotificationType.WOW_POST_UNACCEPTABLE_CONTENT, null, this.messageService.getMessage().getUnacceptable_content_title(), this.messageService.getMessage().getUnacceptable_content_message(), this.messageService.getMessage().getUnacceptable_content_title_es(), this.messageService.getMessage().getUnacceptable_content_message_es());
        }
        request.getWallPost().setType("student");
        if (!auto_approve_wall_posts) {
            request.getWallPost().setIsActive(Boolean.valueOf(false));
        } else {
            request.getWallPost().setIsActive(Boolean.valueOf(true));
            request.getWallPost().setApproved_date(new Date());
        }
        request.getWallPost().setIsDeleted(Boolean.valueOf(false));
        if (student.isDemo()) {
            long id = this.wallPostRepository.getLastRecordId() + 1L;
            request.getWallPost().setWall_post_id(id);
            request.getWallPost().setCreatedAt(new Date());
            wallPost = request.getWallPost();
        } else {
            wallPost = (WallPost)this.wallPostRepository.save((Object)request.getWallPost());
        }
        for (WallPostAttachment w : request.getAttachments()) {
            w.setWall_post_id(wallPost.getWall_post_id());
            if (student.isDemo()) continue;
            this.wallPostAttachmentRepository.save((Object)w);
        }
        if (!auto_approve_wall_posts) {
            WallPostRequest wallPostRequest = new WallPostRequest();
            wallPostRequest.setInstructor_id(student.getInstructor() != null ? student.getInstructor().getInstructor_id() : 0L);
            wallPostRequest.setParent_id(student.getParent() != null ? student.getParent().getParent_id() : 0L);
            wallPostRequest.setWall_post_id(wallPost.getWall_post_id());
            if (!student.isDemo()) {
                this.wallPostRequestRepository.save((Object)wallPostRequest);
            }
        }
        CreateWallPostResponse createWallPostResponse = new CreateWallPostResponse();
        createWallPostResponse.setWall_post(wallPost);
        Streak streakWallPost = this.streakWallPostService.addStreakWallPost(student.getStudent_id());
        if (streakWallPost != null) {
            createWallPostResponse.setStreak(streakWallPost);
        }
        if ((streakWallPostPicture = this.streakWallPostService.addStreakWallPostPicture(student.getStudent_id())) != null) {
            createWallPostResponse.setStreak(streakWallPostPicture);
        }
        if (auto_approve_wall_posts) {
            return new ResponseEntity((Object)createWallPostResponse, HttpStatus.OK);
        }
        try {
            Notification notification = new Notification();
            notification.setNotification_type(NotificationType.WOW_POST_BY_STUDENT);
            notification.setStudent_id(student.getStudent_id());
            notification.setParent_id(student.getParent() != null && student.getParent().getCorporate_id() > 0L ? student.getParent().getParent_id() : 0L);
            notification.setInstructor_id(student.getInstructor() != null ? student.getInstructor().getInstructor_id() : 0L);
            notification.setTitle("Review WoW Post");
            notification.setTitle_es("Revisar publicaci\u00f3n del Muro de las Maravillas.");
            String message = null;
            message = !AppUtils.isNullOrEmpty((String)wallPost.getText()) ? " posted on WoW: " + wallPost.getText() : " posted on WoW";
            notification.setText(message);
            String message_es = null;
            message_es = !AppUtils.isNullOrEmpty((String)wallPost.getText()) ? " public\u00f3 en el Muro de las Maravillas: " + wallPost.getText() : " public\u00f3 en el Muro de las Maravillas.";
            notification.setText_es(message_es);
            notification.setFormat_text(student.getFirst_name().trim() + " " + student.getLast_name().trim());
            if (!student.isDemo()) {
                this.notificationRepository.save((Object)notification);
            }
            if (student.getInstructor() != null) {
                this.realTimeMessageService.sendTitleAndMessage(student.getInstructor().getInstructor_id(), notification.getTitle(), notification.getText());
            }
            if (student.getParent() != null) {
                this.realTimeMessageService.sendTitleAndMessage(student.getParent().getParent_id(), notification.getTitle(), notification.getText());
            }
            Instructor instructor = student.getInstructor();
            instructor.setNew_notificaitons(true);
            this.instructorRepository.save((Object)instructor);
            if (student.getParent() != null && student.getParent().getCorporate_id() > 0L) {
                this.parentService.setParentNewNotifications(student.getParent_id(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseEntity((Object)createWallPostResponse, HttpStatus.OK);
    }

    @PostMapping(value={"/create/post/instructor"})
    @ResponseBody
    public ResponseEntity<WallPost> createPostInstructor(@RequestHeader(value="Authorization") String token, @RequestBody WallPostWrapper request) {
        School school;
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (instructor != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()))) != null && !school.isEnable_wow()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.save.this.wow.post.at.this.point.of.time.please.try.again.later"));
        }
        request.getWallPost().setType("instructor");
        request.getWallPost().setIsActive(Boolean.valueOf(true));
        request.getWallPost().setApproved_date(new Date());
        WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)request.getWallPost());
        for (WallPostAttachment w : request.getAttachments()) {
            w.setWall_post_id(wallPost.getWall_post_id());
            this.wallPostAttachmentRepository.save((Object)w);
        }
        return new ResponseEntity((Object)wallPost, HttpStatus.OK);
    }

    @PostMapping(value={"/update/post"})
    @ResponseBody
    public ResponseEntity<WallPost> updatePost(@RequestHeader(value="Authorization") String token, @RequestBody WallPostWrapper request) {
        School school;
        Student student;
        School school2;
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (instructor != null ? (school2 = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()))) != null && !school2.isEnable_wow() : (student = this.authService.getStudentByToken(token)) != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(student.getSchool_id()))) != null && !school.isEnable_wow()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.update.this.wow.post.at.this.point.of.time.please.try.again.later"));
        }
        throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.update.this.wow.post.at.this.point.of.time.please.try.again.later"));
    }

    @PostMapping(value={"/delete/post"})
    @ResponseBody
    public ResponseEntity<WallPost> deletePost(@RequestBody WallPostDeleteRequest request, @RequestHeader(value="Authorization") String token) {
        Admin ad = this.authService.getAdmin(token);
        if (ad != null) {
            WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)request.getWall_post_id());
            if (wp == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
            }
            wp.setIsDeleted(Boolean.valueOf(true));
            wp.setDeleted_date(new Date());
            WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)wp);
            if (wallPost.getType().equalsIgnoreCase("student") && wallPost.getStudent_id() > 0L && !AppUtils.isNullOrEmpty((String)wallPost.getText()) && this.wallPostService.getWallPostBadWordFilterComponent().isThereAnyBadWordInText(wallPost.getText()).booleanValue()) {
                this.restComponent.sendStudentPushNotification(wallPost.getStudent_id(), NotificationType.WOW_POST_UNACCEPTABLE_CONTENT, null, this.messageService.getMessage().getUnacceptable_content_title(), this.messageService.getMessage().getUnacceptable_content_message(), this.messageService.getMessage().getUnacceptable_content_title_es(), this.messageService.getMessage().getUnacceptable_content_message_es());
            }
            return new ResponseEntity((Object)wallPost, HttpStatus.OK);
        }
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (instructor != null) {
            WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)request.getWall_post_id());
            if (wp == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
            }
            wp.setIsDeleted(Boolean.valueOf(true));
            wp.setDeleted_date(new Date());
            return new ResponseEntity(this.wallPostRepository.save((Object)wp), HttpStatus.OK);
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("admin.or.instructor.can.delete.the.post"));
    }

    @PostMapping(value={"/delete/posts"})
    @ResponseBody
    public ResponseEntity<WallPostsDeleteRequest> deletePosts(@RequestBody WallPostsDeleteRequest request, @RequestHeader(value="Authorization") String token) {
        Admin ad = this.authService.getAdmin(token);
        if (ad != null) {
            ArrayList wall_post_ids = request.getWall_post_ids();
            if (wall_post_ids == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("require.wall.post.ids"));
            }
            if (wall_post_ids.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("require.wall.post.ids"));
            }
            HashSet<Long> studentIds = new HashSet<Long>();
            for (Long wall_post_id : wall_post_ids) {
                WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
                if (wp == null) {
                    throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
                }
                wp.setIsDeleted(Boolean.valueOf(true));
                wp.setDeleted_date(new Date());
                WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)wp);
                if (!wallPost.getType().equalsIgnoreCase("student") || wallPost.getStudent_id() <= 0L || AppUtils.isNullOrEmpty((String)wallPost.getText()) || !this.wallPostService.getWallPostBadWordFilterComponent().isThereAnyBadWordInText(wallPost.getText()).booleanValue()) continue;
                studentIds.add(wallPost.getStudent_id());
            }
            if (!AppUtils.isNullOrEmpty(studentIds)) {
                this.sendNotificationForMultipleDeletePost(studentIds);
            }
            request.setMessage(this.messageService.getMessage("posts.deleted.successfully"));
            return new ResponseEntity((Object)request, HttpStatus.OK);
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, this.messageService.getMessage("admin.can.delete.the.posts"));
    }

    @Async
    private void sendNotificationForMultipleDeletePost(Set<Long> student_ids) {
        for (Long student_id : student_ids) {
            this.restComponent.sendStudentPushNotification(student_id.longValue(), NotificationType.WOW_POST_UNACCEPTABLE_CONTENT, null, this.messageService.getMessage().getUnacceptable_contents_title(), this.messageService.getMessage().getUnacceptable_contents_message(), this.messageService.getMessage().getUnacceptable_contents_title_es(), this.messageService.getMessage().getUnacceptable_contents_message_es());
        }
    }

    @PostMapping(value={"/upload/file"})
    @ResponseBody
    public ResponseEntity<WallPostAttachment> uploadImage(@RequestParam(value="file") MultipartFile file, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (!file.isEmpty()) {
            Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
            Map uploadResult = cloudinary.uploader().upload((Object)file.getBytes(), ObjectUtils.emptyMap());
            WallPostAttachment w = new WallPostAttachment();
            w.setUrl((String)uploadResult.get("url"));
            return new ResponseEntity((Object)w, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.PARTIAL_CONTENT);
    }

    @GetMapping(value={"/get/post"})
    public ResponseEntity<WallPostProfileWrapper> getWallPostByWallPostId(@RequestParam(value="wall_post_id", defaultValue="aEn24") Long wall_post_id) {
        WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
        if (wp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
        }
        if (wp.getIsDeleted() != null && wp.getIsDeleted().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.deleted"));
        }
        WallPostProfileWrapper wr = new WallPostProfileWrapper();
        WallPostWrapper wpr = new WallPostWrapper();
        wpr.setWallPost(wp);
        wpr.setAttachments(this.wallPostService.getWallPostAttachmentsByWallPostId(Long.valueOf(wp.getWall_post_id())));
        wr.setWallPost(wpr);
        if (wp.getType().toLowerCase().trim().equals("student")) {
            Student student = (Student)this.studentRepository.getOne((Object)wp.getStudent_id());
            wr.setStudent(student);
        }
        if (wp.getType().toLowerCase().trim().equals("instructor")) {
            Instructor instructor = (Instructor)this.instructorRepository.getOne((Object)wp.getInstructor_id());
            wr.setInstructor(instructor);
        }
        return new ResponseEntity((Object)wr, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily/toppicks"})
    public ResponseEntity<TopPicks> getCurrentDailyTopPicks(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        TopPicks topPicks = this.topPicksRepository.findDailyTopPicks();
        if (topPicks == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.daily.top.picks.not.found"));
        }
        return new ResponseEntity((Object)topPicks, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/toppicks/{top_picks_id}"})
    public ResponseEntity<Message> deleteQuote(@RequestHeader(value="Authorization") String token, @PathVariable(value="top_picks_id") Long top_picks_id) {
        this.authService.isAuthenticated(token);
        TopPicks topPicks = (TopPicks)this.topPicksRepository.getOne((Object)top_picks_id);
        if (topPicks == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.top.picks.not.found"));
        }
        if (topPicks.getIsDailyTopPicks().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.top.picks.is.a.daily.toppicks.the.daily.toppicks.can.not.be.deleted"));
        }
        this.topPicksRepository.deleteById((Object)top_picks_id);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.top.picks.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/toppicks"})
    public ResponseEntity<List<TopPicks>> getAllQuotes(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.topPicksRepository.findAllOrderById(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> createDailyQuote(@RequestHeader(value="Authorization") String token, @RequestBody TopPicks request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity(this.topPicksRepository.save((Object)request), HttpStatus.OK);
    }

    @PostMapping(value={"/update/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> updateDailyQuote(@RequestHeader(value="Authorization") String token, @RequestBody TopPicks request) {
        this.authService.isAuthenticated(token);
        TopPicks topPicks = (TopPicks)this.topPicksRepository.getOne((Object)request.getTop_picks_id());
        topPicks.setQuote(request.getQuote());
        topPicks.setQuote_es(request.getQuote_es());
        topPicks.setCreatedAt(topPicks.getCreatedAt());
        topPicks.setUpdateAt(new Date());
        return new ResponseEntity(this.topPicksRepository.save((Object)topPicks), HttpStatus.OK);
    }

    @GetMapping(value={"/make/daily/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> makeDailyQuote() {
        List topPicksList = this.topPicksRepository.findAll();
        for (TopPicks topPicks : topPicksList) {
            topPicks.setCreatedAt(topPicks.getCreatedAt());
            topPicks.setUpdateAt(new Date());
            topPicks.setIsDailyTopPicks(Boolean.valueOf(false));
            this.topPicksRepository.save((Object)topPicks);
        }
        Random randomizerTopPicks = new Random();
        int random_index_topPicks = randomizerTopPicks.nextInt(topPicksList.size());
        TopPicks random_topPicks = (TopPicks)topPicksList.get(random_index_topPicks);
        random_topPicks.setCreatedAt(random_topPicks.getCreatedAt());
        random_topPicks.setIsDailyTopPicks(Boolean.valueOf(true));
        random_topPicks.setUpdateAt(new Date());
        return new ResponseEntity(this.topPicksRepository.save((Object)random_topPicks), HttpStatus.OK);
    }

    @PostMapping(value={"/get-wall-posts-with-bad-words"})
    public ResponseEntity<GetWallPostsWithBadWordsResponse> getWallPostsWithBadWords(@RequestHeader(value="Authorization") String token, @RequestBody GetWallPostsWithBadWordsRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.wallPostService.getWallPostsWithBadWords(request.getFromDate()), HttpStatus.OK);
    }
}

