/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.home.controller;

import com.infinite.focus.server.appreciation.dto.AppreciationItem;
import com.infinite.focus.server.appreciation.entity.Appreciation;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.corporatenotification.entity.CorporateNotification;
import com.infinite.focus.server.corporatenotification.service.CorporateNotificationService;
import com.infinite.focus.server.dailyappreciation.entity.DailyAppreciation;
import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationRepository;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.home.request.GetAllDailyAppreciationForInstructorRequest;
import com.infinite.focus.server.home.request.GetAppreciationItemsRequest;
import com.infinite.focus.server.home.request.GetDailyAppreciationForStudentRequest;
import com.infinite.focus.server.home.request.GetNotificationsRequest;
import com.infinite.focus.server.home.request.GetSchoolsByDistrictRequest;
import com.infinite.focus.server.home.request.GetSocioEmotionalScoreRequest;
import com.infinite.focus.server.home.response.CreateDailyAppreciationResponse;
import com.infinite.focus.server.home.service.HomeService;
import com.infinite.focus.server.home.service.appreciation.AppreciationRepository;
import com.infinite.focus.server.home.wrapper.DailyAppreciationStudentWrapper;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.lessonrecord.entity.LessonRecord;
import com.infinite.focus.server.lessonrecord.repository.LessonRecordRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.notification.entity.Notification;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.notification.service.NotificationService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.quote.entity.Quote;
import com.infinite.focus.server.quote.repository.QuoteRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentstreak.service.appreciation.StreakAppreciationStationService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/home"})
public class HomeController {
    private final NotificationService notificationService;
    private final CorporateNotificationService corporateNotificationService;
    private final MessageService messageService;
    private final HomeService homeService;
    private final ParentService parentService;
    private final CorporateService corporateService;
    private final StreakAppreciationStationService streakAppreciationStationService;
    private final AuthService authService;
    private final StudentRepository studentRepository;
    private final InstructorRepository instructorRepository;
    private final QuoteRepository qouteRepository;
    private final MoodUpdateRepository moodUpdateRepository;
    private final DailyAppreciationRepository dailyAppreciationRepository;
    private final NotificationRepository notificationRepository;
    private final SchoolRepository schoolRepository;
    private final ClassRepository classRepository;
    private final LessonRepository lessonRepository;
    private final LessonRecordRepository lessonRecordRepository;
    private final SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final ConfigurationService configurationService;
    private final MoodRepository moodRepository;
    private final AppreciationRepository appreciationRepository;
    private final RestComponent restComponent;

    public HomeController(NotificationService notificationService, CorporateNotificationService corporateNotificationService, MessageService messageService, HomeService homeService, ParentService parentService, CorporateService corporateService, StreakAppreciationStationService streakAppreciationStationService, AuthService authService, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, LessonRepository lessonRepository, LessonRecordRepository lessonRecordRepository, ClassRepository classRepository, SchoolRepository schoolRepository, RealTimeMessageService realTimeMessageService, NotificationRepository notificationRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, ConfigurationService configurationService, MoodRepository moodRepository, AppreciationRepository appreciationRepository, RestComponent restComponent) {
        this.notificationService = notificationService;
        this.corporateNotificationService = corporateNotificationService;
        this.messageService = messageService;
        this.homeService = homeService;
        this.parentService = parentService;
        this.corporateService = corporateService;
        this.streakAppreciationStationService = streakAppreciationStationService;
        this.authService = authService;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.lessonRepository = lessonRepository;
        this.classRepository = classRepository;
        this.schoolRepository = schoolRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.notificationRepository = notificationRepository;
        this.qouteRepository = qouteRepository;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.configurationService = configurationService;
        this.moodRepository = moodRepository;
        this.appreciationRepository = appreciationRepository;
        this.restComponent = restComponent;
    }

    @PostMapping(value={"/get/schools/by/district"})
    public ResponseEntity<List<School>> getSchoolsByDistrict(@RequestBody GetSchoolsByDistrictRequest request) {
        return new ResponseEntity((Object)this.schoolRepository.findByDistrictId(request.getDistrict_id()), HttpStatus.OK);
    }

    @GetMapping(value={"/get/classes/by/school"})
    public ResponseEntity<List<Class>> getClassesBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List list = this.instructorRepository.findBySchoolId(school_id);
        ArrayList cs = new ArrayList();
        for (Instructor i : list) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                c.setClass_name(i.getFirst_name() + " " + i.getLast_name() + "'s " + c.getClass_name());
            }
            cs.addAll(classes);
        }
        return new ResponseEntity(cs, HttpStatus.OK);
    }

    @GetMapping(value={"/test/notification"})
    public ResponseEntity<Notification> sendTestNotification(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Notification n = new Notification();
        n.setInstructor_id(s.getInstructor_id());
        n.setParent_id(s.getParent_id());
        n.setStudent_id(s.getStudent_id());
        n.setText(s.getFirst_name() + " " + s.getLast_name() + " has selected mad or sad for more than 3 days in a row");
        n.setText_es(s.getFirst_name() + " " + s.getLast_name() + " has selected mad or sad for more than 3 days in a row");
        this.notificationRepository.save((Object)n);
        this.setInstructorNewNotifications(s.getInstructor_id(), true);
        this.parentService.setParentNewNotifications(s.getParent_id(), true);
        Parent parent = this.parentService.getParentById(s.getParent_id());
        if (parent != null && parent.getCorporate_id() > 0L) {
            this.corporateService.setCorporateNewNotifications(parent.getCorporate_id(), true);
        }
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getText() + "\"}";
        this.realTimeMessageService.sendMessage(Long.valueOf(s.getInstructor_id()), json_message);
        this.realTimeMessageService.sendMessage(Long.valueOf(s.getParent_id()), json_message);
        if (parent != null && parent.getCorporate_id() > 0L) {
            this.realTimeMessageService.sendMessage(Long.valueOf(parent.getCorporate_id()), json_message);
        }
        return new ResponseEntity((Object)n, HttpStatus.OK);
    }

    public void setInstructorNewNotifications(long instructor_id, boolean new_available) {
        try {
            Instructor instructor = this.instructorRepository.findByInstructorId(Long.valueOf(instructor_id));
            instructor.setNew_notificaitons(new_available);
            this.instructorRepository.save((Object)instructor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/get/notifications"})
    public ResponseEntity<Page<Notification>> getNotifications(@RequestHeader(value="Authorization") String token, @RequestParam(value="instructor_id", defaultValue="") Long instructor_id, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="notification_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        this.authService.isAuthenticated(token);
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = instructor_id == null ? this.notificationRepository.findAllNotifications((Pageable)paging) : this.notificationRepository.findByNotificationsByInstructorId(instructor_id, (Pageable)paging);
        if (AppUtils.isNotNullOrEmpty((List)pagedResult.getContent())) {
            this.setInstructorNewNotifications(instructor_id.longValue(), false);
        }
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/notifications"})
    @ResponseBody
    public ResponseEntity<Page<Notification>> getNotifications(@RequestBody GetNotificationsRequest request) {
        Page pagedResult = this.notificationService.getNotificationsByInstructorId(request);
        PageImpl pageNotifications = new PageImpl(pagedResult.stream().peek(notification -> {
            if (notification.getNotification_type().equals((Object)NotificationType.BAD_WORD_IN_JOURNAL)) {
                String message_es;
                String message = this.configurationService.getConfiguration().getJournal_bad_words_notification();
                if (message != null) {
                    message = message.replace("<name_of_student>", notification.getFormat_text());
                }
                if ((message_es = this.configurationService.getConfiguration().getJournal_bad_words_notification_es()) != null) {
                    message_es = message_es.replace("<name_of_student>", notification.getFormat_text());
                }
                notification.setMessage(message);
                notification.setMessage_es(message_es);
            }
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        long count = this.notificationRepository.getCountByInstructorId(request.getInstructor_id(), Boolean.valueOf(false));
        if (AppUtils.isNotNullOrEmpty((List)pageNotifications.getContent()) && count == 0L) {
            this.setInstructorNewNotifications(request.getInstructor_id().longValue(), false);
        }
        return new ResponseEntity((Object)pageNotifications, HttpStatus.OK);
    }

    @PostMapping(value={"/get/notifications/by/parent"})
    @ResponseBody
    public ResponseEntity<Page<Notification>> getNotificationsByParent(@RequestBody GetNotificationsRequest request) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        parentIds.add(request.getParent_id());
        Page pageNotifications = this.notificationService.getNotificationsByParentIds(request.getStudentIds(), parentIds, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate(), request.getViewed());
        long count = this.notificationRepository.getCountByParentId(request.getParent_id(), Boolean.valueOf(false));
        if (AppUtils.isNotNullOrEmpty((List)pageNotifications.getContent()) && count == 0L) {
            this.parentService.setParentNewNotifications(request.getParent_id().longValue(), false);
        }
        return new ResponseEntity((Object)pageNotifications, HttpStatus.OK);
    }

    @PostMapping(value={"/get/notifications/by/corporate"})
    @ResponseBody
    public ResponseEntity<Page<CorporateNotification>> getNotificationsByCorporate(@RequestBody GetNotificationsRequest request) {
        Page pageNotifications = this.corporateNotificationService.getCorporateNotificationsByCorporateId(request.getCorporate_id(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate());
        if (AppUtils.isNotNullOrEmpty((List)pageNotifications.getContent())) {
            this.corporateService.setCorporateNewNotifications(request.getCorporate_id().longValue(), false);
        }
        return new ResponseEntity((Object)pageNotifications, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily/quote"})
    public ResponseEntity<Quote> getCurrentDailyQuote() {
        Quote qoute = this.qouteRepository.findDailyQuote();
        return new ResponseEntity((Object)qoute, HttpStatus.OK);
    }

    @GetMapping(value={"/delete/daily/quote"})
    public ResponseEntity<Message> deleteQuote(@RequestParam(value="quote_id", defaultValue="aEn24") Long quote_id) {
        Quote quote = (Quote)this.qouteRepository.getOne((Object)quote_id);
        if (quote == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.quote.not.found"));
        }
        if (quote.getIsDailyQuote().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.quote.is.a.daily.quote.the.daily.quote.can.not.be.deleted"));
        }
        this.qouteRepository.deleteById((Object)quote_id);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.quote.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/daily/quotes"})
    public ResponseEntity<List<Quote>> getAllQuotes() {
        return new ResponseEntity((Object)this.qouteRepository.findAllOrderById(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/daily/quote"})
    @ResponseBody
    public ResponseEntity<Quote> createDailyQuote(@RequestBody Quote request) {
        return new ResponseEntity(this.qouteRepository.save((Object)request), HttpStatus.OK);
    }

    @PostMapping(value={"/update/daily/quote"})
    @ResponseBody
    public ResponseEntity<Quote> updateDailyQuote(@RequestBody Quote request) {
        Quote quote = (Quote)this.qouteRepository.getOne((Object)request.getQuote_id());
        quote.setText(request.getText());
        quote.setText_es(request.getText_es());
        quote.setAuthor(request.getAuthor());
        return new ResponseEntity(this.qouteRepository.save((Object)quote), HttpStatus.OK);
    }

    @PostMapping(value={"/create/mood_update"})
    @ResponseBody
    public ResponseEntity<MoodUpdateAndStreak> createMoodUpdate(@RequestBody MoodUpdate request) {
        MoodUpdateAndStreak moodUpdate = this.restComponent.createMoodUpdate(request);
        return new ResponseEntity((Object)moodUpdate, HttpStatus.OK);
    }

    @PostMapping(value={"/create/daily_appreciation"})
    @ResponseBody
    public ResponseEntity<CreateDailyAppreciationResponse> createDailyAppreciation(@RequestHeader(value="Authorization") String token, @RequestBody DailyAppreciation request) {
        DailyAppreciation dailyAppreciation;
        Student student = this.authService.getStudentByToken(token);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        if (student.isDemo()) {
            dailyAppreciation = request;
            long id = this.dailyAppreciationRepository.findLastRecordId() + 1L;
            dailyAppreciation.setDaily_appreciation_update_id(id);
        } else {
            dailyAppreciation = (DailyAppreciation)this.dailyAppreciationRepository.save((Object)request);
        }
        String appreciation_images_path = this.configurationService.getConfiguration().getAppreciation_images_path();
        Appreciation appreciation = this.appreciationRepository.findFirstByText(dailyAppreciation.getText());
        dailyAppreciation.setAppreciation_image(appreciation_images_path + appreciation.getImage());
        CreateDailyAppreciationResponse createDailyAppreciationResponse = new CreateDailyAppreciationResponse();
        createDailyAppreciationResponse.setDaily_appreciation(dailyAppreciation);
        StreakDTO streak = this.streakAppreciationStationService.addStreakAppreciationStation(dailyAppreciation.getStudent_id());
        createDailyAppreciationResponse.setStreak(streak);
        return new ResponseEntity((Object)createDailyAppreciationResponse, HttpStatus.OK);
    }

    @PostMapping(value={"/get/daily_appreciation/for/instructor/all"})
    public ResponseEntity<List<DailyAppreciationStudentWrapper>> getAllDailyAppreciationForInstructor(@RequestBody GetAllDailyAppreciationForInstructorRequest request) {
        ArrayList<DailyAppreciationStudentWrapper> list = new ArrayList<DailyAppreciationStudentWrapper>();
        Instructor i = (Instructor)this.instructorRepository.getOne((Object)request.getInstructor_id());
        if (i == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        List studentViews = this.studentRepository.findByInstructorId(request.getInstructor_id());
        for (StudentView studentView : studentViews) {
            for (DailyAppreciation d : this.dailyAppreciationRepository.findByStudent(studentView.getStudent_id())) {
                DailyAppreciationStudentWrapper w = new DailyAppreciationStudentWrapper();
                w.setDailyAppreciation(d);
                Student student = this.studentRepository.findByStudentId(studentView.getStudent_id());
                w.setStudent(student);
                list.add(w);
            }
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily_appreciation/for/instructor/today"})
    public ResponseEntity<List<DailyAppreciation>> getDailyAppreciationForInstructor(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList list = new ArrayList();
        Instructor i = (Instructor)this.instructorRepository.getOne((Object)instructor_id);
        if (i == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        List studentViews = this.studentRepository.findByInstructorId(instructor_id);
        for (StudentView studentView : studentViews) {
            list.addAll(this.dailyAppreciationRepository.findByStudentForToday(studentView.getStudent_id()));
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @PostMapping(value={"/get/daily_appreciation/for/student"})
    public ResponseEntity<Page<DailyAppreciation>> getAllDailyAppreciationForStudent(@RequestBody GetDailyAppreciationForStudentRequest request) {
        return new ResponseEntity((Object)this.homeService.getAllDailyAppreciationForStudent(request.getStudent_id().longValue(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), HttpStatus.OK);
    }

    @GetMapping(value={"/get/mood_log/for/student"})
    public ResponseEntity<List<MoodUpdateDTO>> getMoodLogForStudent(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        List moodUpdates = this.moodUpdateRepository.findByStudentId(student_id);
        for (MoodUpdateDTO moodUpdate : moodUpdates) {
            MoodDTO mood = this.moodRepository.findById(moodUpdate.getMood_id());
            moodUpdate.setImage_elementary(this.configurationService.getConfiguration().getImages_elementary_path() + mood.getImages_elementary());
            moodUpdate.setImage_others(this.configurationService.getConfiguration().getImages_others_path() + mood.getImages_others());
            moodUpdate.setAnimated_image(this.configurationService.getConfiguration().getMood_gifs_path() + mood.getAnimated_image());
        }
        return new ResponseEntity((Object)moodUpdates, HttpStatus.OK);
    }

    @PostMapping(value={"/get/socio/emotional/score"})
    public ResponseEntity<SocioEmotionalTestResult> getSocioEmotionalScore(@RequestBody GetSocioEmotionalScoreRequest request) {
        List list = this.socioEmotionalTestResultRepository.findByStudentId(request.getStudent_id());
        if (list.size() > 0) {
            return new ResponseEntity(list.get(list.size() - 1), HttpStatus.OK);
        }
        return new ResponseEntity((Object)new SocioEmotionalTestResult(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/lesson/progress/for/student"})
    public ResponseEntity<List<Lesson>> getLessonProgress(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        List allLessons = this.lessonRepository.findByGradeId(Long.valueOf(s.getStandard().getGrade_id()));
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
            for (Lesson ln : allLessons) {
                if (ln.getLesson_id() != l.getLesson_id()) continue;
                ln.setCompleted(true);
            }
        }
        return new ResponseEntity((Object)allLessons, HttpStatus.OK);
    }

    @PostMapping(value={"/get-appreciation-items"})
    public ResponseEntity<LinkedHashSet<AppreciationItem>> getAppreciationItems(@RequestBody GetAppreciationItemsRequest request) {
        String appreciation_images_path = this.configurationService.getConfiguration().getAppreciation_images_path();
        LinkedHashSet appreciationItems = this.appreciationRepository.findByGradeIdOrderByAppreciationIdASC((long)request.getGrade_id()).stream().map(appreciation -> new AppreciationItem(appreciation.getText(), appreciation.getText_es(), appreciation_images_path + appreciation.getImage())).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ResponseEntity((Object)appreciationItems, HttpStatus.OK);
    }
}

