/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodupdate.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionOccurrenceAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.SubEmotionCountAndAverage;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.moodupdate.entity.MoodUpdateReview;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateReviewRepository;
import com.infinite.focus.server.moodupdate.service.MoodUpdateService;
import com.infinite.focus.server.notification.request.SendEmotionNotificationRequest;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.studentstreak.service.moodupdate.StreakMoodUpdateService;
import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class MoodUpdateServiceImpl
implements MoodUpdateService {
    private final MoodRepository moodRepository;
    private final ConfigurationRepository configurationRepository;
    private final MoodUpdateRepository moodUpdateRepository;
    private final MoodUpdateReviewRepository moodUpdateReviewRepository;
    private final RestComponent restComponent;
    private final StreakMoodUpdateService streakMoodUpdateService;
    private final MessageService messageService;

    public MoodUpdateServiceImpl(MoodRepository moodRepository, ConfigurationRepository configurationRepository, MoodUpdateRepository moodUpdateRepository, MoodUpdateReviewRepository moodUpdateReviewRepository, RestComponent restComponent, StreakMoodUpdateService streakMoodUpdateService, MessageService messageService) {
        this.moodRepository = moodRepository;
        this.configurationRepository = configurationRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.moodUpdateReviewRepository = moodUpdateReviewRepository;
        this.restComponent = restComponent;
        this.streakMoodUpdateService = streakMoodUpdateService;
        this.messageService = messageService;
    }

    public List<MoodUpdateDTO> getLastThreeMoodsByStudentId(long student_id) {
        return this.moodUpdateRepository.getLastThreeMoodsByStudentId(student_id);
    }

    public MoodUpdateDTO getById(long self_awareness_id) {
        return this.moodUpdateRepository.findById(self_awareness_id);
    }

    public Page<MoodUpdateDTO> getMoodUpdateListByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.moodUpdateRepository.findPageByStudentId(student_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(moodUpdate -> {
            MoodDTO mood = this.moodRepository.findById(moodUpdate.getMood_id());
            moodUpdate.setImage_elementary(this.configurationRepository.getConfiguration().getImages_elementary_path() + mood.getImages_elementary());
            moodUpdate.setImage_others(this.configurationRepository.getConfiguration().getImages_others_path() + mood.getImages_others());
            moodUpdate.setAnimated_image(this.configurationRepository.getConfiguration().getMood_gifs_path() + mood.getAnimated_image());
            return moodUpdate;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public void applyReviewUpdate() {
        List moodUpdateReviews = this.moodUpdateReviewRepository.findAll();
        if (AppUtils.isNullOrEmpty((List)moodUpdateReviews)) {
            return;
        }
        List moodDTOS = this.restComponent.getAllMoods();
        List subMoodDTOS = this.restComponent.getAllSubMoods();
        List moodUpdateDTOS = this.moodUpdateRepository.findAll().stream().peek(moodUpdateDTO -> {
            MoodUpdateReview moodUpdateReview = moodUpdateReviews.stream().filter(mr -> mr.getMood_update_id() == moodUpdateDTO.getMood_update_id()).findAny().orElse(null);
            if (moodUpdateReview != null) {
                MoodDTO moodDTO = moodDTOS.stream().filter(m -> m.getMood_id() == moodUpdateReview.getNeed_to_update_mood_id()).findAny().orElse(null);
                if (moodDTO != null) {
                    moodUpdateDTO.setMood_id(moodDTO.getMood_id());
                    moodUpdateDTO.setText(moodDTO.getMood());
                    moodUpdateDTO.setText_es(moodDTO.getMood_es());
                    moodUpdateDTO.setScore(moodDTO.getWeight());
                    SubMoodDTO subMoodDTO = subMoodDTOS.stream().filter(sm -> sm.getSub_mood_id() == moodUpdateReview.getNeed_to_update_sub_mood_id()).findAny().orElse(null);
                    if (subMoodDTO != null) {
                        moodUpdateDTO.setSub_mood_id(subMoodDTO.getSub_mood_id());
                        moodUpdateDTO.setSub_mood_text(subMoodDTO.getSub_mood());
                        moodUpdateDTO.setSub_mood_text_es(subMoodDTO.getSub_mood_es());
                        moodUpdateDTO.setStandard_id(moodUpdateReview.getFrom_standard_id());
                    }
                } else {
                    moodUpdateDTO.setStandard_id(moodUpdateReview.getFrom_standard_id());
                }
            }
        }).collect(Collectors.toList());
        this.moodUpdateRepository.updateAll(moodUpdateDTOS);
    }

    @Async
    public void reviewUpdate() {
        this.moodUpdateReviewRepository.truncateTable();
        List moodUpdateDTOS = this.moodUpdateRepository.findAll();
        List student_ids = moodUpdateDTOS.stream().map(MoodUpdateDTO::getStudent_id).distinct().collect(Collectors.toList());
        List studentDTOS = this.restComponent.getStudentsByIds(student_ids);
        List moodDTOS = this.restComponent.getAllMoods();
        List subMoodDTOS = this.restComponent.getAllSubMoods();
        List subMoodAndStandardDTOS = this.restComponent.getAllSubMoodAndStandards();
        System.out.println("Total Need To Update: " + moodUpdateDTOS.size());
        ArrayList<MoodUpdateReview> moodUpdateReviews = new ArrayList<MoodUpdateReview>();
        for (MoodUpdateDTO moodUpdateDTO : moodUpdateDTOS) {
            StudentDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id().equals(moodUpdateDTO.getStudent_id())).findAny().orElse(null);
            if (studentDTO == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Student is not found: " + moodUpdateDTO.getStudent_id());
            }
            MoodUpdateReview moodUpdateReview = this.getMoodUpdateReview(moodUpdateDTO, studentDTO);
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Get Mood Update Data For: ");
            System.out.println("Mood_update_id: " + moodUpdateReview.getMood_update_id() + "   Standard_id: " + moodUpdateReview.getStandard_id() + "   Mood_id: " + moodUpdateReview.getMood_id() + "   Mood: " + moodUpdateReview.getText() + "   Score: " + moodUpdateReview.getScore() + "   Sub_mood_id: " + moodUpdateReview.getSub_mood_id() + "   Sub_mood: " + moodUpdateReview.getSub_mood_text());
            if (moodUpdateDTO.getSub_mood_id() == 0L) {
                if (moodUpdateDTO.getText().equals("Panic")) {
                    SubMoodAndStandardDTO subMoodAndStandardDTO;
                    long standard_id = studentDTO.getStandard_id();
                    if (standard_id <= 6L) {
                        subMoodAndStandardDTO = subMoodAndStandardDTOS.stream().filter(s -> s.getSub_mood_and_standard_id() == 106L).findAny().orElse(null);
                        moodUpdateReview = this.updateMoodUpdateReview(moodUpdateReview, subMoodAndStandardDTO, moodDTOS, subMoodDTOS);
                    } else {
                        subMoodAndStandardDTO = subMoodAndStandardDTOS.stream().filter(s -> s.getSub_mood_and_standard_id() == 540L).findAny().orElse(null);
                        moodUpdateReview = this.updateMoodUpdateReview(moodUpdateReview, subMoodAndStandardDTO, moodDTOS, subMoodDTOS);
                    }
                } else {
                    moodUpdateReview = moodUpdateDTO.getText().equals("Unmotivated") ? this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS) : (moodUpdateDTO.getText().equals("Nervous") ? this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS) : (moodUpdateDTO.getText().equals("Hopeful") ? this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS) : (moodUpdateDTO.getText().equals("Content") ? this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS) : (moodUpdateDTO.getText().equals("Shy") ? this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS) : this.getSubMoodAndStandardByStandardIdAndMoodId(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS)))));
                }
            } else {
                SubMoodAndStandardDTO subMoodAndStandardDTO = this.getStandardByMoodIdAndStandardIdAndSubMoodId(moodUpdateReview.getMood_id(), studentDTO.getStandard_id().longValue(), moodUpdateReview.getSub_mood_id(), subMoodAndStandardDTOS);
                if (subMoodAndStandardDTO != null) {
                    moodUpdateReview.setFrom_standard_id(studentDTO.getStandard_id().longValue());
                } else {
                    long standard_id;
                    for (standard_id = studentDTO.getStandard_id().longValue(); standard_id > 0L && (subMoodAndStandardDTO = this.getStandardByMoodIdAndStandardIdAndSubMoodId(moodUpdateReview.getMood_id(), standard_id, moodUpdateReview.getSub_mood_id(), subMoodAndStandardDTOS)) == null; --standard_id) {
                    }
                    if (subMoodAndStandardDTO != null) {
                        moodUpdateReview.setFrom_standard_id(standard_id);
                    } else {
                        for (standard_id = studentDTO.getStandard_id().longValue(); standard_id <= 13L && (subMoodAndStandardDTO = this.getStandardByMoodIdAndStandardIdAndSubMoodId(moodUpdateReview.getMood_id(), standard_id, moodUpdateReview.getSub_mood_id(), subMoodAndStandardDTOS)) == null; ++standard_id) {
                        }
                    }
                    if (subMoodAndStandardDTO != null) {
                        moodUpdateReview.setFrom_standard_id(standard_id);
                    }
                }
            }
            moodUpdateReviews.add(moodUpdateReview);
        }
        this.moodUpdateReviewRepository.saveAll(moodUpdateReviews);
        System.out.println("Complete - Mood Update Review");
    }

    public SubMoodAndStandardDTO getStandardByMoodIdAndStandardIdAndSubMoodId(long mood_id, long standard_id, long sub_mood_id, List<SubMoodAndStandardDTO> subMoodAndStandardDTOS) {
        return subMoodAndStandardDTOS.stream().filter(o -> o.getMood_id() == mood_id && o.getStandard_id() == standard_id && o.getSub_mood_id() == sub_mood_id && subMoodAndStandardDTOS.stream().noneMatch(s -> s.getMood_id() == mood_id && s.getStandard_id() == standard_id && s.getTop_sub_mood_id() == sub_mood_id)).findAny().orElse(null);
    }

    public MoodUpdateReview getSubMoodAndStandardByStandardIdAndMoodId(MoodUpdateReview moodUpdateReview, List<MoodDTO> moodDTOS, List<SubMoodDTO> subMoodDTOS, List<SubMoodAndStandardDTO> subMoodAndStandardDTOS) {
        List subMoodAndStandardDTOSByStandardIdAndMoodId = subMoodAndStandardDTOS.stream().filter(subMoodAndStandardDTO -> subMoodAndStandardDTO.getStandard_id() == moodUpdateReview.getStandard_id() && subMoodAndStandardDTO.getMood_id() == moodUpdateReview.getMood_id()).filter(subMoodAndStandardDTO -> {
            long count = subMoodAndStandardDTOS.stream().filter(i -> i.getStandard_id() == subMoodAndStandardDTO.getStandard_id() && i.getMood_id() == subMoodAndStandardDTO.getMood_id() && i.getTop_sub_mood_id() == subMoodAndStandardDTO.getSub_mood_id()).count();
            return count <= 0L;
        }).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getStandard_id)).collect(Collectors.toList());
        System.out.println("-----------------------------------------------------------------");
        System.out.println("List Sub Moods:");
        for (SubMoodAndStandardDTO subMoodAndStandardDTO2 : subMoodAndStandardDTOSByStandardIdAndMoodId) {
            SubMoodDTO subMoodDTO;
            MoodDTO moodDTO = moodDTOS.stream().filter(m -> m.getMood_id() == subMoodAndStandardDTO2.getMood_id()).findAny().orElse(null);
            if (moodDTO == null || (subMoodDTO = (SubMoodDTO)subMoodDTOS.stream().filter(sm -> sm.getSub_mood_id() == subMoodAndStandardDTO2.getSub_mood_id()).findAny().orElse(null)) == null) continue;
            System.out.println("Standard_id: " + subMoodAndStandardDTO2.getStandard_id() + "   Mood_id: " + moodDTO.getMood_id() + "   Mood: " + moodDTO.getMood() + "   Score: " + moodDTO.getWeight() + "   Sub_mood_id: " + subMoodDTO.getSub_mood_id() + "   Sub_mood: " + subMoodDTO.getSub_mood());
        }
        SubMoodAndStandardDTO subMoodAndStandardDTOByStandardIdAndMoodId = subMoodAndStandardDTOSByStandardIdAndMoodId.stream().skip(AppUtils.isNullOrEmpty(subMoodAndStandardDTOSByStandardIdAndMoodId) ? 0L : (long)new Random().nextInt(subMoodAndStandardDTOSByStandardIdAndMoodId.size())).findFirst().orElse(null);
        if (subMoodAndStandardDTOByStandardIdAndMoodId != null) {
            return this.updateMoodUpdateReview(moodUpdateReview, subMoodAndStandardDTOByStandardIdAndMoodId, moodDTOS, subMoodDTOS);
        }
        return this.getSubMoodAndStandardByStandardIdAndMoodText(moodUpdateReview, moodDTOS, subMoodDTOS, subMoodAndStandardDTOS);
    }

    public MoodUpdateReview getSubMoodAndStandardByStandardIdAndMoodText(MoodUpdateReview moodUpdateReview, List<MoodDTO> moodDTOS, List<SubMoodDTO> subMoodDTOS, List<SubMoodAndStandardDTO> subMoodAndStandardDTOS) {
        SubMoodAndStandardDTO subMoodAndStandardDTOByStandardIdAndText = subMoodAndStandardDTOS.stream().filter(subMoodAndStandardDTO -> {
            SubMoodDTO subMoodDTO = subMoodDTOS.stream().filter(sm -> sm.getSub_mood().equals(moodUpdateReview.getText())).findAny().orElse(null);
            return subMoodAndStandardDTO.getStandard_id() == moodUpdateReview.getStandard_id() && subMoodDTO != null && subMoodAndStandardDTO.getSub_mood_id() == subMoodDTO.getSub_mood_id();
        }).filter(subMoodAndStandardDTO -> {
            long count = subMoodAndStandardDTOS.stream().filter(i -> i.getStandard_id() == subMoodAndStandardDTO.getStandard_id() && i.getMood_id() == subMoodAndStandardDTO.getMood_id() && i.getTop_sub_mood_id() == subMoodAndStandardDTO.getSub_mood_id()).count();
            return count <= 0L;
        }).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getStandard_id)).findAny().orElse(null);
        if (subMoodAndStandardDTOByStandardIdAndText == null) {
            subMoodAndStandardDTOByStandardIdAndText = subMoodAndStandardDTOS.stream().filter(subMoodAndStandardDTO -> {
                SubMoodDTO subMoodDTO = subMoodDTOS.stream().filter(sm -> sm.getSub_mood().equals(moodUpdateReview.getText())).findAny().orElse(null);
                return subMoodDTO != null && subMoodAndStandardDTO.getSub_mood_id() == subMoodDTO.getSub_mood_id();
            }).filter(subMoodAndStandardDTO -> {
                long count = subMoodAndStandardDTOS.stream().filter(i -> i.getStandard_id() == subMoodAndStandardDTO.getStandard_id() && i.getMood_id() == subMoodAndStandardDTO.getMood_id() && i.getTop_sub_mood_id() == subMoodAndStandardDTO.getSub_mood_id()).count();
                return count <= 0L;
            }).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getStandard_id)).findAny().orElse(null);
        }
        if (subMoodAndStandardDTOByStandardIdAndText == null) {
            subMoodAndStandardDTOByStandardIdAndText = subMoodAndStandardDTOS.stream().filter(subMoodAndStandardDTO -> {
                MoodDTO moodDTO = moodDTOS.stream().filter(sm -> sm.getMood().equals(moodUpdateReview.getText())).findAny().orElse(null);
                return moodDTO != null && subMoodAndStandardDTO.getMood_id() == moodDTO.getMood_id();
            }).filter(subMoodAndStandardDTO -> {
                long count = subMoodAndStandardDTOS.stream().filter(i -> i.getStandard_id() == subMoodAndStandardDTO.getStandard_id() && i.getMood_id() == subMoodAndStandardDTO.getMood_id() && i.getTop_sub_mood_id() == subMoodAndStandardDTO.getSub_mood_id()).count();
                return count <= 0L;
            }).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getStandard_id)).findAny().orElse(null);
        }
        return this.updateMoodUpdateReview(moodUpdateReview, subMoodAndStandardDTOByStandardIdAndText, moodDTOS, subMoodDTOS);
    }

    public MoodUpdateReview updateMoodUpdateReview(MoodUpdateReview moodUpdateReview, SubMoodAndStandardDTO subMoodAndStandardDTO, List<MoodDTO> moodDTOS, List<SubMoodDTO> subMoodDTOS) {
        SubMoodDTO subMoodDTO;
        MoodDTO moodDTO;
        if (subMoodAndStandardDTO != null && (moodDTO = (MoodDTO)moodDTOS.stream().filter(m -> m.getMood_id() == subMoodAndStandardDTO.getMood_id()).findAny().orElse(null)) != null && (subMoodDTO = (SubMoodDTO)subMoodDTOS.stream().filter(sm -> sm.getSub_mood_id() == subMoodAndStandardDTO.getSub_mood_id()).findAny().orElse(null)) != null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Print Sub Mood:");
            System.out.println("Standard_id: " + subMoodAndStandardDTO.getStandard_id() + "   Mood_id: " + moodDTO.getMood_id() + "   Mood: " + moodDTO.getMood() + "   Score: " + moodDTO.getWeight() + "   Sub_mood_id: " + subMoodDTO.getSub_mood_id() + "   Sub_mood: " + subMoodDTO.getSub_mood());
            moodUpdateReview.setFrom_standard_id(subMoodAndStandardDTO.getStandard_id());
            moodUpdateReview.setNeed_to_update_mood_id(moodDTO.getMood_id());
            moodUpdateReview.setNeed_to_update_text(moodDTO.getMood());
            moodUpdateReview.setNeed_to_update_text_es(moodDTO.getMood_es());
            moodUpdateReview.setNeed_to_update_score(moodDTO.getWeight());
            moodUpdateReview.setNeed_to_update_sub_mood_id(subMoodDTO.getSub_mood_id());
            moodUpdateReview.setNeed_to_update_sub_mood_text(subMoodDTO.getSub_mood());
            moodUpdateReview.setNeed_to_update_sub_mood_text_es(subMoodDTO.getSub_mood_es());
        }
        return moodUpdateReview;
    }

    private MoodUpdateReview getMoodUpdateReview(MoodUpdateDTO moodUpdateDTO, StudentDTO studentDTO) {
        MoodUpdateReview moodUpdateReview = new MoodUpdateReview();
        moodUpdateReview.setMood_update_review_id(0L);
        moodUpdateReview.setMood_update_id(moodUpdateDTO.getMood_update_id());
        moodUpdateReview.setMood_id(moodUpdateDTO.getMood_id());
        moodUpdateReview.setText(moodUpdateDTO.getText());
        moodUpdateReview.setScore(moodUpdateDTO.getScore());
        moodUpdateReview.setSub_mood_id(moodUpdateDTO.getSub_mood_id());
        moodUpdateReview.setSub_mood_text(moodUpdateDTO.getSub_mood_text());
        moodUpdateReview.setStudent_id(moodUpdateDTO.getStudent_id());
        moodUpdateReview.setFirst_name(studentDTO.getFirst_name());
        moodUpdateReview.setLast_name(studentDTO.getLast_name());
        moodUpdateReview.setStandard_id(studentDTO.getStandard_id().longValue());
        return moodUpdateReview;
    }

    public MoodUpdateAndStreak create(MoodUpdate request) {
        int count;
        List list;
        MoodDTO moodById = this.moodRepository.findById(request.getMood_id());
        if (moodById == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.mood.is.not.found"));
        }
        request.setScore(moodById.getWeight());
        Student student = this.restComponent.getStudentById(request.getStudent_id());
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        Parent parent = this.restComponent.getParentById(student.getParent_id());
        if (this.containsMood("sad", request.getText()) || this.containsMood("sad", request.getSub_mood_text())) {
            this.restComponent.sendEmotionAlertNotification(SendEmotionNotificationRequest.builder().student_id(student.getStudent_id()).student_name(student.getFirst_name() + " " + student.getLast_name()).instructor_id(instructor != null ? instructor.getInstructor_id() : 0L).parent_id(parent != null ? parent.getParent_id() : 0L).corporate_id(parent != null && parent.getCorporate_id() > 0L ? parent.getCorporate_id() : 0L).text("is sad today (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").text_es("est\u00e1 triste hoy (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").build());
        }
        if (this.containsMood("nervous", request.getText()) || this.containsMood("nervous", request.getSub_mood_text())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(request.getStudent_id());
            count = 0;
            for (MoodUpdateDTO m : list) {
                if (!this.containsMood("nervous", m.getText()) && !this.containsMood("nervous", request.getSub_mood_text())) continue;
                ++count;
            }
            if (count >= 2) {
                this.restComponent.sendEmotionAlertNotification(SendEmotionNotificationRequest.builder().student_id(student.getStudent_id()).student_name(student.getFirst_name() + " " + student.getLast_name()).instructor_id(instructor != null ? instructor.getInstructor_id() : 0L).parent_id(parent != null ? parent.getParent_id() : 0L).corporate_id(parent != null && parent.getCorporate_id() > 0L ? parent.getCorporate_id() : 0L).text("has selected nervous three times in a row. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").text_es("ha seleccionado nervioso tres veces seguidas. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").build());
            }
        }
        if (this.containsMood("angry", request.getText()) || this.containsMood("angry", request.getSub_mood_text())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(request.getStudent_id());
            count = 0;
            for (MoodUpdateDTO m : list) {
                if (!this.containsMood("mad", m.getText()) && !this.containsMood("mad", m.getSub_mood_text()) && !this.containsMood("angry", m.getText()) && !this.containsMood("angry", m.getSub_mood_text())) continue;
                ++count;
            }
            if (count >= 2) {
                this.restComponent.sendEmotionAlertNotification(SendEmotionNotificationRequest.builder().student_id(student.getStudent_id()).student_name(student.getFirst_name() + " " + student.getLast_name()).instructor_id(instructor != null ? instructor.getInstructor_id() : 0L).parent_id(parent != null ? parent.getParent_id() : 0L).corporate_id(parent != null && parent.getCorporate_id() > 0L ? parent.getCorporate_id() : 0L).text("has selected angry three times in a row. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").text_es("ha seleccionado enfadado tres veces seguidas. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").build());
            }
        }
        if (this.containsMood("sad", request.getText()) || this.containsMood("sad", request.getSub_mood_text())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(request.getStudent_id());
            count = 0;
            for (MoodUpdateDTO m : list) {
                if (!this.containsMood("sad", m.getText()) && !this.containsMood("sad", request.getSub_mood_text()) && !this.containsMood("depressed", m.getText()) && !this.containsMood("depressed", request.getSub_mood_text())) continue;
                ++count;
            }
            if (count >= 2) {
                this.restComponent.sendEmotionAlertNotification(SendEmotionNotificationRequest.builder().student_id(student.getStudent_id()).student_name(student.getFirst_name() + " " + student.getLast_name()).instructor_id(instructor != null ? instructor.getInstructor_id() : 0L).parent_id(parent != null ? parent.getParent_id() : 0L).corporate_id(parent != null && parent.getCorporate_id() > 0L ? parent.getCorporate_id() : 0L).text("has selected sad three times in a row. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").text_es("ha seleccionado a Sad tres veces seguidas. (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").").build());
            }
        }
        MoodUpdateDTO moodUpdate = this.moodUpdateRepository.create(request.getStudent_id(), student.getStandard().getStandard_id(), request.getMood_id(), request.getText(), request.getText_es(), request.getScore(), request.getLevel_of_focus(), request.getSub_mood_id(), request.getSub_mood_text(), request.getSub_mood_text_es(), PVState.getByLevelOfFocus((float)request.getLevel_of_focus()).name());
        MoodUpdateAndStreak moodUpdateAndStreak = new MoodUpdateAndStreak();
        moodUpdateAndStreak.setMoodUpdate(moodUpdate);
        StreakDTO streak = this.streakMoodUpdateService.addStreakHappyInARow(moodUpdate.getStudent_id());
        moodUpdateAndStreak.setStreak(streak);
        return moodUpdateAndStreak;
    }

    public List<EmotionCountAndAverage> getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate(Set<Long> student_ids, Date fromDate, Date toDate) {
        List emotionCountAndAverages = this.restComponent.getAllEmotionsAndSubEmotions();
        List moodUpdateDTOS = this.moodUpdateRepository.findByStudentIdsAndBetweenFromDateAndEndDate(student_ids, fromDate, toDate);
        for (EmotionCountAndAverage e : emotionCountAndAverages) {
            List emotion = moodUpdateDTOS.stream().filter(mu -> mu.getMood_id() == e.getEmotion_id()).collect(Collectors.toList());
            e.setCount((long)emotion.size());
            e.setAverage(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)emotion.size() / (double)moodUpdateDTOS.size() * 100.0)).doubleValue());
            if (e.getSub_emotions() == null) continue;
            this.setSubEmotionCount(e.getSub_emotions().get_k_2(), emotion);
            this.setSubEmotionCount(e.getSub_emotions().get_3_5(), emotion);
            this.setSubEmotionCount(e.getSub_emotions().get_6_12(), emotion);
        }
        return emotionCountAndAverages;
    }

    private void setSubEmotionCount(List<SubEmotionCountAndAverage> subEmotionCountAndAverages, List<MoodUpdateDTO> emotion) {
        if (!AppUtils.isNullOrEmpty(subEmotionCountAndAverages)) {
            long totalCount = 0L;
            for (SubEmotionCountAndAverage s : subEmotionCountAndAverages) {
                long count = emotion.stream().filter(mu -> s.getStandard_ids().contains(mu.getStandard_id()) && mu.getSub_mood_id() == s.getSub_emotion_id()).count();
                s.setCount(count);
                totalCount += count;
                if (AppUtils.isNullOrEmpty((String)s.getSub_emotion())) continue;
                this.setSubEmotionCount(s.getSub_emotions(), emotion);
            }
            if (totalCount > 0L) {
                this.setSubEmotionAverage(subEmotionCountAndAverages, totalCount);
            }
        }
    }

    private void setSubEmotionAverage(List<SubEmotionCountAndAverage> subEmotionCountAndAverages, long totalCount) {
        for (SubEmotionCountAndAverage s : subEmotionCountAndAverages) {
            s.setAverage(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)s.getCount() / (double)totalCount * 100.0)).doubleValue());
            if (AppUtils.isNullOrEmpty((String)s.getSub_emotion())) continue;
            this.setSubEmotionAverage(s.getSub_emotions(), totalCount);
        }
    }

    private boolean containsMood(String mood, String text) {
        return !AppUtils.isNullOrEmpty((String)text) && text.toLowerCase().trim().equalsIgnoreCase(mood.toLowerCase().trim());
    }

    public EmotionsByStandards getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(Set<Long> student_ids, Date fromDate, Date toDate) {
        EmotionsByStandards emotionCountAndAverages = this.restComponent.getAllEmotions();
        List moodUpdateDTOS = this.moodUpdateRepository.findByStudentIdsAndBetweenFromDateAndEndDate(student_ids, fromDate, toDate);
        this.setEmotions2(emotionCountAndAverages.get_k_2(), moodUpdateDTOS);
        this.setEmotions2(emotionCountAndAverages.get_3_5(), moodUpdateDTOS);
        this.setEmotions2(emotionCountAndAverages.get_6_12(), moodUpdateDTOS);
        return emotionCountAndAverages;
    }

    private void setEmotions2(List<EmotionOccurrenceAndAverage> emotionOccurrenceAndAverages, List<MoodUpdateDTO> moodUpdateDTOS) {
        Set emotion_ids = emotionOccurrenceAndAverages.stream().map(EmotionOccurrenceAndAverage::getEmotion_id).collect(Collectors.toSet());
        Set standard_ids = emotionOccurrenceAndAverages.get(0).getStandard_ids();
        List emotions = moodUpdateDTOS.stream().filter(mu -> emotion_ids.contains(mu.getMood_id()) && standard_ids.contains(mu.getStandard_id())).collect(Collectors.toList());
        for (EmotionOccurrenceAndAverage e : emotionOccurrenceAndAverages) {
            List emotion = moodUpdateDTOS.stream().filter(mu -> mu.getMood_id() == e.getEmotion_id() && e.getStandard_ids().contains(mu.getStandard_id())).collect(Collectors.toList());
            e.setCount((long)emotion.size());
            e.setAverage(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)emotion.size() / (double)emotions.size() * 100.0)).doubleValue());
            if (AppUtils.isNullOrEmpty((List)e.getSub_emotions())) continue;
            this.setSubEmotionCount2(e.getSub_emotions(), emotions);
        }
    }

    private void setSubEmotionCount2(List<SubEmotionCountAndAverage> subEmotionCountAndAverages, List<MoodUpdateDTO> emotions) {
        if (!AppUtils.isNullOrEmpty(subEmotionCountAndAverages)) {
            for (SubEmotionCountAndAverage s : subEmotionCountAndAverages) {
                long count;
                if (!AppUtils.isNullOrEmpty((List)s.getSub_emotions())) {
                    this.setSubEmotionCount2(s.getSub_emotions(), emotions);
                    count = s.getSub_emotions().stream().mapToLong(SubEmotionCountAndAverage::getCount).sum();
                } else {
                    count = emotions.stream().filter(mu -> s.getStandard_ids().contains(mu.getStandard_id()) && mu.getSub_mood_id() == s.getSub_emotion_id()).count();
                }
                s.setCount(count);
            }
            this.setSubEmotionAverage2(subEmotionCountAndAverages);
        }
    }

    private void setSubEmotionAverage2(List<SubEmotionCountAndAverage> subEmotionCountAndAverages) {
        long totalCount = subEmotionCountAndAverages.stream().mapToLong(SubEmotionCountAndAverage::getCount).sum();
        for (SubEmotionCountAndAverage s : subEmotionCountAndAverages) {
            s.setAverage(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)s.getCount() / (double)totalCount * 100.0)).doubleValue());
            if (AppUtils.isNullOrEmpty((List)s.getSub_emotions())) continue;
            this.setInnerSubEmotionAverage2(s.getSub_emotions(), totalCount);
        }
    }

    private void setInnerSubEmotionAverage2(List<SubEmotionCountAndAverage> subEmotionCountAndAverages, long totalCount) {
        for (SubEmotionCountAndAverage s : subEmotionCountAndAverages) {
            s.setAverage(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)s.getCount() / (double)totalCount * 100.0)).doubleValue());
            if (AppUtils.isNullOrEmpty((List)s.getSub_emotions())) continue;
            this.setInnerSubEmotionAverage2(s.getSub_emotions(), totalCount);
        }
    }
}

