/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpushnotification.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.studentpushnotification.dto.StudentPushNotificationDTO;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedRequest;
import com.infinite.focus.server.studentpushnotification.request.StreakReceivedPushNotification;
import com.infinite.focus.server.studentpushnotification.service.StudentPushNotificationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-push-notification"})
public class StudentPushNotificationController {
    private final MessageService messageService;
    private final StudentPushNotificationService studentPushNotificationService;

    public StudentPushNotificationController(MessageService messageService, StudentPushNotificationService studentPushNotificationService) {
        this.messageService = messageService;
        this.studentPushNotificationService = studentPushNotificationService;
    }

    @PostMapping(value={"/send"})
    public ResponseEntity<Message> send(@RequestBody StudentPushNotificationDTO request) {
        this.studentPushNotificationService.send(request.getStudent_id().longValue(), request.getNotification_type(), request.getFormat_text(), request.getTitle(), request.getMessage(), request.getTitle_es(), request.getMessage_es());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/badge-received"})
    public ResponseEntity<Message> badgeReceived(@RequestBody BadgeReceivedRequest request) {
        this.studentPushNotificationService.badgeReceived(request.getBadge_received_push_notifications());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/streak-received"})
    public ResponseEntity<Message> streakReceived(@RequestBody StreakReceivedPushNotification request) {
        this.studentPushNotificationService.streakReceived(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

