/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.journal.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.journal.component.JournalBadWordFilterComponent;
import com.infinite.focus.server.journal.dto.JournalDTO;
import com.infinite.focus.server.journal.request.GetPageRequest;
import com.infinite.focus.server.journal.service.JournalService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.entity.Notification;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.repository.NotificationRepository;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/journal"})
public class JournalController {
    private final AuthService authService;
    private final JournalService journalService;
    private final StudentRepository studentRepository;
    private final StudentCriteriaRepository studentCriteriaRepository;
    private final MessageService messageService;
    private final SchoolRepository schoolRepository;
    private final JournalBadWordFilterComponent journalBadWordFilterComponent;
    private final NotificationRepository notificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final InstructorRepository instructorRepository;
    private final ConfigurationRepository configurationRepository;

    public JournalController(AuthService authService, JournalService journalService, StudentRepository studentRepository, StudentCriteriaRepository studentCriteriaRepository, MessageService messageService, SchoolRepository schoolRepository, JournalBadWordFilterComponent journalBadWordFilterComponent, NotificationRepository notificationRepository, RealTimeMessageService realTimeMessageService, InstructorRepository instructorRepository, ConfigurationRepository configurationRepository) {
        this.authService = authService;
        this.journalService = journalService;
        this.studentRepository = studentRepository;
        this.studentCriteriaRepository = studentCriteriaRepository;
        this.messageService = messageService;
        this.schoolRepository = schoolRepository;
        this.journalBadWordFilterComponent = journalBadWordFilterComponent;
        this.notificationRepository = notificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.instructorRepository = instructorRepository;
        this.configurationRepository = configurationRepository;
    }

    @PostMapping(value={"/get/journals/by/student"})
    @ResponseBody
    public ResponseEntity<Page<JournalDTO>> getJournalsByStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetPageRequest request) {
        Student student = this.authService.isStudent(token);
        if (student.getSchool() != null && !student.getSchool().isEnable_journal()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.show.journals.at.this.point.of.time.please.try.again.later"));
        }
        request.getStudent_ids().add(student.getStudent_id());
        return new ResponseEntity((Object)this.journalService.getJournalByStudentIds(request.getStudent_ids(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/journals/by/instructor"})
    @ResponseBody
    public ResponseEntity<Page<JournalDTO>> getJournalsByInstructor(@RequestHeader(value="Authorization") String token, @RequestBody GetPageRequest request) {
        List studentIds;
        School school;
        Instructor instructor = this.authService.isInstructor(token);
        if (instructor != null && (school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()))) != null && !school.isEnable_journal()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.show.journals.at.this.point.of.time.please.try.again.later"));
        }
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            studentIds = this.studentRepository.findByInstructorIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(Long.valueOf(instructor.getInstructor_id())).stream().filter(Student::isShare_journal_with_instructor).map(Student::getStudent_id).collect(Collectors.toList());
            request.getStudent_ids().addAll(studentIds);
        } else {
            studentIds = request.getStudent_ids().stream().filter(id -> {
                Student student = this.studentRepository.findByStudentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(id);
                return student != null && student.isShare_journal_with_instructor();
            }).collect(Collectors.toList());
            request.getStudent_ids().clear();
            request.getStudent_ids().addAll(studentIds);
        }
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            PageRequest paging = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
            return new ResponseEntity((Object)Page.empty((Pageable)paging), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
        }
        Page journals = this.journalService.getJournalByStudentIds(request.getStudent_ids(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate());
        PageImpl pageWithBadWordFilteredData = new PageImpl(journals.stream().peek(journal -> {
            if (!AppUtils.isNullOrEmpty((String)journal.getJournal_description())) {
                journal.setHasBadWords(this.journalBadWordFilterComponent.isThereAnyBadWordInText(journal.getJournal_description()).booleanValue());
            }
        }).collect(Collectors.toList()), journals.getPageable(), journals.getTotalElements());
        return new ResponseEntity((Object)pageWithBadWordFilteredData, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/journals/by/school"})
    @ResponseBody
    public ResponseEntity<Page<JournalDTO>> getJournalsBySchool(@RequestHeader(value="Authorization") String token, @RequestBody GetPageRequest request) {
        List studentIds;
        List schools = this.authService.isSchool(token);
        School school = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            school = schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id()).findFirst().orElse(null);
        }
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
        }
        if (!school.isEnable_journal()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.show.journals.at.this.point.of.time.please.try.again.later"));
        }
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            studentIds = this.studentCriteriaRepository.findBySchoolIdAndShareJournalWithInstructor(school.getSchool_id(), true);
            request.getStudent_ids().addAll(studentIds);
        } else {
            studentIds = request.getStudent_ids().stream().filter(id -> {
                Student student = this.studentRepository.findByStudentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(id);
                return student != null && student.isShare_journal_with_instructor();
            }).collect(Collectors.toList());
            request.getStudent_ids().clear();
            request.getStudent_ids().addAll(studentIds);
        }
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            PageRequest paging = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
            return new ResponseEntity((Object)Page.empty((Pageable)paging), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
        }
        Page journals = this.journalService.getJournalByStudentIds(request.getStudent_ids(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate());
        PageImpl pageWithBadWordFilteredData = new PageImpl(journals.stream().peek(journal -> {
            if (!AppUtils.isNullOrEmpty((String)journal.getJournal_description())) {
                journal.setHasBadWords(this.journalBadWordFilterComponent.isThereAnyBadWordInText(journal.getJournal_description()).booleanValue());
            }
        }).collect(Collectors.toList()), journals.getPageable(), journals.getTotalElements());
        return new ResponseEntity((Object)pageWithBadWordFilteredData, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/journals/by/parent"})
    @ResponseBody
    public ResponseEntity<Page<JournalDTO>> getJournalsByParent(@RequestHeader(value="Authorization") String token, @RequestBody GetPageRequest request) {
        List studentIds;
        Parent parent = this.authService.isParent(token);
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            studentIds = this.studentRepository.findByParentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(Long.valueOf(parent.getParent_id())).stream().filter(Student::isShare_journal_with_parents).map(Student::getStudent_id).collect(Collectors.toList());
            request.getStudent_ids().addAll(studentIds);
        } else {
            studentIds = request.getStudent_ids().stream().filter(id -> {
                Student student = this.studentRepository.findByStudentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(id);
                return student != null && student.isShare_journal_with_parents();
            }).collect(Collectors.toList());
            request.getStudent_ids().clear();
            request.getStudent_ids().addAll(studentIds);
        }
        if (AppUtils.isNullOrEmpty((Set)request.getStudent_ids())) {
            PageRequest paging = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
            return new ResponseEntity((Object)Page.empty((Pageable)paging), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.journalService.getJournalByStudentIds(request.getStudent_ids(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy(), request.getFromDate(), request.getToDate()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/journal"})
    @ResponseBody
    public ResponseEntity<JournalDTO> createJournal(@RequestHeader(value="Authorization") String token, @RequestBody JournalDTO request) {
        Student student = this.authService.isStudent(token);
        if (student.getSchool() != null && !student.getSchool().isEnable_journal()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.save.this.journal.at.this.point.of.time.please.try.again.later"));
        }
        ArrayList hasBadWords = this.journalBadWordFilterComponent.badWordsFoundCompareWordsOnly(request.getJournal_description());
        if (!AppUtils.isNullOrEmpty((List)hasBadWords)) {
            String badWords = String.join((CharSequence)",", hasBadWords);
            Notification n = new Notification();
            n.setInstructor_id(student.getInstructor_id());
            n.setParent_id(student.getParent_id());
            n.setStudent_id(student.getStudent_id());
            n.setNotification_type(NotificationType.BAD_WORD_IN_JOURNAL);
            n.setText("is reported (" + badWords + ") today (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
            n.setText_es("se informa (" + badWords + ") hoy (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
            n.setFormat_text(student.getFirst_name() + " " + student.getLast_name());
            this.notificationRepository.save((Object)n);
            this.setInstructorNewNotifications(student.getInstructor_id());
            String message = null;
            String language = Language.getLanguage();
            if (student.getInstructor() != null && student.getInstructor().getLanguage() != null) {
                language = student.getLanguage();
            }
            if ((message = Language.isSpanish((String)language) ? this.configurationRepository.getConfiguration().getJournal_bad_words_notification() : this.configurationRepository.getConfiguration().getJournal_bad_words_notification_es()) != null) {
                message = message.replace("<name_of_student>", n.getFormat_text());
            }
            String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + message + "\"}";
            this.realTimeMessageService.sendMessage(Long.valueOf(student.getInstructor_id()), json_message);
        }
        return new ResponseEntity((Object)this.journalService.create(student.getStudent_id(), student.isDemo(), request.getMood_id(), request.getMood_name(), request.getMood_name_es(), request.getJournal_description()), HttpStatus.OK);
    }

    public void setInstructorNewNotifications(long instructor_id) {
        try {
            Instructor instructor = this.instructorRepository.findByInstructorId(Long.valueOf(instructor_id));
            instructor.setNew_notificaitons(true);
            this.instructorRepository.save((Object)instructor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/update/journal"})
    @ResponseBody
    public ResponseEntity<JournalDTO> updateJournal(@RequestHeader(value="Authorization") String token, @RequestBody JournalDTO request) {
        Student student = this.authService.isStudent(token);
        if (student.getSchool() != null && !student.getSchool().isEnable_journal()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.update.this.journal.at.this.point.of.time.please.try.again.later"));
        }
        ArrayList hasBadWords = this.journalBadWordFilterComponent.badWordsFoundCompareWordsOnly(request.getJournal_description());
        if (!AppUtils.isNullOrEmpty((List)hasBadWords)) {
            String badWords = String.join((CharSequence)",", hasBadWords);
            Notification n = new Notification();
            n.setInstructor_id(student.getInstructor_id());
            n.setParent_id(student.getParent_id());
            n.setStudent_id(student.getStudent_id());
            n.setNotification_type(NotificationType.BAD_WORD_IN_JOURNAL);
            n.setText("is reported (" + badWords + ") today (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
            n.setText_es("se informa (" + badWords + ") hoy (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
            n.setFormat_text(student.getFirst_name() + " " + student.getLast_name());
            this.notificationRepository.save((Object)n);
            this.setInstructorNewNotifications(student.getInstructor_id());
            String message = null;
            String language = Language.getLanguage();
            if (student.getInstructor() != null && student.getInstructor().getLanguage() != null) {
                language = student.getLanguage();
            }
            if ((message = Language.isSpanish((String)language) ? this.configurationRepository.getConfiguration().getJournal_bad_words_notification() : this.configurationRepository.getConfiguration().getJournal_bad_words_notification_es()) != null) {
                message = message.replace("<name_of_student>", n.getFormat_text());
            }
            String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + message + "\"}";
            this.realTimeMessageService.sendMessage(Long.valueOf(student.getInstructor_id()), json_message);
        }
        return new ResponseEntity((Object)this.journalService.update(request.getJournal_id(), student.getStudent_id(), request.getMood_id(), request.getMood_name(), request.getMood_name_es(), request.getJournal_description()), HttpStatus.OK);
    }

    @PostMapping(value={"/delete/journal"})
    @ResponseBody
    public ResponseEntity<Message> deleteJournal(@RequestHeader(value="Authorization") String token, @RequestBody JournalDTO request) {
        this.authService.isStudent(token);
        this.journalService.deleteById(request.getJournal_id());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.journal.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

