/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.interceptor;

import com.infinite.focus.server.logging.helper.LoggingHelper;
import com.infinite.focus.server.logging.service.LoggingService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private final LoggingService loggingService;

    public ResponseBodyInterceptor(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.displayResp(((ServletServerHttpRequest)request).getServletRequest(), ((ServletServerHttpResponse)response).getServletResponse(), response.getHeaders(), body);
        return body;
    }

    public void displayResp(HttpServletRequest request, HttpServletResponse response, HttpHeaders httpHeaders, Object body) {
        String authorization = request.getHeader("Authorization");
        String url = request.getRequestURI();
        String method = request.getMethod();
        Map headers = LoggingHelper.getHeaders((HttpServletResponse)response, (HttpHeaders)httpHeaders);
        Map parameters = LoggingHelper.getParameters((HttpServletRequest)request);
        Object responseBody = body;
        this.loggingService.saveResponse(authorization, url, method, headers, parameters, responseBody);
    }
}

