/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.streak.repository;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StreakRepositoryImpl
implements StreakRepository {
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationRepository configurationRepository;

    public StreakRepositoryImpl(JdbcTemplate jdbcTemplate, ConfigurationRepository configurationRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.configurationRepository = configurationRepository;
    }

    public StreakDTO findByStreakId(long streak_id) {
        String SQL = "SELECT * FROM streak WHERE streak_id = ? ";
        try {
            return (StreakDTO)this.jdbcTemplate.queryForObject(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1), new Object[]{streak_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StreakDTO> findByStreakType(String streak_type) {
        String SQL = "SELECT * FROM streak WHERE streak_type = ? ";
        try {
            return this.jdbcTemplate.query(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1), new Object[]{streak_type});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StreakDTO>();
        }
    }

    public List<StreakDTO> findByStreaksOrderByStreakIdASC() {
        String SQL = "SELECT * FROM streak ORDER BY streak_id ASC";
        try {
            return this.jdbcTemplate.query(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StreakDTO>();
        }
    }

    private StreakDTO mapRow(ResultSet rs, int i) throws SQLException {
        return StreakDTO.builder().streak_id(rs.getLong("streak_id")).title(rs.getString("title")).title_es(rs.getString("title_es")).description(rs.getString("description")).description_es(rs.getString("description_es")).image(this.configurationRepository.getConfiguration().getStreak_images_path() + rs.getString("image")).image_es(this.configurationRepository.getConfiguration().getStreak_images_path() + rs.getString("image_es")).occurrence(rs.getInt("occurrence")).streak_type(StreakType.valueOf((String)rs.getString("streak_type"))).received(false).createdAt((Date)rs.getTimestamp("created_at")).build();
    }
}

