/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosanswer.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosanswer.request.GetSOSAnswersBySOSRequestIdRequest;
import com.infinite.focus.server.sosanswer.service.SOSAnswerService;
import com.infinite.focus.server.sosanswer.wrapper.SOSAnswersWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sos-answer"})
public class SOSAnswerController {
    @Autowired
    private AuthService authService;
    @Autowired
    private SOSAnswerService sosAnswerService;
    @Autowired
    private ObjectMapper mapper;

    @PostMapping(value={"/create/answers"})
    public ResponseEntity<List<SOSAnswerDTO>> createAnswers(@RequestBody List<SOSAnswerDTO> request) {
        List answers = (List)this.mapper.convertValue(request, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return new ResponseEntity((Object)this.sosAnswerService.createAnswers(answers), HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-sos-answers-by-sos-request-id"})
    public ResponseEntity<List<SOSAnswersWrapper>> getSOSAnswersBySOSRequestId(@RequestBody GetSOSAnswersBySOSRequestIdRequest request) {
        return new ResponseEntity((Object)this.sosAnswerService.getSOSAnswersBySOSRequestId(request.getSos_request_id().longValue(), request.getImage_width()), HttpStatus.OK);
    }
}

