/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosanswer.service;

import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosanswer.repository.SOSAnswerRepository;
import com.infinite.focus.server.sosanswer.service.SOSAnswerService;
import com.infinite.focus.server.sosanswer.wrapper.SOSAnswersWrapper;
import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosquestion.dto.SOSQuestionDTO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SOSAnswerServiceImpl
implements SOSAnswerService {
    @Autowired
    private SOSAnswerRepository sosAnswerRepository;
    @Autowired
    private RestComponent restComponent;

    public List<SOSAnswerDTO> createAnswers(List<SOSAnswerDTO> answers) {
        ArrayList ids = this.sosAnswerRepository.createAnswers(answers);
        return this.getByIds((List)ids);
    }

    public List<SOSAnswerDTO> getByIds(List<Long> ids) {
        return this.sosAnswerRepository.getByIds(ids);
    }

    public List<SOSAnswersWrapper> getSOSAnswersBySOSRequestId(long sos_request_id, Integer image_width) {
        List sosAnswerDTOS = this.sosAnswerRepository.findBySOSRequestId(sos_request_id);
        Set sos_question_ids = sosAnswerDTOS.stream().map(SOSAnswerDTO::getSos_question_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        List sosQuestionDTOS = this.restComponent.getSOSQuestionsByIds(sos_question_ids, image_width);
        Set sos_option_ids = sosAnswerDTOS.stream().map(SOSAnswerDTO::getSos_option_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        List sosOptionDTOS = this.restComponent.getSOSOptionsByIds(sos_option_ids);
        ArrayList<SOSAnswersWrapper> sosAnswersWrappers = new ArrayList<SOSAnswersWrapper>();
        for (Long sos_question_id : sos_question_ids) {
            Optional<SOSQuestionDTO> sos_question = sosQuestionDTOS.stream().filter(q -> q.getSos_question_id() == sos_question_id.longValue()).findAny();
            if (!sos_question.isPresent()) continue;
            Set sos_options = sosOptionDTOS.stream().filter(o -> o.getSos_question_id() == sos_question_id.longValue()).sorted(Comparator.comparingInt(SOSOptionDTO::getSort_index)).collect(Collectors.toCollection(LinkedHashSet::new));
            sosAnswersWrappers.add(SOSAnswersWrapper.builder().sos_question(sos_question.get()).sos_options(sos_options).build());
        }
        return sosAnswersWrappers;
    }
}

