/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.parent.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.request.StudentsSignUpRequest;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.request.AddStudentByRegistrationCodeRequest;
import com.infinite.focus.server.parent.request.CreateParentRequest;
import com.infinite.focus.server.parent.request.GetStudentProfileByTokenRequest;
import com.infinite.focus.server.parent.request.GetStudentProfileByTokenWrapper;
import com.infinite.focus.server.parent.request.ParentDataApiRequest;
import com.infinite.focus.server.parent.request.RemoveAccessForChildRequest;
import com.infinite.focus.server.parent.request.SetNewNotificationsForParentRequest;
import com.infinite.focus.server.parent.request.SetStudentParentDetailRequest;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.request.UpdateParentRequest;
import com.infinite.focus.server.parent.request.VerifyStudentProfileByOtpAndTokenRequest;
import com.infinite.focus.server.parent.response.TheDailyClymbResponse;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.parent.wrapper.RemoveAccessForChildWrapper;
import com.infinite.focus.server.parent.wrapper.VerifyChildProfileWrapper;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.twilio.service.SmsService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/parent"})
public class ParentController {
    private final AuthService authService;
    private final StudentService studentService;
    private final ParentService parentService;
    private final TemplateService templateService;
    private final SchoolService schoolService;
    private final SmsService smsService;
    private final AccountService accountService;
    private final OrganizationAdminService organizationAdminService;
    private final MessageService messageService;
    private final ValidationService validationService;
    private final JwtHelper jwtHelper;

    public ParentController(AuthService authService, StudentService studentService, ParentService parentService, TemplateService templateService, SchoolService schoolService, SmsService smsService, AccountService accountService, OrganizationAdminService organizationAdminService, MessageService messageService, ValidationService validationService, JwtHelper jwtHelper) {
        this.authService = authService;
        this.studentService = studentService;
        this.parentService = parentService;
        this.templateService = templateService;
        this.schoolService = schoolService;
        this.smsService = smsService;
        this.accountService = accountService;
        this.organizationAdminService = organizationAdminService;
        this.messageService = messageService;
        this.validationService = validationService;
        this.jwtHelper = jwtHelper;
    }

    @PostMapping(value={"/set-student-parent-detail"})
    @ResponseBody
    public ResponseEntity<Message> setStudentParentDetail(@RequestHeader(value="Authorization") String token, @RequestBody SetStudentParentDetailRequest request) {
        this.authService.isInstructor(token);
        if (!this.smsService.isValidPhone(request.getPhone())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("please.enter.a.valid.phone.number"));
        }
        Student student = this.studentService.setParentDetail(request.getStudent_id(), request.getCountry_code(), request.getPhone(), request.getEmail());
        this.parentService.sendSMSandEmailToParent(student);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("student.parent.detail.updated"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/remove-access-for-child"})
    @ResponseBody
    public ResponseEntity<RemoveAccessForChildWrapper> removeAccessForChild(@RequestHeader(value="Authorization") String token, @RequestBody RemoveAccessForChildRequest request) {
        Parent parent = this.authService.isParent(token);
        Student student = this.parentService.removeAccessForChild(parent, request.getStudent_id());
        Message message = new Message();
        if (student.isAccess_removed_by_parent()) {
            message.setMessage(this.messageService.getMessage("access.removed"));
        } else {
            message.setMessage(this.messageService.getMessage("access.provided"));
        }
        RemoveAccessForChildWrapper removeAccessForChildWrapper = new RemoveAccessForChildWrapper();
        removeAccessForChildWrapper.setMessage(message);
        removeAccessForChildWrapper.setStudent(student);
        return new ResponseEntity((Object)removeAccessForChildWrapper, HttpStatus.OK);
    }

    @PostMapping(value={"/get/student/profile/by/token"})
    @ResponseBody
    public ResponseEntity<GetStudentProfileByTokenWrapper> getStudentProfileByToken(@RequestBody GetStudentProfileByTokenRequest request) {
        GetStudentProfileByTokenWrapper wrapper = new GetStudentProfileByTokenWrapper();
        Student student = this.parentService.getStudentProfileByToken(request.getToken());
        wrapper.setStudent(student);
        School school = this.schoolService.getSchoolByStudentId(student.getStudent_id());
        wrapper.setSchool_name(school.getSchool_name());
        return new ResponseEntity((Object)wrapper, HttpStatus.OK);
    }

    @PostMapping(value={"/delete/student/by/token"})
    @ResponseBody
    public ResponseEntity<Message> deleteStudentByToken(@RequestBody GetStudentProfileByTokenRequest request) {
        Student student = this.parentService.deleteStudentByToken(request.getToken());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("your.child.will.not.be.able.to.access.clymb.now"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/vefiry/student/profile/by/otp/and/token"})
    @ResponseBody
    public ResponseEntity<VerifyChildProfileWrapper> verifyStudentProfileWithOtpAndToken(@RequestBody VerifyStudentProfileByOtpAndTokenRequest request) {
        VerifyChildProfileWrapper wrapper = this.parentService.verifyChildProfileWithOtpAndToken(request.getOtp(), request.getToken(), request.getStatus());
        return new ResponseEntity((Object)wrapper, HttpStatus.OK);
    }

    @GetMapping(value={"/read/file"})
    public ResponseEntity<String> getCount() {
        String content = this.templateService.getConsentForm("Takoma Park", "https://google.com", null, Language.getLanguage());
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @GetMapping(value={"send/email/to/parent/did/not/accept/child/profile"})
    public ResponseEntity<Message> sendEmailToParentDidNotAcceptChildProfile() {
        this.parentService.sendEmailToParentDidNotAcceptChildProfile();
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("emails.have.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/add-children"})
    @ResponseBody
    public ResponseEntity<Message> addChildren(@RequestHeader(value="Authorization") String token, @RequestBody StudentsSignUpRequest request) {
        Parent parent = this.authService.isParent(token);
        if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getPassword())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("password.is.required"));
        }
        Account account = this.accountService.createAccountByPassword(request.getPassword());
        Student student = new Student();
        student.setAccount(account);
        student.setFirst_name(request.getFirst_name());
        student.setLast_name(request.getLast_name());
        student.setParent(parent);
        this.studentService.save(student);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("children.added.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"happiness-altitude"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>> happinessAltitude(@RequestHeader(value="Authorization") String token, @RequestBody ParentDataApiRequest request) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity((Object)this.parentService.happinessAltitude(parent, request, parent.getLanguage()), HttpStatus.OK);
    }

    @PostMapping(value={"the-daily-clymb"})
    @ResponseBody
    public ResponseEntity<TheDailyClymbResponse> theDailyClymb(@RequestHeader(value="Authorization") String token, @RequestBody TheDailyClymbRequest request) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity((Object)this.parentService.theDailyClymb(parent, request), HttpStatus.OK);
    }

    @PostMapping(value={"comprehensive-report"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, Object>> comprehensiveReport(@RequestHeader(value="Authorization") String token, @RequestBody ParentDataApiRequest request) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity((Object)this.parentService.comprehensiveReport(parent, request, parent.getLanguage()), HttpStatus.OK);
    }

    @PostMapping(value={"/get/sel/analytics"})
    public ResponseEntity<Object> getSELAnalytics(@RequestHeader(value="Authorization") String token, @RequestBody ParentDataApiRequest request) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity(this.parentService.getSELAnalytics(parent, request), HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Parent> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody Parent request) {
        Parent p = this.authService.isParent(token);
        if (p == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.parent.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getState())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.state.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getCity())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.city.is.required"));
        }
        if (p.getOrganizationAdmin() != null) {
            for (OrganizationAdmin o : this.organizationAdminService.findByOrganizationTypeAndAccountId(OrganizationType.PARENT.toString(), p.getOrganizationAdmin().getAccount_id())) {
                o.setFirst_name(request.getFirst_name());
                o.setLast_name(request.getLast_name());
                o.setState(request.getState());
                o.setCity(request.getCity());
                Account account = this.accountService.changeEmail(o.getAccount_id(), request.getUsername());
                OrganizationAdmin organizationAdmin = this.organizationAdminService.save(o);
            }
        } else {
            OrganizationAdmin o;
            p.setFirst_name(request.getFirst_name());
            p.setLast_name(request.getLast_name());
            p.setState(request.getState());
            p.setCity(request.getCity());
            Account account = this.accountService.changeEmail(p.getAccount_id(), request.getUsername());
            o = this.parentService.save(p);
        }
        String newToken = this.jwtHelper.generateToken(request.getUsername());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(request.getUsername()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)this.authService.isParent(newToken));
    }

    @GetMapping(value={"get-children"})
    public ResponseEntity<Set<Student>> getChildren(@RequestHeader(value="Authorization") String token) {
        Parent parent = this.authService.isParent(token);
        return new ResponseEntity((Object)parent.getStudents(), HttpStatus.OK);
    }

    @PostMapping(value={"/add/student/by/registration-code"})
    public ResponseEntity<Message> addStudentByRegistrationCode(@RequestHeader(value="Authorization") String token, @RequestBody AddStudentByRegistrationCodeRequest request) {
        Parent parent = this.authService.isParent(token);
        Student student = this.studentService.findByRegistrationCode(request.getRegistration_code());
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        ValidationResponse validationResponse = this.validationService.isValidStudent(student.getStudent_id());
        if (!validationResponse.isValid()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        student.setParent(parent);
        this.studentService.save(student);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.student.is.added.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get-parent-by-id"})
    public ResponseEntity<Parent> getParentById(@RequestBody GetByIdRequest request) {
        return new ResponseEntity((Object)this.parentService.getParentById(request.getId()), HttpStatus.OK);
    }

    @PostMapping(value={"/set-new-notifications"})
    public ResponseEntity<Void> setNewNotifications(@RequestBody SetNewNotificationsForParentRequest request) {
        this.parentService.setParentNewNotifications(request.getParent_ids(), request.isNew_notifications());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/create-parent"})
    public ResponseEntity<Parent> createParent(@RequestBody CreateParentRequest request) {
        Parent parent = this.parentService.createParent(request.getSchool_id(), request.getCountry_code(), request.getPhone(), request.getEmail());
        return new ResponseEntity((Object)parent, HttpStatus.OK);
    }

    @PostMapping(value={"/update-parent"})
    public ResponseEntity<Parent> updateParent(@RequestBody UpdateParentRequest request) {
        Parent parent = this.parentService.updateParent(request.getParent_id(), request.getCountry_code(), request.getPhone(), request.getEmail());
        return new ResponseEntity((Object)parent, HttpStatus.OK);
    }
}

