/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.parent.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.dashboard.selanalytics.selfawareness.SelfAwarenessDataService;
import com.infinite.focus.server.data.model.MoodOccurance;
import com.infinite.focus.server.data.service.DataService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.group.service.ClassAndStudentService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.service.MoodService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.entity.StudentProfileOtp;
import com.infinite.focus.server.parent.repository.ParentRepository;
import com.infinite.focus.server.parent.repository.StudentProfileOtpRepository;
import com.infinite.focus.server.parent.request.ParentDataApiRequest;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.response.TheDailyClymbResponse;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.parent.wrapper.ParentAndLinkWrapper;
import com.infinite.focus.server.parent.wrapper.VerifyChildProfileWrapper;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.shortenurl.entity.ShortenUrl;
import com.infinite.focus.server.shortenurl.request.ShortenUrlRequest;
import com.infinite.focus.server.shortenurl.service.ShortenUrlService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.twilio.request.SmsRequest;
import com.infinite.focus.server.twilio.service.SmsService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParentServiceImpl
implements ParentService {
    private final RestComponent restComponent;
    private final ConfigurationService configurationService;
    private final ParentRepository parentRepository;
    private final StudentProfileOtpRepository studentProfileOtpRepository;
    private final EmailSenderService emailSenderService;
    private final SmsService smsService;
    private final StudentService studentService;
    private final ShortenUrlService shortenUrlService;
    private final TemplateService templateService;
    private final MessageService messageService;
    private final SelfAwarenessDataService moodDataService;
    private final MoodService moodService;
    private final ActivityService activityService;
    private final ActivityCriteriaRepository activityCriteriaRepository;
    private final DataService dataService;
    private final AccountService accountService;
    private final ClassAndStudentService classAndStudentService;

    public ParentServiceImpl(RestComponent restComponent, ConfigurationService configurationService, ParentRepository parentRepository, StudentProfileOtpRepository studentProfileOtpRepository, EmailSenderService emailSenderService, SmsService smsService, StudentService studentService, ShortenUrlService shortenUrlService, TemplateService templateService, MessageService messageService, SelfAwarenessDataService moodDataService, MoodService moodService, ActivityService activityService, ActivityCriteriaRepository activityCriteriaRepository, DataService dataService, AccountService accountService, ClassAndStudentService classAndStudentService) {
        this.restComponent = restComponent;
        this.configurationService = configurationService;
        this.parentRepository = parentRepository;
        this.studentProfileOtpRepository = studentProfileOtpRepository;
        this.emailSenderService = emailSenderService;
        this.smsService = smsService;
        this.studentService = studentService;
        this.shortenUrlService = shortenUrlService;
        this.templateService = templateService;
        this.messageService = messageService;
        this.moodDataService = moodDataService;
        this.moodService = moodService;
        this.activityService = activityService;
        this.activityCriteriaRepository = activityCriteriaRepository;
        this.dataService = dataService;
        this.accountService = accountService;
        this.classAndStudentService = classAndStudentService;
    }

    public Parent createParent(long school_id, String country_code, String phone, String email) {
        if (AppUtils.isNullOrEmpty((String)phone) && AppUtils.isNullOrEmpty((String)email)) {
            return null;
        }
        Parent parent = null;
        Account account = this.accountService.findByEmail(email);
        if (account != null) {
            parent = this.parentRepository.findByAccountId(account.getAccount_id());
        }
        String password = AppUtils.generatePassword();
        if (account == null && AppUtils.isNullOrEmpty((String)email) || !AppUtils.isValidateEmail((String)email)) {
            account = this.accountService.createAccountByPassword(password);
        }
        if (account == null && !AppUtils.isNullOrEmpty((String)email) && AppUtils.isValidateEmail((String)email)) {
            account = this.accountService.createAccountByEmailAndPassword(email, password);
        }
        boolean isNew = false;
        if (parent == null) {
            isNew = true;
            parent = new Parent();
            try {
                School school = this.restComponent.getSchoolById(school_id);
                if (school != null) {
                    parent.setSchool_id(school.getSchool_id());
                    parent.setDistrict_id(school.getDistrict_id());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        parent.setAccount(account);
        if (AppUtils.isNullOrEmpty((String)country_code)) {
            parent.setCountry_code("+1");
        } else {
            parent.setCountry_code(country_code);
        }
        parent.setPhone(phone);
        parent.setEmail(email);
        parent.setLanguage(Language.getLanguage());
        if (AppUtils.isNullOrEmpty((String)parent.getRegistration_code())) {
            Boolean isUnique = false;
            while (!isUnique.booleanValue()) {
                String possible_code = KeyGenerator.generateUniqueAuthCode();
                Parent x = this.findByRegistrationCode(possible_code);
                if (x == null) {
                    isUnique = true;
                    parent.setRegistration_code("P" + possible_code);
                    continue;
                }
                isUnique = false;
            }
        }
        Parent p = (Parent)this.parentRepository.save((Object)parent);
        if (isNew) {
            Account finalAccount = account;
            new Thread(() -> {
                try {
                    this.emailSenderService.sendHtmlMail(finalAccount.getUsername(), Language.isSpanish((String)Language.getLanguage()) ? "Bienvenido a Clymb" : "Welcome to Clymb", this.templateService.getSendEmailToParentForDashboardAccessWithoutCorporate(this.configurationService.getConfiguration().getBaseUrlCorporate(), finalAccount.getUsername(), password, Language.getLanguage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        return p;
    }

    public Parent updateParent(long parent_id, String country_code, String phone, String email) {
        Parent parent = this.parentRepository.findByParentId(parent_id);
        if (AppUtils.isNullOrEmpty((String)phone) && AppUtils.isNullOrEmpty((String)email)) {
            this.parentRepository.delete((Object)parent);
            return null;
        }
        if (AppUtils.isNullOrEmpty((String)country_code)) {
            parent.setCountry_code("+1");
        } else {
            parent.setCountry_code(country_code);
        }
        parent.setPhone(phone);
        parent.setEmail(email);
        return (Parent)this.parentRepository.save((Object)parent);
    }

    public void sendSMSandEmailToParent(Student student) {
        Parent parent = student.getParent();
        if (parent == null) {
            return;
        }
        StudentProfileOtp studentProfileOtp = this.studentProfileOtpRepository.findByAccountId(Long.valueOf(student.getAccount_id()));
        if (studentProfileOtp == null) {
            studentProfileOtp = (StudentProfileOtp)this.studentProfileOtpRepository.save((Object)new StudentProfileOtp(student.getAccount()));
        } else {
            studentProfileOtp.setStatus(Status.PENDING);
            studentProfileOtp.setOtp(AppUtils.generateRandomOtp());
            studentProfileOtp.setToken(UUID.randomUUID().toString());
            studentProfileOtp.setCreatedDate(new Date());
            studentProfileOtp = (StudentProfileOtp)this.studentProfileOtpRepository.save((Object)studentProfileOtp);
        }
        try {
            System.out.println(parent.getPhone());
            System.out.println(parent.getEmail());
            this.shortenUrlService.deleteByStudentProfileOtpId(studentProfileOtp.getStudent_profile_otp_id());
            String baseUrl = this.configurationService.getConfiguration().getVerify_student_profile();
            ShortenUrlRequest shortenUrlRequest = new ShortenUrlRequest();
            shortenUrlRequest.setUrl(baseUrl + EncryptDecryptHelper.base64Encode((String)studentProfileOtp.getToken()));
            shortenUrlRequest.setStudent_profile_otp_id(studentProfileOtp.getStudent_profile_otp_id());
            ShortenUrl shortenUrl = this.shortenUrlService.generateShortLink(shortenUrlRequest);
            String shortUrl = this.configurationService.getConfiguration().getBaseUrlApi() + shortenUrl.getShort_link();
            School school = this.restComponent.getSchoolByStudentId(student.getStudent_id());
            if (AppUtils.isNotNullOrEmpty((String)parent.getCountry_code()) && AppUtils.isNotNullOrEmpty((String)parent.getPhone())) {
                try {
                    SmsRequest smsRequest = new SmsRequest();
                    smsRequest.setPhoneNumber(parent.getCountry_code() + parent.getPhone());
                    smsRequest.setMessage(Language.isSpanish() ? school.getSchool_name() + " comenzar\u00e1 a utilizar Clymb, una plataforma en l\u00ednea que ayuda a los j\u00f3venes a desarrollar habilidades sociales esenciales. Haga clic a continuaci\u00f3n para verificar el perfil de su hijo\n" + shortUrl : school.getSchool_name() + " will begin using Clymb, an online platform that helps youth develop essential social skills. Click below to verify your child's profile\n" + shortUrl);
                    this.smsService.sendSms(smsRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (AppUtils.isNotNullOrEmpty((String)parent.getEmail())) {
                try {
                    this.emailSenderService.sendHtmlMail(parent.getEmail(), Language.isSpanish((String)parent.getLanguage()) ? "Verificar la cuenta Clymb de " + student.getFirst_name() + " " + student.getLast_name() : "Verify " + student.getFirst_name() + " " + student.getLast_name() + "\u2019s Clymb Account", this.templateService.getConsentForm(school.getSchool_name(), shortUrl, student, parent.getLanguage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Student getStudentProfileByToken(String encryptToken) {
        String token = EncryptDecryptHelper.base64Decode((String)encryptToken);
        StudentProfileOtp studentProfileOtp = this.studentProfileOtpRepository.findByToken(token);
        if (studentProfileOtp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.token"));
        }
        long hours = DateUtils.countHoursBetweenFromDateAndToDate((Date)studentProfileOtp.getCreatedDate(), (Date)new Date());
        System.out.println("hours " + hours);
        if (hours >= (long)this.configurationService.getConfiguration().getStudent_profile_verification_token_time_out()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.link.has.expired"));
        }
        if (studentProfileOtp.getStatus().equals((Object)Status.REJECTED)) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.child.profile.is.already.rejected"));
        }
        Student student = this.studentService.getStudentByAccountId(studentProfileOtp.getAccount().getAccount_id());
        student.setStatus(studentProfileOtp.getStatus());
        return student;
    }

    public Student deleteStudentByToken(String encryptToken) {
        String token = EncryptDecryptHelper.base64Decode((String)encryptToken);
        StudentProfileOtp studentProfileOtp = this.studentProfileOtpRepository.findByToken(token);
        if (studentProfileOtp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.token"));
        }
        Student student = this.studentService.getStudentByAccountId(studentProfileOtp.getAccount().getAccount_id());
        ArrayList<Long> studentIds = new ArrayList<Long>();
        studentIds.add(student.getStudent_id());
        this.classAndStudentService.deleteStudentsByIds(studentIds);
        return student;
    }

    public VerifyChildProfileWrapper verifyChildProfileWithOtpAndToken(Integer otp, String encryptToken, Status status) {
        long hours;
        String token = EncryptDecryptHelper.base64Decode((String)encryptToken);
        System.out.println("decrypt " + token);
        StudentProfileOtp studentProfileOtp = null;
        if (otp == null) {
            studentProfileOtp = this.studentProfileOtpRepository.findByToken(token);
            if (studentProfileOtp == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.token"));
            }
        } else {
            studentProfileOtp = this.studentProfileOtpRepository.findByOtpAndToken(otp.intValue(), token);
            if (studentProfileOtp == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.otp.or.token"));
            }
        }
        if ((hours = DateUtils.countHoursBetweenFromDateAndToDate((Date)studentProfileOtp.getCreatedDate(), (Date)new Date())) >= (long)this.configurationService.getConfiguration().getStudent_profile_verification_token_time_out()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.link.has.expired"));
        }
        if (studentProfileOtp.getStatus().equals((Object)Status.REJECTED)) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("your.child.profile.is.already.rejected"));
        }
        studentProfileOtp.setStatus(status);
        this.restComponent.updateAccessCodeByAccountIdAndStatus(studentProfileOtp.getAccount().getAccount_id(), status);
        VerifyChildProfileWrapper wrapper = new VerifyChildProfileWrapper();
        Message message = new Message();
        if (status.equals((Object)Status.ACCEPTED)) {
            message.setMessage(this.messageService.getMessage("your.child.profile.is.accepted"));
        }
        if (studentProfileOtp.getStatus().equals((Object)Status.REJECTED)) {
            message.setMessage(this.messageService.getMessage("your.child.will.not.be.able.to.access.clymb.now"));
        }
        wrapper.setMessage(message);
        this.studentProfileOtpRepository.save((Object)studentProfileOtp);
        Student student = this.studentService.getStudentByAccountId(studentProfileOtp.getAccount().getAccount_id());
        student.setStatus(studentProfileOtp.getStatus());
        wrapper.setStudent(student);
        School school = this.restComponent.getSchoolByStudentId(student.getStudent_id());
        wrapper.setSchool_name(school.getSchool_name());
        return wrapper;
    }

    public void sendEmailToParentDidNotAcceptChildProfile() {
        List studentProfileOtpList = this.studentProfileOtpRepository.findByStatus(Status.PENDING.toString());
        ArrayList<ParentAndLinkWrapper> parentAndLinkWrappers = new ArrayList<ParentAndLinkWrapper>();
        for (StudentProfileOtp studentProfileOtp : studentProfileOtpList) {
            Date todayDate;
            Date sendDate = DateUtils.setTimeToFromDate((Date)studentProfileOtp.getCreatedDate());
            long dayCount = DateUtils.countDaysBetweenFromDateAndToDate((Date)sendDate, (Date)(todayDate = DateUtils.setTimeToFromDate((Date)new Date())));
            if (dayCount <= 1L || dayCount % 2L != 0L || dayCount > 7L) continue;
            studentProfileOtp.setStatus(Status.PENDING);
            studentProfileOtp.setOtp(AppUtils.generateRandomOtp());
            studentProfileOtp.setToken(UUID.randomUUID().toString());
            studentProfileOtp.setCreatedDate(studentProfileOtp.getCreatedDate());
            studentProfileOtp = (StudentProfileOtp)this.studentProfileOtpRepository.save((Object)studentProfileOtp);
            Student student = this.studentService.getStudentByAccountId(studentProfileOtp.getAccount().getAccount_id());
            ParentAndLinkWrapper parentAndLinkWrapper = new ParentAndLinkWrapper();
            parentAndLinkWrapper.setParent(student.getParent());
            parentAndLinkWrapper.setStudent(student);
            this.shortenUrlService.deleteByStudentProfileOtpId(studentProfileOtp.getStudent_profile_otp_id());
            String baseUrl = this.configurationService.getConfiguration().getVerify_student_profile();
            ShortenUrlRequest shortenUrlRequest = new ShortenUrlRequest();
            shortenUrlRequest.setUrl(baseUrl + EncryptDecryptHelper.base64Encode((String)studentProfileOtp.getToken()));
            shortenUrlRequest.setStudent_profile_otp_id(studentProfileOtp.getStudent_profile_otp_id());
            ShortenUrl shortenUrl = this.shortenUrlService.generateShortLink(shortenUrlRequest);
            String shortUrl = this.configurationService.getConfiguration().getBaseUrlApi() + shortenUrl.getShort_link();
            parentAndLinkWrapper.setShortLink(shortUrl);
            parentAndLinkWrappers.add(parentAndLinkWrapper);
        }
        for (ParentAndLinkWrapper parentAndLinkWrapper : parentAndLinkWrappers) {
            try {
                Student student = parentAndLinkWrapper.getStudent();
                School school = this.restComponent.getSchoolByStudentId(student.getStudent_id());
                if (AppUtils.isNotNullOrEmpty((String)parentAndLinkWrapper.getParent().getCountry_code()) && AppUtils.isNotNullOrEmpty((String)parentAndLinkWrapper.getParent().getPhone())) {
                    try {
                        SmsRequest smsRequest = new SmsRequest();
                        smsRequest.setPhoneNumber(parentAndLinkWrapper.getParent().getCountry_code() + parentAndLinkWrapper.getParent().getPhone());
                        smsRequest.setMessage(Language.isSpanish() ? school.getSchool_name() + " comenzar\u00e1 a utilizar Clymb, una plataforma en l\u00ednea que ayuda a los j\u00f3venes a desarrollar habilidades sociales esenciales. Haga clic a continuaci\u00f3n para verificar el perfil de su hijo\n" + parentAndLinkWrapper.getShortLink() : school.getSchool_name() + " will begin using Clymb, an online platform that helps youth develop essential social skills. Click below to verify your child's profile\n" + parentAndLinkWrapper.getShortLink());
                        this.smsService.sendSms(smsRequest);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!AppUtils.isNotNullOrEmpty((String)parentAndLinkWrapper.getParent().getEmail())) continue;
                System.out.println(parentAndLinkWrapper.getParent().getEmail());
                try {
                    this.emailSenderService.sendHtmlMail(parentAndLinkWrapper.getParent().getEmail(), Language.isSpanish((String)parentAndLinkWrapper.getParent().getLanguage()) ? "Verificar la cuenta Clymb de " + student.getFirst_name() + " " + student.getLast_name() : "Verify " + student.getFirst_name() + " " + student.getLast_name() + "\u2019s Clymb Account", this.templateService.getFollowUpConsentForm(school.getSchool_name(), parentAndLinkWrapper.getShortLink(), student, parentAndLinkWrapper.getParent().getLanguage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public StudentProfileOtp updateStudentProfileOtpByAccountIdAndStatus(long account_id, Status status) {
        StudentProfileOtp studentProfileOtp = this.studentProfileOtpRepository.findByAccountId(Long.valueOf(account_id));
        if (studentProfileOtp == null) {
            return null;
        }
        studentProfileOtp.setStatus(status);
        return (StudentProfileOtp)this.studentProfileOtpRepository.save((Object)studentProfileOtp);
    }

    public StudentProfileOtp getStudentProfileOtpByAccountId(long account_id) {
        return this.studentProfileOtpRepository.findByAccountId(Long.valueOf(account_id));
    }

    public Parent save(Parent parent) {
        return (Parent)this.parentRepository.save((Object)parent);
    }

    public List<Parent> saveAll(List<Parent> parent) {
        return this.parentRepository.saveAll(parent);
    }

    public Parent findByRegistrationCode(String registration_code) {
        return this.parentRepository.findByRegistrationCode(registration_code);
    }

    public Parent getParentByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Parent findByAccountId(long account_id) {
        List organizationAdmins;
        Parent parent = this.parentRepository.findByAccountId(account_id);
        if (parent == null && !AppUtils.isNullOrEmpty((List)(organizationAdmins = this.restComponent.getByOrganizationTypeAndAccountId(OrganizationType.PARENT.toString(), account_id)))) {
            OrganizationAdmin organizationAdmin = (OrganizationAdmin)organizationAdmins.get(0);
            parent = this.parentRepository.findByParentId(organizationAdmin.getOrganization_id());
            parent.setOrganizationAdmin(organizationAdmin);
        }
        return parent;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> happinessAltitude(Parent parent, ParentDataApiRequest request, String language) {
        if (AppUtils.isNullOrEmpty((List)request.getStudentIds())) {
            List studentIds = parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toList());
            request.setStudentIds(studentIds);
        }
        return this.filterHappinessAltitudeMoods(this.getMoodCountAndPercentage(request.getStudentIds(), request.getFromDate(), request.getToDate(), false, false, language), language);
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> filterHappinessAltitudeMoods(LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> allMoods, String language) {
        LinkedHashSet happinessAltitudeMoods = this.moodService.getAllHappinessAltitudeMoodsOrderBySortIndex().stream().map(mood -> {
            String[] keys = new String[2];
            keys[0] = mood.getMood();
            if (Language.isSpanish((String)language)) {
                keys[1] = mood.getMood_es();
            }
            return keys;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashMap<String, LinkedList<Double>> mapHappinessAltitudeMoods_en = new LinkedHashMap<String, LinkedList<Double>>();
        LinkedHashMap<String, LinkedList<Double>> mapHappinessAltitudeMoods_es = new LinkedHashMap<String, LinkedList<Double>>();
        for (String[] keys : happinessAltitudeMoods) {
            mapHappinessAltitudeMoods_en.put(keys[0], allMoods.get("en").get(keys[0]));
            if (!Language.isSpanish((String)language)) continue;
            mapHappinessAltitudeMoods_es.put(keys[1], allMoods.get("es").get(keys[1]));
        }
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> mapHappinessAltitudeMoods = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        mapHappinessAltitudeMoods.put("en", mapHappinessAltitudeMoods_en);
        if (Language.isSpanish((String)language)) {
            mapHappinessAltitudeMoods.put("es", mapHappinessAltitudeMoods_es);
        }
        return mapHappinessAltitudeMoods;
    }

    public Parent findByCleverId(String clever_parent_id) {
        return this.parentRepository.findByCleverId(clever_parent_id);
    }

    public TheDailyClymbResponse theDailyClymb(Parent parent, TheDailyClymbRequest request) {
        List studentIds = parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toList());
        TheDailyClymbResponse response = new TheDailyClymbResponse();
        response.setTodaysClymbers(this.todaysClymbers(studentIds, request.getToday()));
        response.setTotalClymbers((long)parent.getStudents().size());
        response.setAverageClymbDuration(DateUtils.getMinutesAndSecondInString((long)this.averageClymbDuration(studentIds, request.getToday())));
        response.setTotalHappinessAltitude(this.totalHappinessAltitude(studentIds, request.getToday(), parent.getLanguage()));
        response.setHalfOfTheClymbersHaveReachedHappinessAltitude(this.halfOfTheClymbersHaveReachedHappinessAltitude(studentIds, request.getToday(), parent.getLanguage()));
        return response;
    }

    public long todaysClymbers(List<Long> studentIds, ZonedDateTime today) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return 0L;
        }
        Date fromDate = Date.from(today.with(LocalTime.MIN).toInstant());
        Date toDate = Date.from(today.with(LocalTime.MAX).toInstant());
        return this.activityCriteriaRepository.getActivitiesByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate).stream().map(ActivityDTO::getStudent_id).distinct().count();
    }

    public long averageClymbDuration(List<Long> studentIds, ZonedDateTime today) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return 0L;
        }
        Date fromDate = Date.from(today.with(LocalTime.MIN).toInstant());
        Date toDate = Date.from(today.with(LocalTime.MAX).toInstant());
        List activities = this.activityCriteriaRepository.getActivitiesByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
        return studentIds.size() == 0 || activities.size() == 0 ? 0L : this.activityService.getTotalTimeSpent(activities) / (long)studentIds.size();
    }

    public long averageClymbDuration(List<Long> studentIds, Date fromDate, Date toDate) {
        List activities = this.activityCriteriaRepository.getActivitiesByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
        return studentIds.size() == 0 || activities.size() == 0 ? 0L : this.activityService.getTotalTimeSpent(activities) / (long)studentIds.size();
    }

    public boolean halfOfTheClymbersHaveReachedHappinessAltitude(List<Long> studentIds, ZonedDateTime today, String language) {
        Date weekEndDate;
        ZonedDateTime startOfLastWeek = today.minusWeeks(1L).with(DayOfWeek.MONDAY).with(LocalTime.MIN);
        ZonedDateTime endOfLastWeek = startOfLastWeek.plusDays(6L).with(LocalTime.MAX);
        Date weekStartDate = Date.from(startOfLastWeek.toInstant());
        return this.totalHappinessAltitudePercentage(studentIds, weekStartDate, weekEndDate = Date.from(endOfLastWeek.toInstant()), language) > 50.0;
    }

    public double totalHappinessAltitude(List<Long> studentIds, ZonedDateTime today, String language) {
        Date fromDate = Date.from(today.with(LocalTime.MIN).toInstant());
        Date toDate = Date.from(today.with(LocalTime.MAX).toInstant());
        return this.totalHappinessAltitudePercentage(studentIds, fromDate, toDate, language);
    }

    public double totalHappinessAltitudePercentage(List<Long> studentIds, Date fromDate, Date toDate, String language) {
        LinkedHashMap moodCountAndPercentage = this.getMoodCountAndPercentage(studentIds, fromDate, toDate, false, false, language);
        List happinessAltitudeMoods = this.moodService.getAllHappinessAltitudeMoodsOrderBySortIndex().stream().filter(MoodDTO::isHappiness_altitude).map(MoodDTO::getMood).collect(Collectors.toList());
        double totalHappinessAltitudePercentage = 0.0;
        for (String key : happinessAltitudeMoods) {
            totalHappinessAltitudePercentage += ((Double)((LinkedList)((LinkedHashMap)moodCountAndPercentage.get("en")).get(key)).get(1)).doubleValue();
        }
        return DigitUtils.formatDoubleInTwoDigit((Double)Math.min(totalHappinessAltitudePercentage, 100.0));
    }

    public double totalHappinessAltitudePercentageByMoodUpdateAfter(List<Long> studentIds, Date fromDate, Date toDate) {
        LinkedHashMap moodCountAndPercentage = this.getMoodCountAndPercentageByMoodUpdateAfter(studentIds, fromDate, toDate, false, false);
        List happinessAltitudeMoods = this.moodService.getAllHappinessAltitudeMoodsOrderBySortIndex().stream().filter(MoodDTO::isHappiness_altitude).map(MoodDTO::getMood).collect(Collectors.toList());
        double totalHappinessAltitudePercentage = 0.0;
        for (String key : happinessAltitudeMoods) {
            totalHappinessAltitudePercentage += ((Double)((LinkedList)moodCountAndPercentage.get(key)).get(1)).doubleValue();
        }
        return DigitUtils.formatDoubleInTwoDigit((Double)Math.min(totalHappinessAltitudePercentage, 100.0));
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getMoodCountAndPercentage(List<Long> studentIds, Date fromDate, Date toDate, boolean isSortData, boolean isHappinessAltitude, String language) {
        List moodUpdateList = this.moodDataService.getMoodUpdateByStudentIds(studentIds, fromDate, toDate);
        LinkedList moodOccurances = this.moodDataService.getMoodAnalysisByMoodUpdate(moodUpdateList, isSortData, isHappinessAltitude);
        Double totalCount = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            totalCount = totalCount + ((MoodOccurance)moodOccurances.get(i)).getCount();
            System.out.println(((MoodOccurance)moodOccurances.get(i)).getMood() + " - " + ((MoodOccurance)moodOccurances.get(i)).getCount());
        }
        System.out.println("-------------------------------------------------------------------");
        System.out.println("Total occournce " + totalCount);
        String forwordSlash = "/";
        System.out.println("------------------------Percentage = (Value " + forwordSlash + " Total Value) \ufffd 100-------------------------------------------");
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        double percentageTotal = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            LinkedList<Double> list = new LinkedList<Double>();
            String mood = ((MoodOccurance)moodOccurances.get(i)).getMood();
            Double count = (double)((MoodOccurance)moodOccurances.get(i)).getCount();
            Double percentage = DigitUtils.getPercentage((Double)count, (Double)totalCount);
            percentageTotal += percentage.doubleValue();
            System.out.println(mood + "\t=\t( Value\t" + count + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentage);
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)count));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)percentage));
            graphData_en.put(((MoodOccurance)moodOccurances.get(i)).getMood(), list);
            if (!Language.isSpanish((String)language)) continue;
            graphData_es.put(((MoodOccurance)moodOccurances.get(i)).getMood_es(), list);
        }
        System.out.println("-----------------------------------------------------------------------------------------------------------------------------");
        System.out.println("\t\t( Value\t" + totalCount + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentageTotal);
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish((String)language)) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Double>> getMoodCountAndPercentageByMoodUpdateAfter(List<Long> studentIds, Date fromDate, Date toDate, boolean isSortData, boolean isHappinessAltitude) {
        List activities = this.activityCriteriaRepository.getMoodInsightPostByStudentIds(studentIds, fromDate, toDate);
        LinkedList moodOccurances = this.moodDataService.getMoodAnalysisByMoodUpdateAfter(activities, isSortData, isHappinessAltitude);
        Double totalCount = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            totalCount = totalCount + ((MoodOccurance)moodOccurances.get(i)).getCount();
            System.out.println(((MoodOccurance)moodOccurances.get(i)).getMood() + " - " + ((MoodOccurance)moodOccurances.get(i)).getCount());
        }
        System.out.println("-------------------------------------------------------------------");
        System.out.println("Total occournce " + totalCount);
        String forwordSlash = "/";
        System.out.println("------------------------Percentage = (Value " + forwordSlash + " Total Value) \ufffd 100-------------------------------------------");
        LinkedHashMap<String, LinkedList<Double>> graphData = new LinkedHashMap<String, LinkedList<Double>>();
        double percentageTotal = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            LinkedList<Double> list = new LinkedList<Double>();
            String mood = ((MoodOccurance)moodOccurances.get(i)).getMood();
            Double count = (double)((MoodOccurance)moodOccurances.get(i)).getCount();
            Double percentage = DigitUtils.getPercentage((Double)count, (Double)totalCount);
            percentageTotal += percentage.doubleValue();
            System.out.println(mood + "\t=\t( Value\t" + count + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentage);
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)count));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)percentage));
            graphData.put(((MoodOccurance)moodOccurances.get(i)).getMood(), list);
        }
        System.out.println("-----------------------------------------------------------------------------------------------------------------------------");
        System.out.println("\t\t( Value\t" + totalCount + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentageTotal);
        return graphData;
    }

    public Parent getParentById(long parent_id) {
        return this.parentRepository.findByParentId(parent_id);
    }

    public LinkedHashMap<String, Object> comprehensiveReport(Parent parent, ParentDataApiRequest request, String language) {
        if (AppUtils.isNullOrEmpty((List)request.getStudentIds())) {
            List studentIds = parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toList());
            request.setStudentIds(studentIds);
        }
        return this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(request.getStudentIds(), request.getFromDate(), request.getToDate(), language);
    }

    public Object getSELAnalytics(Parent parent, ParentDataApiRequest request) {
        if (AppUtils.isNullOrEmpty((List)request.getStudentIds())) {
            List studentIds = parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toList());
            request.setStudentIds(studentIds);
        }
        return this.dataService.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), request.getStudentIds(), request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    public void setParentNewNotifications(List<Long> parent_ids, boolean new_notifications) {
        this.parentRepository.updateNewNotifications(parent_ids, new_notifications);
    }

    public Parent getByRegistrationCode(String registration_code) {
        return this.parentRepository.findByRegistrationCode(registration_code);
    }

    public List<Parent> getParentsCorporateId(long corporate_id) {
        return this.parentRepository.findByCorporateId(corporate_id).stream().filter(parent -> !parent.isDeleted()).collect(Collectors.toList());
    }

    public Parent setOperatingSystemAndBrowser(long parent_id, String operating_system, String browser) {
        Parent parent = this.getParentById(parent_id);
        if (parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("parent.is.not.found"));
        }
        parent.setOperating_system(operating_system);
        parent.setBrowser(browser);
        return (Parent)this.parentRepository.save((Object)parent);
    }

    public Parent editParent(long parent_id, String first_name, String last_name, String email) {
        Parent parent = this.getParentById(parent_id);
        if (parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("parent.is.not.found"));
        }
        Account account = this.accountService.changeEmail(parent.getAccount_id(), email);
        parent.setFirst_name(first_name);
        parent.setLast_name(last_name);
        return (Parent)this.parentRepository.save((Object)parent);
    }

    public Parent deleteParent(long parent_id, boolean deleted) {
        Parent parent = this.getParentById(parent_id);
        if (parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("parent.is.not.found"));
        }
        parent.setDeleted(deleted);
        return (Parent)this.parentRepository.save((Object)parent);
    }

    public Parent isValidParent(long parent_id) {
        Parent parent = this.getParentById(parent_id);
        if (parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("parent.is.not.found"));
        }
        return parent;
    }

    public String generateRegistrationCodeForParent() {
        String registration_code = null;
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "P" + KeyGenerator.generateUniqueAuthCode();
            Parent x = this.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                registration_code = possible_code;
                continue;
            }
            isUnique = false;
        }
        return registration_code;
    }

    public Parent getParentByCleverId(String clever_id) {
        return this.parentRepository.findByCleverId(clever_id);
    }

    public Student removeAccessForChild(Parent parent, Long student_id) {
        Student student = this.studentService.getStudentById(student_id.longValue());
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.child.is.not.found"));
        }
        if (student.getParent() == null || student.getParent().getParent_id() != parent.getParent_id()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.child.is.not.yours"));
        }
        boolean access = !student.isAccess_removed_by_parent();
        student.setAccess_removed_by_parent(access);
        return this.studentService.save(student);
    }
}

