/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.content.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.content.request.GetContentsByIdsRequest;
import com.infinite.focus.server.content.request.GetContentsRequest;
import com.infinite.focus.server.content.service.ContentService;
import com.infinite.focus.server.message.service.MessageService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/content"})
public class ContentController {
    @Autowired
    private ContentService contentService;
    @Autowired
    AuthService authService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/get/contents"})
    public ResponseEntity<Page<ContentDTO>> getContents(@RequestHeader(value="Authorization") String token, @RequestBody GetContentsRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.contentService.getContents(request.getContent_name(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/content/{content_id}"})
    public ResponseEntity<ContentDTO> getContentById(@PathVariable(value="content_id") Long content_id) {
        ContentDTO content = this.contentService.getById(content_id.longValue());
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.content.not.found"));
        }
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @PostMapping(value={"/create/content"})
    @ResponseBody
    public ResponseEntity<ContentDTO> createContent(@RequestHeader(value="Authorization") String token, @RequestBody ContentDTO request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.contentService.create(request.getContent_name(), request.getContent_name_es(), request.getStatus()), HttpStatus.OK);
    }

    @PostMapping(value={"/update/content"})
    @ResponseBody
    public ResponseEntity<ContentDTO> updateContent(@RequestHeader(value="Authorization") String token, @RequestBody ContentDTO request) {
        this.authService.isAuthenticated(token);
        ContentDTO content = this.contentService.getById(request.getContent_id());
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.content.not.found"));
        }
        return new ResponseEntity((Object)this.contentService.update(request.getContent_id(), request.getContent_name(), request.getContent_name_es(), request.getStatus()), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/content/{content_id}"})
    public ResponseEntity<Message> deleteContent(@RequestHeader(value="Authorization") String token, @PathVariable(value="content_id") Long content_id) {
        this.authService.isAuthenticated(token);
        ContentDTO content = this.contentService.getById(content_id.longValue());
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.content.not.found"));
        }
        this.contentService.deleteById(content_id.longValue());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.content.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get-contents-by-ids"})
    public ResponseEntity<List<ContentDTO>> getContentsByIds(@RequestBody GetContentsByIdsRequest request) {
        return new ResponseEntity((Object)this.contentService.getContentsByIds(request.getIds()), HttpStatus.OK);
    }
}

