/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.BadWordInJournalNotification;
import com.infinite.focus.server.notification.request.CorporateNotification;
import com.infinite.focus.server.notification.request.MoodUpdateNotification;
import com.infinite.focus.server.notification.request.ReviewWOWPostNotification;
import com.infinite.focus.server.notification.request.SOSAlertNotification;
import com.infinite.focus.server.notification.service.NotificationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/notification"})
public class NotificationController {
    private final NotificationService notificationService;
    private final MessageService messageService;

    public NotificationController(NotificationService notificationService, MessageService messageService) {
        this.notificationService = notificationService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/sos-alert-notification"})
    ResponseEntity<Object> sosAlertNotification(@RequestBody SOSAlertNotification request) {
        this.notificationService.sosAlertNotification(request);
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/mood-update"})
    ResponseEntity<Object> moodUpdate(@RequestBody MoodUpdateNotification request) {
        this.notificationService.moodUpdate(request);
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/review-wow-post"})
    ResponseEntity<Object> reviewWOWPost(@RequestBody ReviewWOWPostNotification request) {
        this.notificationService.reviewWOWPost(request);
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/bad-word-in-journal"})
    ResponseEntity<Object> badWordInJournal(@RequestBody BadWordInJournalNotification request) {
        this.notificationService.badWordInJournal(request);
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/corporate-notification"})
    ResponseEntity<Object> corporateNotification(@RequestBody CorporateNotification request) {
        this.notificationService.corporateNotification(request);
        Message message = new Message(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

