/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostimage.controller;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.request.GetWallPostImagesRequest;
import com.infinite.focus.server.wallpostimage.dto.WallPostImageDTO;
import com.infinite.focus.server.wallpostimage.entity.WallPostImage;
import com.infinite.focus.server.wallpostimage.request.GetWallPostImageByIdRequest;
import com.infinite.focus.server.wallpostimage.service.WallPostImageService;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/wall-post-image"})
public class WallPostImageController {
    @Autowired
    private AuthService authService;
    @Autowired
    private WallPostImageService wallPostImageService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConfigurationRepository configurationRepository;

    @PostMapping(value={"/create"})
    @ResponseBody
    public ResponseEntity<WallPostImageDTO> create(@RequestHeader(value="Authorization") String token, @RequestBody WallPostImage request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.wallPostImageService.create(request), HttpStatus.OK);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public ResponseEntity<WallPostImageDTO> update(@RequestHeader(value="Authorization") String token, @RequestBody WallPostImage request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.wallPostImageService.update(request), HttpStatus.OK);
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public ResponseEntity<Message> delete(@RequestHeader(value="Authorization") String token, @RequestBody WallPostImage request) {
        this.authService.isAdmin(token);
        this.wallPostImageService.delete(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.wall.post.image.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get-wall-post-images"})
    public ResponseEntity<Page<WallPostImageDTO>> getWallPostImages(@RequestHeader(value="Authorization") String token, @RequestBody GetWallPostImagesRequest request) {
        this.authService.isAuthenticated(token);
        int image_width = 0;
        image_width = request.getImage_width() != null && request.getImage_width() > 0 ? request.getImage_width().intValue() : this.configurationRepository.getConfiguration().getWow_image_width();
        Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
        Page pagedResult = this.wallPostImageService.getWallPostImages(request.getTitle(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy());
        int finalImage_width = image_width;
        PageImpl wallPostImages = new PageImpl(pagedResult.stream().peek(wallPostImage -> {
            wallPostImage.setUrl(AppUtils.getResizedUrl((Cloudinary)cloudinary, (int)finalImage_width, (String)wallPostImage.getUrl()));
            wallPostImage.setUrl_es(AppUtils.getResizedUrl((Cloudinary)cloudinary, (int)finalImage_width, (String)wallPostImage.getUrl_es()));
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return new ResponseEntity((Object)wallPostImages, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    public ResponseEntity<WallPostImageDTO> getById(@RequestBody GetWallPostImageByIdRequest request) {
        return new ResponseEntity((Object)this.wallPostImageService.getById(request.getId()), HttpStatus.OK);
    }
}

