/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dataset.repository;

import com.infinite.focus.server.dataset.dto.DataSetDTO;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.dataset.repository.DataSetCoreRepository;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DataSetCoreRepositoryImpl
implements DataSetCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public DataSetCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static DataSetDTO mapRow(ResultSet rs, int i) throws SQLException {
        return DataSetDTO.builder().data_set_id(rs.getLong("data_set_id")).assessment_category(AssessmentCategory.valueOf((String)rs.getString("assessment_category"))).assessment_category_name(rs.getString("assessment_category_name")).assessment_category_name_es(rs.getString("assessment_category_name_es")).assessment_child_category(AppUtils.isNullOrEmpty((String)rs.getString("assessment_child_category")) ? null : AssessmentChildCategory.valueOf((String)rs.getString("assessment_child_category"))).assessment_child_category_name(rs.getString("assessment_child_category_name")).assessment_child_category_name_es(rs.getString("assessment_child_category_name_es")).title(rs.getString("title")).title_es(rs.getString("title_es")).sub_title(rs.getString("sub_title")).sub_title_es(rs.getString("sub_title_es")).text_to_display(rs.getString("text_to_display")).text_to_display_es(rs.getString("text_to_display_es")).color(rs.getString("color")).image(rs.getString("image")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).score(rs.getDouble("score")).resource_library_category_id(rs.getLong("resource_library_category_id")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public DataSetDTO findById(long data_set_id) {
        String SQL = "SELECT * FROM data_set WHERE data_set_id = ? ";
        try {
            return (DataSetDTO)this.jdbcTemplate.queryForObject(SQL, DataSetCoreRepositoryImpl::mapRow, new Object[]{data_set_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DataSetDTO> findByIds(List<Long> data_set_ids) {
        if (AppUtils.isNullOrEmpty(data_set_ids)) {
            return new ArrayList<DataSetDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(data_set_ids.size(), "?"));
        String SQL = "SELECT * FROM data_set p WHERE p.data_set_id IN(%s) ";
        try {
            return this.jdbcTemplate.query(String.format(SQL, inSql), data_set_ids.toArray(), DataSetCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<DataSetDTO>();
        }
    }
}

