/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.account.model.AccountType;
import com.infinite.focus.server.admin.entity.Admin;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.logging.dto.LoggingDTO;
import com.infinite.focus.server.logging.repository.LoggingRepository;
import com.infinite.focus.server.logging.service.LoggingService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LoggingServiceImpl
implements LoggingService {
    Logger logger = LoggerFactory.getLogger((String)"LoggingServiceImpl");
    private final AuthService authService;
    private final ObjectMapper objectMapper;
    private final LoggingRepository loggingRepository;

    public LoggingServiceImpl(AuthService authService, ObjectMapper objectMapper, LoggingRepository loggingRepository) {
        this.authService = authService;
        this.objectMapper = objectMapper;
        this.loggingRepository = loggingRepository;
    }

    @Async
    public void saveRequest(String authorization, String url, String method, Map<String, String> headers, Map<String, String> parameters, Object requestBody) {
        System.out.println("LoggingService saveRequest: " + Thread.currentThread().getName());
        LoggingDTO.LoggingDTOBuilder builder = LoggingDTO.builder();
        builder.logging_id(0L);
        builder.user_id(0L);
        builder.user_type(this.getUserType(authorization, builder));
        builder.is_request(true);
        builder.url(url);
        builder.method(method);
        builder.headers("" + headers);
        builder.params("" + parameters);
        try {
            String json = this.objectMapper.writeValueAsString(requestBody);
            builder.req_resp(json);
        }
        catch (Exception e) {
            builder.req_resp(e.toString());
        }
        builder.created_at(new Date());
        LoggingDTO loggingDTO = builder.build();
        this.loggingRepository.create(loggingDTO.getUser_type(), loggingDTO.getUser_id(), loggingDTO.is_request(), loggingDTO.getUrl(), loggingDTO.getMethod(), loggingDTO.getHeaders(), loggingDTO.getParams(), loggingDTO.getReq_resp());
    }

    @Async
    public void saveResponse(String authorization, String url, String method, Map<String, String> headers, Map<String, String> parameters, Object responseBody) {
        System.out.println("LoggingService saveResponse: " + Thread.currentThread().getName());
        LoggingDTO.LoggingDTOBuilder builder = LoggingDTO.builder();
        builder.logging_id(0L);
        builder.user_id(0L);
        builder.user_type(this.getUserType(authorization, builder));
        builder.is_request(false);
        builder.url(url);
        builder.method(method);
        builder.headers("" + headers);
        builder.params("" + parameters);
        try {
            String json = this.objectMapper.writeValueAsString(responseBody);
            builder.req_resp(json);
        }
        catch (Exception e) {
            builder.req_resp(e.toString());
        }
        builder.created_at(new Date());
        LoggingDTO loggingDTO = builder.build();
        this.loggingRepository.create(loggingDTO.getUser_type(), loggingDTO.getUser_id(), loggingDTO.is_request(), loggingDTO.getUrl(), loggingDTO.getMethod(), loggingDTO.getHeaders(), loggingDTO.getParams(), loggingDTO.getReq_resp());
    }

    public String getUserType(String token, LoggingDTO.LoggingDTOBuilder builder) {
        if (!AppUtils.isNullOrEmpty((String)token)) {
            Admin admin = this.authService.getAdmin(token);
            if (admin != null) {
                builder.user_id(admin.getAdmin_id());
                return AccountType.ADMIN.name();
            }
            Instructor instructor = this.authService.getInstructorByToken(token);
            if (instructor != null) {
                builder.user_id(instructor.getInstructor_id());
                return AccountType.INSTRUCTOR.name();
            }
            Student student = this.authService.getStudentByToken(token);
            if (student != null) {
                builder.user_id(student.getStudent_id());
                return AccountType.STUDENT.name();
            }
            List schoolByToken = this.authService.getSchoolByToken(token);
            if (!AppUtils.isNullOrEmpty((List)schoolByToken)) {
                builder.user_id(((School)schoolByToken.get(0)).getAccount_id());
                return AccountType.SCHOOL.name();
            }
            District districtByToken = this.authService.getDistrictByToken(token);
            if (districtByToken != null) {
                builder.user_id(districtByToken.getDistrict_id());
                return AccountType.DISTRICT.name();
            }
            Parent parentByToken = this.authService.getParentByToken(token);
            if (parentByToken != null) {
                builder.user_id(parentByToken.getParent_id());
                return AccountType.PARENT.name();
            }
            Corporate corporateByToken = this.authService.getCorporateByToken(token);
            if (corporateByToken != null) {
                return AccountType.CORPORATE.name();
            }
        }
        return null;
    }
}

