/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.request.UpdateAccessCodeByAccountIdAndStatusRequest;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.request.GetAccountByIdRequest;
import com.infinite.focus.server.account.request.GetEmailByAccountIdRequest;
import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.activity.request.GetMoodInsightsPostByStudentIdsRequest;
import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByIdRequest;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByStudentIdRequest;
import com.infinite.focus.server.askforhelp.request.SetSOSRequestIdRequest;
import com.infinite.focus.server.assessment.dto.AssessmentDTO;
import com.infinite.focus.server.assessment.request.GetByStudentIdAndBetweenFromDateAndToDateRequest;
import com.infinite.focus.server.assessmentcategory.request.CreateAssessmentCategoryRequest;
import com.infinite.focus.server.assessmentpost.request.CreateAssessmentPostRequest;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.avatar.request.GetByAvatarIdRequest;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.request.GetCategoriesByIdsRequest;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.content.request.GetContentsByIdsRequest;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.request.SetNewNotificationsForCorporateRequest;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.dataset.request.GetPVStatesByDataSetIdsRequest;
import com.infinite.focus.server.email.request.SendEmailRequest;
import com.infinite.focus.server.email.request.SendForgotPasswordEmailRequest;
import com.infinite.focus.server.email.request.SendSOSAlertEmailRequest;
import com.infinite.focus.server.favorite.request.GetPostIdsByStudentIdRequest;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.feelslike.dto.FeelsLikeDTO;
import com.infinite.focus.server.feelslike.request.GetFeelsLikesByFeelsLikeIds;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.request.GetInstructorByIdRequest;
import com.infinite.focus.server.instructor.request.GetInstructorEmailRequest;
import com.infinite.focus.server.instructor.request.SetNewNotificationsForInstructorRequest;
import com.infinite.focus.server.instructor.response.GetInstructorEmailResponse;
import com.infinite.focus.server.lookslike.dto.LooksLikeDTO;
import com.infinite.focus.server.lookslike.request.GetLooksLikesByLooksLikeIds;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.request.GetMoodsByIdsRequest;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodandcolor.dto.MoodAndColorDTO;
import com.infinite.focus.server.moodandcolor.request.GetMoodAndColorByMoodIdRequest;
import com.infinite.focus.server.moodandstandard.dto.MoodAndStandardDTO;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.moodupdate.request.GetLastThreeMoodsByStudentIdRequest;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByIdRequest;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByStudentIdsRequest;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.notification.request.BadWordInJournalNotification;
import com.infinite.focus.server.notification.request.CorporateNotification;
import com.infinite.focus.server.notification.request.MoodUpdateNotification;
import com.infinite.focus.server.notification.request.ReviewWOWPostNotification;
import com.infinite.focus.server.notification.request.SOSAlertNotification;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.request.GetByOrganizationTypeAndAccountIdRequest;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.request.CreateParentRequest;
import com.infinite.focus.server.parent.request.SetNewNotificationsForParentRequest;
import com.infinite.focus.server.parent.request.UpdateParentRequest;
import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcategory.request.CreatePostCategoryRequest;
import com.infinite.focus.server.postcategory.request.GetPostCategoryListByPostIdsRequest;
import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.postcontent.request.CreatePostContentRequest;
import com.infinite.focus.server.postcontent.request.GetPostContentListByPostIdsRequest;
import com.infinite.focus.server.postmood.dto.PostMoodDTO;
import com.infinite.focus.server.postmood.request.CreatePostMoodRequest;
import com.infinite.focus.server.postmood.request.GetPostMoodListByPostIdsRequest;
import com.infinite.focus.server.poststandard.dto.PostStandardDTO;
import com.infinite.focus.server.poststandard.request.CreatePostStandardRequest;
import com.infinite.focus.server.poststandard.request.GetPostStandardListByPostIdsRequest;
import com.infinite.focus.server.pvstate.dto.PVStateDTO;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.pvstate.request.GetAvgPVStateByPVStatesRequest;
import com.infinite.focus.server.relationshipskills.dto.RelationshipSkillsUpdateDTO;
import com.infinite.focus.server.relationshipskills.request.GetByRelationshipSkillsUpdateIdRequest;
import com.infinite.focus.server.relationshipskills.request.GetByStudentIdsAndFromDateAndToDateAndAssessmentChildCategoryRequest;
import com.infinite.focus.server.responsibledecisionmaking.dto.ResponsibleDecisionMakingUpdateDTO;
import com.infinite.focus.server.responsibledecisionmaking.model.AssessmentOccurrenceByStandards;
import com.infinite.focus.server.responsibledecisionmaking.request.GetByResponsibleDecisionMakingUpdateIdRequest;
import com.infinite.focus.server.responsibledecisionmaking.request.GetByStudentIdsAndFromDateAndToDateRequest;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.request.GetSchoolByIdRequest;
import com.infinite.focus.server.school.request.GetSchoolByStudentIdRequest;
import com.infinite.focus.server.school.request.GetSchoolEmailRequest;
import com.infinite.focus.server.school.response.GetSchoolEmailResponse;
import com.infinite.focus.server.selfmanagement.dto.SelfManagementUpdateDTO;
import com.infinite.focus.server.selfmanagement.request.GetBySelfManagementUpdateIdRequest;
import com.infinite.focus.server.socialawareness.dto.SocialAwarenessUpdateDTO;
import com.infinite.focus.server.socialawareness.request.GetBySocialAwarenessUpdateIdRequest;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosoption.request.GetOptionsByQuestionIdRequest;
import com.infinite.focus.server.sosoption.request.GetSOSOptionsByIdsRequest;
import com.infinite.focus.server.sosquestion.dto.SOSQuestionDTO;
import com.infinite.focus.server.sosquestion.request.GetActiveQuestionsCount;
import com.infinite.focus.server.sosquestion.request.GetSOSQuestionsByIdsRequest;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.request.GetSOSRequestByAskForHelpId;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.sostime.request.GetSOSTimeForSchoolRequest;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import com.infinite.focus.server.standard.request.GetStandardsByIdsRequest;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.GetByAccountIdRequest;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.student.request.GetByStudentIdsRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorIdAndStudentNameRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorRequest;
import com.infinite.focus.server.student.request.GetStudentIdsByDemographicsRequest;
import com.infinite.focus.server.student.request.GetStudentRequest;
import com.infinite.focus.server.student.request.GetStudentsByIdsRequest;
import com.infinite.focus.server.student.request.GetStudentsBySchoolIdRequest;
import com.infinite.focus.server.student.request.SetNewNotificationsRequest;
import com.infinite.focus.server.student.wrapper.StudentIdAndStandardIdWrapper;
import com.infinite.focus.server.studentgroup.request.GetStudentsByGroupIdsRequest;
import com.infinite.focus.server.studentpushnotification.dto.StudentPushNotificationDTO;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedNotificationRequest;
import com.infinite.focus.server.studentpushnotification.request.StreakReceivedNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotification;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotifications;
import com.infinite.focus.server.studentpushnotification.request.WOWReactionNotification;
import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submood.request.GetSubMoodsByMoodIdAndStandardIdRequest;
import com.infinite.focus.server.submoodandfeelslike.dto.SubMoodAndFeelsLikeDTO;
import com.infinite.focus.server.submoodandfeelslike.request.GetSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId;
import com.infinite.focus.server.submoodandlookslike.dto.SubMoodAndLooksLikeDTO;
import com.infinite.focus.server.submoodandlookslike.request.GetSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.submoodandstandard.request.GetByMoodIdStandardIdAndSubMoodIdRequest;
import com.infinite.focus.server.template.request.GetForgotPasswordTemplateRequest;
import com.infinite.focus.server.template.request.GetSOSEmailAskForHelpTemplateRequest;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.vimeo.model.VimeoVideoDetailsoEmbed;
import com.infinite.focus.server.vimeo.request.GetVimeoVideoDetailsByVideoUrlRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class RestComponent {
    private final ConfigurationRepository configurationRepository;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public RestComponent(ConfigurationRepository configurationRepository, ObjectMapper objectMapper, RestTemplate restTemplate) {
        this.configurationRepository = configurationRepository;
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    private void addAuthToken(HttpHeaders headers) {
        try {
            HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            String headerToken = req.getHeader("Authorization");
            headers.add("Authorization", headerToken);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public List<SubMoodAndStandardDTO> getSubMoodAndStandardsByMoodIdAndStandardId(GetSubMoodsByMoodIdAndStandardIdRequest request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood-and-standard/get-sub-mood-and-standards-by-mood-id-and-standard-id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List subMoodAndStandardDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodAndStandardDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SubMoodAndStandardDTO>();
        }
    }

    public List<SubMoodAndStandardDTO> getAllSubMoodAndStandards() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood-and-standard/get-all-sub-mood-and-standards";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List subMoodAndStandardDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodAndStandardDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SubMoodAndStandardDTO>();
        }
    }

    public List<SubMoodDTO> getAllSubMoods() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood/get-all-sub-moods";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List subMoodDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SubMoodDTO>();
        }
    }

    public List<SubMoodAndLooksLikeDTO> getSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId(GetSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood-and-looks-like/get-sub-mood-and-looks-likes-by-mood-id-and-standard-id-and-sub-mood-id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List subMoodAndLooksLikeDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodAndLooksLikeDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SubMoodAndLooksLikeDTO>();
        }
    }

    public List<LooksLikeDTO> getLooksLikesByLooksLikeIds(GetLooksLikesByLooksLikeIds request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/looks-like/get-looks-likes-by-looks-like-ids";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List looksLikeDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return looksLikeDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<LooksLikeDTO>();
        }
    }

    public List<SubMoodAndFeelsLikeDTO> getSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId(GetSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood-and-feels-like/get-sub-mood-and-feels-likes-by-mood-id-and-standard-id-and-sub-mood-id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List subMoodAndFeelsLikeDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodAndFeelsLikeDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SubMoodAndFeelsLikeDTO>();
        }
    }

    public List<FeelsLikeDTO> getFeelsLikesByFeelsLikeIds(GetFeelsLikesByFeelsLikeIds request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/feels-like/get-feels-likes-by-feels-like-ids";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List feelsLikeDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return feelsLikeDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<FeelsLikeDTO>();
        }
    }

    public MoodAndColorDTO getMoodAndColorByMoodId(GetMoodAndColorByMoodIdRequest request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-and-color/get-mood-and-color-by-mood-id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            MoodAndColorDTO moodAndColorDTO = (MoodAndColorDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodAndColorDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SOSOptionDTO> createSOSOptions(List<SOSOptionDTO> request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-option/create/options";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString(request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List sosOptionDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosOptionDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SOSOptionDTO>();
        }
    }

    public List<SOSOptionDTO> getSOSOptionsBySOSQuestionId(GetOptionsByQuestionIdRequest request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-option/get-options/by/question/id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List sosOptionDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosOptionDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SOSOptionDTO>();
        }
    }

    public List<SOSAnswerDTO> createSOSAnswers(List<SOSAnswerDTO> request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-answer/create/answers";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString(request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List sosAnswerDTOList = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosAnswerDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SOSAnswerDTO>();
        }
    }

    public Student getStudentById(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-by-id";
        GetStudentRequest request = new GetStudentRequest();
        request.setStudent_id(Long.valueOf(student_id));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Student student = (Student)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return student;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setNewNotificationsForStudent(List<Long> student_ids, boolean new_notifications) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/set-new-notifications";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SetNewNotificationsRequest.builder().student_ids(student_ids).new_notifications(new_notifications).build())), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, Void.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendStudentPushNotification(long student_id, NotificationType notification_type, String format_text, String title, String message, String title_es, String message_es) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/send";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)StudentPushNotificationDTO.builder().student_id(Long.valueOf(student_id)).notification_type(notification_type).format_text(format_text).title(title).message(message).title_es(title_es).message_es(message_es).build())), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, Void.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<MoodDTO> getAskForHelpMoods() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood/get-ask-for-help-moods";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            List moodDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }

    public List<MoodUpdateDTO> getLastThreeMoodsByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-update/get-last-three-moods-by-student-id";
        GetLastThreeMoodsByStudentIdRequest request = new GetLastThreeMoodsByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List moodUpdateDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodUpdateDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodUpdateDTO>();
        }
    }

    public SOSRequestDTO getSOSRequestByAskForHelpId(long ask_for_help_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-request/get-sos-request-by-ask-for-help-id";
        GetSOSRequestByAskForHelpId request = new GetSOSRequestByAskForHelpId();
        request.setAsk_for_help_id(ask_for_help_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            SOSRequestDTO sosRequestDTO = (SOSRequestDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosRequestDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AskForHelpDTO getPendingAskForHelpByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/ask-for-help/get-pending-ask-for-help-by-student-id";
        GetAskForHelpByStudentIdRequest request = new GetAskForHelpByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AskForHelpDTO askForHelpDTO = (AskForHelpDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return askForHelpDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AskForHelpDTO getAskForHelpByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/ask-for-help/get-ask-for-help-by-student-id";
        GetAskForHelpByStudentIdRequest request = new GetAskForHelpByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AskForHelpDTO askForHelpDTO = (AskForHelpDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return askForHelpDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSOSEmailAskForHelpTemplate(String student_name, String grade, String language) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/template/get-sos-email-ask-for-help-template";
        GetSOSEmailAskForHelpTemplateRequest request = new GetSOSEmailAskForHelpTemplateRequest();
        request.setStudent_name(student_name);
        request.setGrade(grade);
        request.setLanguage(language);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            return (String)responseEntity.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetInstructorEmailResponse getInstructorEmailByInstructorId(long instructor_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/instructor/get/instructor/email";
        GetInstructorEmailRequest request = new GetInstructorEmailRequest();
        request.setInstructor_id(instructor_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            GetInstructorEmailResponse getInstructorEmailResponse = (GetInstructorEmailResponse)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return getInstructorEmailResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Instructor getInstructorById(long id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/instructor/get-instructor-by-id";
        GetInstructorByIdRequest request = new GetInstructorByIdRequest();
        request.setId(id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            Instructor instructor = (Instructor)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return instructor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setNewNotificationsForInstructor(Long instructor_id, boolean new_notifications) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/instructor/set-new-notifications";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SetNewNotificationsForInstructorRequest.builder().instructor_id(instructor_id.longValue()).new_notifications(new_notifications).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, Void.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNewNotificationsForParent(List<Long> parent_ids, boolean new_notifications) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/parent/set-new-notifications";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SetNewNotificationsForParentRequest.builder().parent_ids(parent_ids).new_notifications(new_notifications).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, Void.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNewNotificationsForCorporate(long corporate_id, boolean new_notifications) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/corporate/set-new-notifications";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SetNewNotificationsForCorporateRequest.builder().corporate_id(corporate_id).new_notifications(new_notifications).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, Void.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> getStudentIdsByInstructorId(long instructor_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-ids-by-instructor-id";
        GetStudentByInstructorRequest request = new GetStudentByInstructorRequest();
        request.setInstructor_id(Long.valueOf(instructor_id));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List student_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return student_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public GetSchoolEmailResponse getSchoolEmailBySchoolId(long school_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/school/get/school/email";
        GetSchoolEmailRequest request = new GetSchoolEmailRequest();
        request.setSchool_id(school_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            GetSchoolEmailResponse getSchoolEmailResponse = (GetSchoolEmailResponse)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return getSchoolEmailResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetEmailByAccountIdResponse getEmailByAccountId(long account_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/account/get-email-by-account-id";
        GetEmailByAccountIdRequest request = new GetEmailByAccountIdRequest();
        request.setAccount_id(account_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            GetEmailByAccountIdResponse getEmailByAccountIdResponse = (GetEmailByAccountIdResponse)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return getEmailByAccountIdResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Async
    public void sendSOSEmailToOrganization(String email, String student_name, String grade, String language) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/email/send-sos-alert-email";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SendSOSAlertEmailRequest.builder().email(email).student_name(student_name).grade(grade).language(language).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Async
    public void sosAlertNotification(SOSAlertNotification sosAlertNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/notification/sos-alert-notification";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)sosAlertNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getActiveSOSQuestionCount() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-question/get-active-questions-count";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            GetActiveQuestionsCount getActiveQuestionsCount = (GetActiveQuestionsCount)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return getActiveQuestionsCount.getActive_questions_count();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public School getSchoolById(long school_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/school/get-school-by-id";
        GetSchoolByIdRequest request = new GetSchoolByIdRequest();
        request.setSchool_id(school_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            School school = (School)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return school;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SOSTimeDTO getSOSTimeBySchoolId(long school_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-time/get/for/school";
        GetSOSTimeForSchoolRequest request = new GetSOSTimeForSchoolRequest();
        request.setSchool_id(Long.valueOf(school_id));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            SOSTimeDTO sosTimeDTO = (SOSTimeDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosTimeDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Account getAccountById(long account_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/account/get-by-id";
        GetAccountByIdRequest request = new GetAccountByIdRequest();
        request.setAccount_id(account_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Account account = (Account)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return account;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StudentDTO> getStudentsByInstructorId(long instructor_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-students-by-instructor-id";
        GetStudentByInstructorRequest request = new GetStudentByInstructorRequest();
        request.setInstructor_id(Long.valueOf(instructor_id));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List students = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return students;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentDTO>();
        }
    }

    public Set<Long> getStudentIdsByClassIds(List<Long> class_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-group/get-student-ids-by-group-ids";
        GetStudentsByGroupIdsRequest request = new GetStudentsByGroupIdsRequest();
        request.setGroup_ids(class_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List student_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(student_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public List<StudentDTO> getStudentsByInstructorIdAndStudentName(long instructor_id, String student_name) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-students-by-instructor-id-and-student-name";
        GetStudentByInstructorIdAndStudentNameRequest request = new GetStudentByInstructorIdAndStudentNameRequest();
        request.setInstructor_id(Long.valueOf(instructor_id));
        request.setStudent_name(student_name);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List students = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return students;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentDTO>();
        }
    }

    public List<StandardDTO> getAllStandards() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-all-standards";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List standards = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return standards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StandardDTO>();
        }
    }

    public List<SOSQuestionDTO> getSOSQuestionsByIds(Set<Long> sos_question_ids, Integer image_width) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-question/get-sos-questions-by-ids";
        GetSOSQuestionsByIdsRequest request = new GetSOSQuestionsByIdsRequest();
        request.setSos_question_ids(sos_question_ids);
        request.setImage_width(image_width);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List sosQuestionDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosQuestionDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SOSQuestionDTO>();
        }
    }

    public List<SOSOptionDTO> getSOSOptionsByIds(Set<Long> sos_option_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sos-option/get-sos-options-by-ids";
        GetSOSOptionsByIdsRequest request = new GetSOSOptionsByIdsRequest();
        request.setSos_option_ids(sos_option_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List sosOptionDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return sosOptionDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SOSOptionDTO>();
        }
    }

    public List<PostCategoryDTO> setPostAndCategories(long post_id, Set<Long> category_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-category/create";
        CreatePostCategoryRequest request = new CreatePostCategoryRequest();
        request.setPost_id(post_id);
        request.setCategory_ids(category_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List postCategoryDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postCategoryDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PostCategoryDTO>();
        }
    }

    public List<PostContentDTO> setPostAndContents(long post_id, Set<Long> content_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-content/create";
        CreatePostContentRequest request = new CreatePostContentRequest();
        request.setPost_id(post_id);
        request.setContent_ids(content_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List postContentDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postContentDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PostContentDTO>();
        }
    }

    public List<PostMoodDTO> setPostAndMoods(long post_id, Set<Long> mood_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-mood/create";
        CreatePostMoodRequest request = new CreatePostMoodRequest();
        request.setPost_id(post_id);
        request.setMood_ids(mood_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List postMoodDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postMoodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PostMoodDTO>();
        }
    }

    public List<PostStandardDTO> setPostAndStandards(long post_id, Set<Long> standard_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-standard/create";
        CreatePostStandardRequest request = new CreatePostStandardRequest();
        request.setPost_id(post_id);
        request.setStandard_ids(standard_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List postAndStandardDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postAndStandardDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PostStandardDTO>();
        }
    }

    public Set<Long> getPostIdsByCategoryIds(Set<Long> category_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-category/get-post-ids-by-category-ids";
        CreatePostCategoryRequest request = new CreatePostCategoryRequest();
        request.setCategory_ids(category_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set post_ids = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return post_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getPostIdsByContentIds(Set<Long> content_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-content/get-post-ids-by-content-ids";
        CreatePostContentRequest request = new CreatePostContentRequest();
        request.setContent_ids(content_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set post_ids = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return post_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getPostIdsByMoodIds(Set<Long> mood_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-mood/get-post-ids-by-mood-ids";
        CreatePostMoodRequest request = new CreatePostMoodRequest();
        request.setMood_ids(mood_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set post_ids = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return post_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getPostIdsByStandardIds(Set<Long> standard_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-standard/get-post-ids-by-standard-ids";
        CreatePostStandardRequest request = new CreatePostStandardRequest();
        request.setStandard_ids(standard_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set post_ids = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return post_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getPostIdsByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/favorite/get-post-ids-by-student-id";
        GetPostIdsByStudentIdRequest request = new GetPostIdsByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set post_ids = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return post_ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<PostCategoryDTO> getPostCategoryListByPostIds(Set<Long> post_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-category/get-post-category-list-by-post-ids";
        GetPostCategoryListByPostIdsRequest request = new GetPostCategoryListByPostIdsRequest();
        request.setPost_ids(post_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set postCategoryDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postCategoryDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<PostCategoryDTO>();
        }
    }

    public Set<CategoryDTO> getCategoriesByIds(Set<Long> ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/category/get-categories-by-ids";
        GetCategoriesByIdsRequest request = new GetCategoriesByIdsRequest();
        request.setIds(ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set categoryDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return categoryDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<CategoryDTO>();
        }
    }

    public Set<PostContentDTO> getPostContentListByPostIds(Set<Long> post_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-content/get-post-content-list-by-post-ids";
        GetPostContentListByPostIdsRequest request = new GetPostContentListByPostIdsRequest();
        request.setPost_ids(post_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set postContentDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postContentDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<PostContentDTO>();
        }
    }

    public Set<ContentDTO> getContentsByIds(Set<Long> ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/content/get-contents-by-ids";
        GetContentsByIdsRequest request = new GetContentsByIdsRequest();
        request.setIds(ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set contentDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return contentDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<ContentDTO>();
        }
    }

    public Set<PostMoodDTO> getPostMoodListByPostIds(Set<Long> post_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-mood/get-post-mood-list-by-post-ids";
        GetPostMoodListByPostIdsRequest request = new GetPostMoodListByPostIdsRequest();
        request.setPost_ids(post_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set postMoodDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postMoodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<PostMoodDTO>();
        }
    }

    public List<MoodDTO> getAllMoods() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood/get-all-moods";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List moodDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }

    public List<EmotionCountAndAverage> getAllEmotionsAndSubEmotions() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood/get-all-emotions-and-sub-emotions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List emotionCountAndAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return emotionCountAndAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<EmotionCountAndAverage>();
        }
    }

    public EmotionsByStandards getAllEmotions() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood/get-all-emotions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            EmotionsByStandards emotionsByStandards = (EmotionsByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return emotionsByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<MoodDTO> getMoodsByIds(Set<Long> ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood/get-moods-by-ids";
        GetMoodsByIdsRequest request = new GetMoodsByIdsRequest();
        request.setIds(ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set moodDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<MoodDTO>();
        }
    }

    public Set<PostStandardDTO> getPostStandardListByPostIds(Set<Long> post_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/post-standard/get-post-standard-list-by-post-ids";
        GetPostStandardListByPostIdsRequest request = new GetPostStandardListByPostIdsRequest();
        request.setPost_ids(post_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set postStandardDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return postStandardDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<PostStandardDTO>();
        }
    }

    public Set<StandardDTO> getStandardsByIds(Set<Long> ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-standards-by-ids";
        GetStandardsByIdsRequest request = new GetStandardsByIdsRequest();
        request.setIds(ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Set standardDTOS = (Set)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return standardDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<StandardDTO>();
        }
    }

    public Set<Long> getStudentIdsBySchoolId(long school_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-ids-by-school-id";
        GetStudentsBySchoolIdRequest request = new GetStudentsBySchoolIdRequest();
        request.setSchool_id(school_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List student_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(student_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getStudentsBySchoolIdAndDemographics(long school_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-ids-by-school-id";
        GetStudentsBySchoolIdRequest request = new GetStudentsBySchoolIdRequest();
        request.setSchool_id(school_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List student_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(student_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> getStudentIdsBySchoolIdAndStudentDemographics(long school_id, String name, List<Integer> ages, List<String> genders, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-ids-by-student-demographics";
        GetStudentIdsByDemographicsRequest request = new GetStudentIdsByDemographicsRequest();
        request.setSchool_id(school_id);
        request.setName(name);
        request.setGenders(genders);
        request.setAges(ages);
        request.setEthnicity(ethnicity);
        request.setGradeIds(gradeIds);
        request.setClassIds(classIds);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List student_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(student_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public List<StudentCoreDTO> getStudentsByIds(List<Long> student_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-students-by-ids";
        GetStudentsByIdsRequest request = new GetStudentsByIdsRequest();
        request.setIds(student_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List studentCoreDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return studentCoreDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentCoreDTO>();
        }
    }

    public VimeoVideoDetailsoEmbed getVimeoVideoDetailsoEmbedByVideoUrl(String video_url) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/vimeo/get-vimeo-video-details-oEmbed-by-video-url";
        GetVimeoVideoDetailsByVideoUrlRequest request = new GetVimeoVideoDetailsByVideoUrlRequest();
        request.setVideo_url(video_url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed = (VimeoVideoDetailsoEmbed)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return vimeoVideoDetailsoEmbed;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AskForHelpDTO getAskForHelpById(long ask_for_help_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/ask-for-help/get-ask-for-help-by-id";
        GetAskForHelpByIdRequest request = new GetAskForHelpByIdRequest();
        request.setAsk_for_help_id(ask_for_help_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AskForHelpDTO askForHelpDTO = (AskForHelpDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return askForHelpDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Async
    public AskForHelpDTO setSOSRequestId(long ask_for_help_id, long sos_request_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/ask-for-help/set-sos-request-id";
        SetSOSRequestIdRequest request = new SetSOSRequestIdRequest();
        request.setAsk_for_help_id(ask_for_help_id);
        request.setSos_request_id(sos_request_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AskForHelpDTO askForHelpDTO = (AskForHelpDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return askForHelpDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LinkedHashMap<String, Object> getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate, String language) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/activity/get-mood-insights-post-by-student-ids";
        GetMoodInsightsPostByStudentIdsRequest request = new GetMoodInsightsPostByStudentIdsRequest();
        request.setStudent_ids(student_ids);
        request.setFromDate(fromDate);
        request.setToDate(toDate);
        request.setLanguage(language);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            LinkedHashMap object = (LinkedHashMap)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new LinkedHashMap<String, Object>();
        }
    }

    public Set<Long> getK_2StandardIds() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-k-2-standard-ids";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List standard_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(standard_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> get3_5StandardIds() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-3-5-standard-ids";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List standard_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(standard_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public Set<Long> get6_12StandardIds() {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-6-12-standard-ids";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List standard_ids = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return new HashSet<Long>(standard_ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<Long>();
        }
    }

    public void moodUpdate(MoodUpdateNotification request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/notification/mood-update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void corporateNotification(CorporateNotification request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/notification/corporate-notification";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parent getParentById(long parent_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/parent/get-parent-by-id";
        GetByIdRequest request = new GetByIdRequest();
        request.setId(parent_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            Parent parent = (Parent)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return parent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MoodUpdateAndStreak createMoodUpdate(MoodUpdate request) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-update/create";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            MoodUpdateAndStreak moodUpdateAndStreak = (MoodUpdateAndStreak)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodUpdateAndStreak;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<EmotionCountAndAverage> getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-update/get-self-awareness-by-student-ids";
        GetSelfAwarenessByStudentIdsRequest request = new GetSelfAwarenessByStudentIdsRequest();
        request.setStudent_ids(new HashSet<Long>(student_ids));
        request.setFromDate(fromDate);
        request.setToDate(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List emotionCountAndAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return emotionCountAndAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<EmotionCountAndAverage>();
        }
    }

    public EmotionsByStandards getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(List<Long> student_ids, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-update/get-self-awareness-by-student-ids-2";
        GetSelfAwarenessByStudentIdsRequest request = new GetSelfAwarenessByStudentIdsRequest();
        request.setStudent_ids(new HashSet<Long>(student_ids));
        request.setFromDate(fromDate);
        request.setToDate(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            EmotionsByStandards emotionsByStandards = (EmotionsByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return emotionsByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveAssessmentCategory(long assessment_id, Set<Long> category_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/assessment-category/create";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)CreateAssessmentCategoryRequest.builder().assessment_id(assessment_id).category_ids(category_ids).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAssessmentPost(long assessment_id, Set<Long> post_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/assessment-post/create";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)CreateAssessmentPostRequest.builder().assessment_id(assessment_id).post_ids(post_ids).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<MoodAndStandardDTO> getMoodAndStandards(long standard_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-and-standard/get-mood-and-standard-by-standard-id";
        GetByStandardIdRequest request = new GetByStandardIdRequest();
        request.setStandard_id(standard_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List moodAndStandardDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodAndStandardDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodAndStandardDTO>();
        }
    }

    public AssessmentOccurrenceByStandards getChoicesAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/responsible-decision-making-update/get-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AssessmentOccurrenceByStandards assessmentOccurrenceByStandards = (AssessmentOccurrenceByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return assessmentOccurrenceByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getChoicesAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/responsible-decision-making-update/get-occurrence-and-occurrence-average-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List occurrenceAndOccurrenceAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return occurrenceAndOccurrenceAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<OccurrenceAndOccurrenceAverage>();
        }
    }

    public AssessmentOccurrenceByStandards getMotivationAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/self-management-update/get-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AssessmentOccurrenceByStandards assessmentOccurrenceByStandards = (AssessmentOccurrenceByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return assessmentOccurrenceByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getMotivationAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/self-management-update/get-occurrence-and-occurrence-average-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List occurrenceAndOccurrenceAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return occurrenceAndOccurrenceAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<OccurrenceAndOccurrenceAverage>();
        }
    }

    public AssessmentOccurrenceByStandards getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/social-awareness-update/get-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AssessmentOccurrenceByStandards assessmentOccurrenceByStandards = (AssessmentOccurrenceByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return assessmentOccurrenceByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getFriendshipAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/social-awareness-update/get-occurrence-and-occurrence-average-by-student-ids-and-from-date-and-to-date";
        GetByStudentIdsAndFromDateAndToDateRequest request = new GetByStudentIdsAndFromDateAndToDateRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List occurrenceAndOccurrenceAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return occurrenceAndOccurrenceAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<OccurrenceAndOccurrenceAverage>();
        }
    }

    public AssessmentOccurrenceByStandards getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate, AssessmentChildCategory assessmentChildCategory) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/relationship-skills-update/get-by-student-ids-and-from-date-and-to-date-and-assessment-child-category";
        GetByStudentIdsAndFromDateAndToDateAndAssessmentChildCategoryRequest request = new GetByStudentIdsAndFromDateAndToDateAndAssessmentChildCategoryRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        request.setAssessmentChildCategory(assessmentChildCategory);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AssessmentOccurrenceByStandards assessmentOccurrenceByStandards = (AssessmentOccurrenceByStandards)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return assessmentOccurrenceByStandards;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getFriendshipAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate, AssessmentChildCategory assessmentChildCategory) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/relationship-skills-update/get-occurrence-and-occurrence-average-by-student-ids-and-from-date-and-to-date-and-assessment-child-category";
        GetByStudentIdsAndFromDateAndToDateAndAssessmentChildCategoryRequest request = new GetByStudentIdsAndFromDateAndToDateAndAssessmentChildCategoryRequest();
        request.setStudent_ids(new HashSet<Long>(studentIds));
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        request.setAssessmentChildCategory(assessmentChildCategory);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List occurrenceAndOccurrenceAverages = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return occurrenceAndOccurrenceAverages;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<OccurrenceAndOccurrenceAverage>();
        }
    }

    public MoodUpdateDTO getSelfAwarenessById(long self_awareness_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/mood-update/get-by-id";
        GetSelfAwarenessByIdRequest request = new GetSelfAwarenessByIdRequest();
        request.setSelf_awareness_id(self_awareness_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            MoodUpdateDTO moodUpdateDTO = (MoodUpdateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return moodUpdateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SubMoodAndStandardDTO getSubMoodAndStandardByMoodIdStandardIdAndSubMoodId(long mood_id, long standard_id, long sub_mood_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/sub-mood-and-standard/get-by-mood-id-and-standard-id-and-sub-mood-id";
        GetByMoodIdStandardIdAndSubMoodIdRequest request = new GetByMoodIdStandardIdAndSubMoodIdRequest();
        request.setMood_id(mood_id);
        request.setStandard_id(standard_id);
        request.setSub_mood_id(sub_mood_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            SubMoodAndStandardDTO subMoodAndStandardDTO = (SubMoodAndStandardDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return subMoodAndStandardDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResponsibleDecisionMakingUpdateDTO getResponsibleDecisionMakingById(long responsible_decision_making_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/responsible-decision-making-update/get-by-id";
        GetByResponsibleDecisionMakingUpdateIdRequest request = new GetByResponsibleDecisionMakingUpdateIdRequest();
        request.setResponsible_decision_making_update_id(responsible_decision_making_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            ResponsibleDecisionMakingUpdateDTO responsibleDecisionMakingUpdateDTO = (ResponsibleDecisionMakingUpdateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return responsibleDecisionMakingUpdateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SelfManagementUpdateDTO getSelfManagementById(long self_management_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/self-management-update/get-by-id";
        GetBySelfManagementUpdateIdRequest request = new GetBySelfManagementUpdateIdRequest();
        request.setSelf_management_update_id(self_management_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            SelfManagementUpdateDTO selfManagementUpdateDTO = (SelfManagementUpdateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return selfManagementUpdateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SocialAwarenessUpdateDTO getSocialAwarenessById(long social_awareness_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/social-awareness-update/get-by-id";
        GetBySocialAwarenessUpdateIdRequest request = new GetBySocialAwarenessUpdateIdRequest();
        request.setSocial_awareness_update_id(social_awareness_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            SocialAwarenessUpdateDTO socialAwarenessUpdateDTO = (SocialAwarenessUpdateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return socialAwarenessUpdateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public RelationshipSkillsUpdateDTO getRelationshipSkillsById(long relationship_skills_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/relationship-skills-update/get-by-id";
        GetByRelationshipSkillsUpdateIdRequest request = new GetByRelationshipSkillsUpdateIdRequest();
        request.setRelationship_skills_update_id(relationship_skills_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            RelationshipSkillsUpdateDTO relationshipSkillsUpdateDTO = (RelationshipSkillsUpdateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return relationshipSkillsUpdateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<PVState> getPVStatesByDataSetIds(List<Long> data_set_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/data-set/get-pv-states-by-ids";
        GetPVStatesByDataSetIdsRequest request = new GetPVStatesByDataSetIdsRequest();
        request.setData_set_ids(data_set_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List pvStates = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return pvStates;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PVState>();
        }
    }

    public PVStateDTO getAvgPVStateByPVStates(List<PVState> pv_states) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/pv-state/get-avg-pv-state-by-pv-states";
        GetAvgPVStateByPVStatesRequest request = new GetAvgPVStateByPVStatesRequest();
        request.setPv_states(pv_states);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            PVStateDTO pvStateDTO = (PVStateDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return pvStateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getForgotPasswordTemplate(String reset_password_link, String language) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/template/get-forgot-password-template";
        GetForgotPasswordTemplateRequest request = new GetForgotPasswordTemplateRequest();
        request.setReset_password_link(reset_password_link);
        request.setLanguage(language);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            return (String)responseEntity.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Async
    public void sendForgotPasswordEmail(String to, String reset_password_link, String language) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/email/forgot-password";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SendForgotPasswordEmailRequest.builder().to(to).reset_password_link(reset_password_link).language(language).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Async
    public void sendEmail(String to, String subject, String body) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/email/send-email";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)SendEmailRequest.builder().to(to).subject(subject).body(body).build())), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parent createParent(long school_id, String country_code, String phone, String email) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/parent/create-parent";
        CreateParentRequest request = new CreateParentRequest();
        request.setSchool_id(school_id);
        request.setCountry_code(country_code);
        request.setPhone(phone);
        request.setEmail(email);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            Parent parent = (Parent)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return parent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Parent updateParent(long parent_id, String country_code, String phone, String email) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/parent/update-parent";
        UpdateParentRequest request = new UpdateParentRequest();
        request.setParent_id(parent_id);
        request.setCountry_code(country_code);
        request.setPhone(phone);
        request.setEmail(email);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            Parent parent = (Parent)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return parent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AccessCode updateAccessCodeByAccountIdAndStatus(long account_id, Status status) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/access-code/update-access-code-by-account-id-and-status";
        UpdateAccessCodeByAccountIdAndStatusRequest request = new UpdateAccessCodeByAccountIdAndStatusRequest();
        request.setAccount_id(account_id);
        request.setStatus(status);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            AccessCode accessCode = (AccessCode)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return accessCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public School getSchoolByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/school/get-school-by-student-id";
        GetSchoolByStudentIdRequest request = new GetSchoolByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            School school = (School)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return school;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OrganizationAdmin> getByOrganizationTypeAndAccountId(String organization_type, long account_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/organization-admin/get-by-organization-type-and-account-id";
        GetByOrganizationTypeAndAccountIdRequest request = new GetByOrganizationTypeAndAccountIdRequest();
        request.setOrganization_type(organization_type);
        request.setAccount_id(account_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            List organizationAdmins = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return organizationAdmins;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<AssessmentDTO> getAssessmentByStudentIdAndBetweenFromDateAndToDate(long student_id, Date fromDate, Date toDate) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/assessment/get-assessment-pv-state-by-student-id";
        GetByStudentIdAndBetweenFromDateAndToDateRequest request = new GetByStudentIdAndBetweenFromDateAndToDateRequest();
        request.setStudent_id(student_id);
        request.setFrom_date(fromDate);
        request.setTo_date(toDate);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List assessmentDTOS = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return assessmentDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<AssessmentDTO>();
        }
    }

    public List<StudentIdAndStandardIdWrapper> getStudentIdAndStandardIdByStudentIds(Set<Long> student_ids) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-student-id-and-standard-id-by-student-ids";
        GetByStudentIdsRequest request = new GetByStudentIdsRequest();
        request.setStudent_ids(student_ids);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            List studentIdAndStandardIdWrappers = (List)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return studentIdAndStandardIdWrappers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentIdAndStandardIdWrapper>();
        }
    }

    public StudentCoreDTO getStudentByAccountId(long account_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-by-account-id";
        GetByAccountIdRequest request = new GetByAccountIdRequest();
        request.setAccount_id(account_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            StudentCoreDTO studentCoreDTO = (StudentCoreDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return studentCoreDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public StudentCoreDTO getStudentByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student/get-by-student-id";
        GetByStudentIdRequest request = new GetByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            StudentCoreDTO studentCoreDTO = (StudentCoreDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return studentCoreDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AccessCodeDTO getAccessCodeByAccountId(long account_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/access-code/get-by-account-id";
        GetByAccountIdRequest request = new GetByAccountIdRequest();
        request.setAccount_id(account_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            AccessCodeDTO accessCodeDTO = (AccessCodeDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return accessCodeDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AccessCodeDTO getAccessCodeByStudentId(long student_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/access-code/get-by-student-id";
        GetByStudentIdRequest request = new GetByStudentIdRequest();
        request.setStudent_id(student_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            AccessCodeDTO accessCodeDTO = (AccessCodeDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return accessCodeDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AvatarDTO getAvatarById(long avatar_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/avatar/get-by-id";
        GetByAvatarIdRequest request = new GetByAvatarIdRequest();
        request.setAvatar_id(avatar_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            AvatarDTO avatarDTO = (AvatarDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return avatarDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void badgeReceived(BadgeReceivedNotificationRequest badgeReceivedNotificationRequest) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/badge-received";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)badgeReceivedNotificationRequest)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void streakReceived(StreakReceivedNotification streakReceivedNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/streak-received";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)streakReceivedNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void wowReaction(WOWReactionNotification wowReactionNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/wow-reaction";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)wowReactionNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void wowPostUnacceptableContent(WOWPostUnacceptableContentNotification wowPostUnacceptableContentNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/wow-post-unacceptable-content";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)wowPostUnacceptableContentNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void wowPostUnacceptableContents(WOWPostUnacceptableContentNotifications wowPostUnacceptableContentNotifications) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/student-push-notification/wow-post-unacceptable-contents";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)wowPostUnacceptableContentNotifications)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reviewWOWPost(ReviewWOWPostNotification reviewWOWPostNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/notification/review-wow-post";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)reviewWOWPostNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void badWordInJournal(BadWordInJournalNotification badWordInJournalNotification) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/notification/bad-word-in-journal";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)badWordInJournalNotification)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendFirebasePushNotification(SendFirebasePushNotificationRequest sendFirebasePushNotificationRequest) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/fcm/send/firebase/notification";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)sendFirebasePushNotificationRequest)), (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StandardDTO getStandardById(long standard_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-by-id";
        GetByStandardIdRequest request = new GetByStandardIdRequest();
        request.setStandard_id(standard_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            StandardDTO standardDTO = (StandardDTO)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return standardDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Corporate getCorporateById(long corporate_id) {
        String url = this.configurationRepository.getConfiguration().getBaseUrlApi() + "/api/standard/get-by-id";
        GetByIdRequest request = new GetByIdRequest();
        request.setId(corporate_id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthToken(headers);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)EncryptDecryptHelper.encrypt((String)this.objectMapper.writeValueAsString((Object)request)), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (AppUtils.isNullOrEmpty((String)((String)responseEntity.getBody()))) {
                return null;
            }
            Corporate corporate = (Corporate)this.objectMapper.readValue(EncryptDecryptHelper.decrypt((String)((String)responseEntity.getBody())), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return corporate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

