/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.appreciation;

import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.appreciation.StreakAppreciationStationService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class StreakAppreciationStationServiceImpl
implements StreakAppreciationStationService {
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final DailyAppreciationRepository dailyAppreciationRepository;
    private final StreakHelper streakHelper;

    public StreakAppreciationStationServiceImpl(StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, DailyAppreciationRepository dailyAppreciationRepository, StreakHelper streakHelper) {
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.streakHelper = streakHelper;
    }

    public StreakDTO addStreakAppreciationStation(long student_id) {
        List dailyAppreciations = this.dailyAppreciationRepository.findByStudent(Long.valueOf(student_id));
        List streaks = this.streakRepository.findByStreakType(StreakType.APPRECIATION_STATION.name());
        for (StreakDTO streak : streaks) {
            if (streak.getOccurrence() != dailyAppreciations.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
            return this.streakHelper.saveStudentStreak(student_id, streak);
        }
        return null;
    }
}

