/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporate.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.request.ActiveDeactiveCorporateRequest;
import com.infinite.focus.server.corporate.request.AddParentRequest;
import com.infinite.focus.server.corporate.request.CorporateDataApiRequest;
import com.infinite.focus.server.corporate.request.CorporateDeleteParentRequest;
import com.infinite.focus.server.corporate.request.CorporateEditParentRequest;
import com.infinite.focus.server.corporate.request.CorporateEditProfileRequest;
import com.infinite.focus.server.corporate.request.GetCorporateRequest;
import com.infinite.focus.server.corporate.request.GetParentsRequest;
import com.infinite.focus.server.corporate.request.ParentChangePasswordRequest;
import com.infinite.focus.server.corporate.request.SendNotificationRequest;
import com.infinite.focus.server.corporate.request.SetNewNotificationsForCorporateRequest;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.corporate.wrapper.LeaderboardWrapper;
import com.infinite.focus.server.corporate.wrapper.ParentWrapper;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.response.TheDailyClymbResponse;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/corporate"})
public class CorporateController {
    private final AuthService authService;
    private final MessageService messageService;
    private final CorporateService corporateService;
    private final AccountService accountService;
    private final ParentService parentService;
    private final EmailSenderService emailSenderService;
    private final TemplateService templateService;
    private final ConfigurationService configurationService;
    private final OrganizationAdminService organizationAdminService;
    private final JwtHelper jwtHelper;

    public CorporateController(AuthService authService, MessageService messageService, CorporateService corporateService, AccountService accountService, ParentService parentService, EmailSenderService emailSenderService, TemplateService templateService, ConfigurationService configurationService, OrganizationAdminService organizationAdminService, JwtHelper jwtHelper) {
        this.authService = authService;
        this.messageService = messageService;
        this.corporateService = corporateService;
        this.accountService = accountService;
        this.parentService = parentService;
        this.emailSenderService = emailSenderService;
        this.templateService = templateService;
        this.configurationService = configurationService;
        this.organizationAdminService = organizationAdminService;
        this.jwtHelper = jwtHelper;
    }

    @PostMapping(value={"/happiness-altitude"})
    @ResponseBody
    public ResponseEntity<Object> happinessAltitude(@RequestHeader(value="Authorization") String token, @RequestBody CorporateDataApiRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity(this.corporateService.happinessAltitude(corporate, request), HttpStatus.OK);
    }

    @PostMapping(value={"the-daily-clymb"})
    @ResponseBody
    public ResponseEntity<TheDailyClymbResponse> theDailyClymb(@RequestHeader(value="Authorization") String token, @RequestBody TheDailyClymbRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity((Object)this.corporateService.theDailyClymb(corporate, request), HttpStatus.OK);
    }

    @PostMapping(value={"comprehensive-report"})
    @ResponseBody
    public ResponseEntity<LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>> comprehensiveReport(@RequestHeader(value="Authorization") String token, @RequestBody CorporateDataApiRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity((Object)this.corporateService.comprehensiveReport(corporate, request), HttpStatus.OK);
    }

    @PostMapping(value={"/add-parent"})
    @ResponseBody
    public ResponseEntity<Message> addChildren(@RequestHeader(value="Authorization") String token, @RequestBody AddParentRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("first.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("last.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.email.should.not.empty.or.null"));
        }
        if (!AppUtils.isValidateEmail((String)request.getEmail())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.email.should.a.valid.email.address"));
        }
        String password = AppUtils.generatePassword();
        Account account = this.accountService.createAccountByEmailAndPassword(request.getEmail(), password);
        Parent parent = new Parent();
        parent.setFirst_name(request.getFirst_name());
        parent.setLast_name(request.getLast_name());
        parent.setAccount(account);
        parent.setCorporate_id(corporate.getCorporate_id());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Parent x = this.parentService.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                parent.setRegistration_code("P" + possible_code);
                continue;
            }
            isUnique = false;
        }
        Parent p = this.parentService.save(parent);
        try {
            this.emailSenderService.sendHtmlMail(account.getUsername(), Language.isSpanish((String)corporate.getLanguage()) ? "Bienvenido a Clymb" : "Welcome to Clymb", this.templateService.getSendEmailToParentForDashboardAccess(corporate.getOrganizationAdmin() == null ? null : corporate.getOrganizationAdmin().getFirst_name() + " " + corporate.getOrganizationAdmin().getLast_name(), corporate.getCorporate_name(), p.getFirst_name(), p.getFirst_name() + " " + p.getLast_name(), this.configurationService.getConfiguration().getBaseUrlCorporate(), account.getUsername(), password, corporate.getLanguage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("parent.added.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get/parents"})
    @ResponseBody
    public ResponseEntity<Page<ParentWrapper>> getParents(@RequestHeader(value="Authorization") String token, @RequestBody GetParentsRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity((Object)this.corporateService.getParentsByCorporateId(corporate.getCorporate_id(), request), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/child"})
    @ResponseBody
    public ResponseEntity<List<Student>> getChild(@RequestHeader(value="Authorization") String token) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity((Object)this.corporateService.getStudentsByCorporateId(corporate.getCorporate_id()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"leaderboard"})
    @ResponseBody
    public ResponseEntity<LinkedList<LeaderboardWrapper>> leaderboard(@RequestHeader(value="Authorization") String token, @RequestBody CorporateDataApiRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        return new ResponseEntity((Object)this.corporateService.leaderboard(corporate.getCorporate_id(), request.getFromDate(), request.getToDate()), HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Corporate> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody CorporateEditProfileRequest request) {
        Corporate c = this.authService.isCorporate(token);
        if (c == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (c.getOrganizationAdmin() != null) {
            if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.first.name.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.last.name.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getAddress())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.address.is.required"));
            }
            for (OrganizationAdmin o : this.organizationAdminService.findByOrganizationTypeAndAccountId(OrganizationType.CORPORATE.toString(), c.getOrganizationAdmin().getAccount_id())) {
                o.setFirst_name(request.getFirst_name());
                o.setLast_name(request.getLast_name());
                o.setAddress(request.getAddress());
                Account account = this.accountService.changeEmail(o.getAccount_id(), request.getUsername());
                OrganizationAdmin organizationAdmin = this.organizationAdminService.save(o);
            }
        } else {
            OrganizationAdmin o;
            if (AppUtils.isNullOrEmpty((String)request.getCorporate_name())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.name.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getCorporate_image())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.image.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getCorporate_image_2())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.image.two.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getAddress())) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.address.is.required"));
            }
            c.setCorporate_name(request.getCorporate_name());
            c.setCorporate_image(request.getCorporate_image());
            c.setCorporate_image_2(request.getCorporate_image_2());
            c.setAddress(request.getAddress());
            c.setNumber_of_youth(request.getNumber_of_youth());
            c.setLicence_key_expiry_date(request.getLicence_key_expiry_date());
            c.setFocus_on(request.getFocus_on());
            Account account = this.accountService.changeEmail(c.getAccount_id(), request.getUsername());
            o = this.corporateService.save(c);
        }
        String newToken = this.jwtHelper.generateToken(request.getUsername());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(request.getUsername()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)this.authService.isCorporate(newToken));
    }

    @PostMapping(value={"/get/active/corporates"})
    @ResponseBody
    public ResponseEntity<Page<Corporate>> getActiveCorporates(@RequestHeader(value="Authorization") String token, @RequestBody GetCorporateRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.corporateService.getActiveCorporates(request), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/inactive/corporates"})
    @ResponseBody
    public ResponseEntity<Page<Corporate>> getInactiveCorporates(@RequestHeader(value="Authorization") String token, @RequestBody GetCorporateRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.corporateService.getInactiveCorporates(request), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/active-deactive"})
    public ResponseEntity<Message> activeDeactive(@RequestHeader(value="Authorization") String token, @RequestBody ActiveDeactiveCorporateRequest request) throws IOException {
        this.authService.isAdmin(token);
        Corporate corporate = this.corporateService.activeDeactiveCorporate(request.getCorporate_id(), request.isActive());
        Message message = null;
        message = corporate.isActive() ? new Message(this.messageService.getMessage("the.corporate.is.activated")) : new Message(this.messageService.getMessage("the.corporate.is.deactivated"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/edit/parent"})
    @ResponseBody
    public ResponseEntity<Message> editParent(@RequestHeader(value="Authorization") String token, @RequestBody CorporateEditParentRequest request) {
        this.authService.isCorporate(token);
        this.parentService.editParent(request.getParent_id(), request.getFirst_name(), request.getLast_name(), request.getEmail());
        return new ResponseEntity((Object)new Message(this.messageService.getMessage("parent.details.are.changed.successfully")), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/delete/parent"})
    @ResponseBody
    public ResponseEntity<Message> deleteParent(@RequestHeader(value="Authorization") String token, @RequestBody CorporateDeleteParentRequest request) {
        this.authService.isCorporate(token);
        Parent parent = this.parentService.deleteParent(request.getParent_id(), request.isDeleted());
        Message message = parent.isDeleted() ? new Message(this.messageService.getMessage("the.parent.is.deleted")) : new Message(this.messageService.getMessage("the.parent.is.not.deleted"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/change-password/parent"})
    public ResponseEntity<Message> changePasswordParent(@RequestHeader(value="Authorization") String token, @RequestBody ParentChangePasswordRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        if (request.getPassword().length() < 6) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.password.should.be.six.character.long"));
        }
        Parent parent = this.parentService.getParentById(request.getParent_id());
        if (parent == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.parent.is.not.found"));
        }
        if (parent.getCorporate_id() != corporate.getCorporate_id()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.parent.is.not.belongs.to.this.corporate"));
        }
        Account account = this.accountService.changePassword(parent.getAccount_id(), request.getPassword());
        this.sendPasswordChangeEmail(account.getUsername(), parent.getFirst_name(), request.getPassword(), parent.getLanguage());
        Message message = new Message(this.messageService.getMessage("password.updated.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    public void sendPasswordChangeEmail(String email, String firstName, String password, String language) {
        try {
            this.emailSenderService.sendHtmlMail(email, Language.isSpanish() ? "\u00a1Restablecimiento de contrase\u00f1a para Clymb!" : "Password reset for Clymb!", this.templateService.getPasswordChange(firstName, password, language));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/send/notification/to/all/parents"})
    public ResponseEntity<Message> sendEmailToAllParents(@RequestHeader(value="Authorization") String token, @RequestBody SendNotificationRequest request) {
        Corporate corporate = this.authService.isCorporate(token);
        if (AppUtils.isNullOrEmpty((String)request.getText())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.text.is.required"));
        }
        new Thread(() -> this.corporateService.sendNotificationToAllParents(corporate.getCorporate_id(), request.getText(), request.getText_es())).start();
        Message message = new Message(this.messageService.getMessage("notification.sent"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/set-new-notifications"})
    public ResponseEntity<Void> setNewNotifications(@RequestBody SetNewNotificationsForCorporateRequest request) {
        this.corporateService.setCorporateNewNotifications(request.getCorporate_id(), request.isNew_notifications());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    public ResponseEntity<Corporate> getById(@RequestBody GetByIdRequest request) {
        this.corporateService.getCorporateById(request.getId());
        return new ResponseEntity(HttpStatus.OK);
    }
}

