/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm.util;

import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FCMUtil {
    private static Logger logger = LoggerFactory.getLogger(FCMUtil.class);

    public static Map<String, String> getPayloadForPushNotification(PushNotificationDTO request) {
        HashMap<String, String> pushData = new HashMap<String, String>();
        if (!AppUtils.isNullOrEmpty((String)request.getFormat_text())) {
            pushData.put("format_text", request.getFormat_text());
        }
        if (!AppUtils.isNullOrEmpty((String)request.getTitle())) {
            String title;
            String string = title = Language.isSpanish((String)request.getLanguage()) ? request.getTitle_es() : request.getTitle();
            if (!AppUtils.isNullOrEmpty((String)request.getFormat_text()) && request.getScreen_type().name().equals(NotificationType.SOS_ALERT.name())) {
                pushData.put("title", request.getFormat_text() + " " + title.trim());
            } else {
                pushData.put("title", title);
            }
        }
        if (!AppUtils.isNullOrEmpty((String)request.getMessage())) {
            String message;
            String string = message = Language.isSpanish((String)request.getLanguage()) ? request.getMessage_es() : request.getMessage();
            if (!AppUtils.isNullOrEmpty((String)request.getFormat_text()) && request.getScreen_type().name().equals(NotificationType.SOS_ALERT.name())) {
                pushData.put("message", request.getFormat_text() + " " + message.trim());
            } else if (request.getScreen_type() != null && !AppUtils.isNullOrEmpty((String)request.getScreen_type().name()) && request.getScreen_type().name().equals(StreakType.WOW_REACTION.name())) {
                pushData.put("message", FCMUtil.getReactionCodeByReaction((String)message));
            } else {
                pushData.put("message", message);
            }
        }
        if (request.getScreen_type() != null) {
            pushData.put("screen_type", request.getScreen_type().name());
        }
        try {
            pushData.put("created_at", DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(request.getCreatedAt()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pushData;
    }

    public static void sendMessages(Map<String, String> data, List<PushNotificationDTO> pushNotifications) throws InterruptedException, ExecutionException {
        ArrayList messageList = new ArrayList();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (PushNotificationDTO pushNotificationDTO : pushNotifications) {
            Message message = FCMUtil.getPreconfiguredMessageWithData(data, (PushNotificationDTO)pushNotificationDTO);
            messages.add(message);
            if (messages.size() != 400) continue;
            messageList.add(messages);
            messages = new ArrayList();
        }
        if (messageList.isEmpty()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String string = gson.toJson(messages);
            BatchResponse response = FCMUtil.sendAndGetResponse(messages);
            logger.info("Sent message with data. Topic: {} msg {}", (Object)response.toString(), (Object)string);
        } else {
            for (List list : messageList) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String jsonOutput = gson.toJson((Object)list);
                BatchResponse response = FCMUtil.sendAndGetResponse((List)list);
                logger.info("Divided Sent message with data. Topic: {} msg {}", (Object)response.toString(), (Object)jsonOutput);
            }
        }
    }

    public static Message getPreconfiguredMessageWithData(Map<String, String> data, PushNotificationDTO request) {
        String title;
        String body;
        System.out.println("Your Topic " + request.getTopic());
        String string = body = Language.isSpanish((String)request.getLanguage()) ? request.getMessage_es() : request.getMessage();
        if (!AppUtils.isNullOrEmpty((String)request.getFormat_text())) {
            body = request.getFormat_text() + " " + (Language.isSpanish((String)request.getLanguage()) ? request.getMessage_es().trim() : request.getMessage().trim());
        }
        String string2 = title = Language.isSpanish((String)request.getLanguage()) ? request.getTitle_es() : request.getTitle();
        if (request.getScreen_type() != null && !AppUtils.isNullOrEmpty((String)request.getScreen_type().name()) && request.getScreen_type().name().equals(NotificationType.SOS_ALERT.name()) && !AppUtils.isNullOrEmpty((String)request.getFormat_text()) && !AppUtils.isNullOrEmpty((String)request.getTitle())) {
            title = request.getFormat_text() + " " + (Language.isSpanish((String)request.getLanguage()) ? request.getTitle_es().trim() : request.getTitle().trim());
        }
        if (request.getScreen_type() != null && !AppUtils.isNullOrEmpty((String)request.getScreen_type().name()) && request.getScreen_type().name().equals(StreakType.WOW_REACTION.name()) && !AppUtils.isNullOrEmpty((String)request.getMessage())) {
            body = FCMUtil.getReactionCodeByReaction((String)body);
        }
        Notification notification = Notification.builder().setTitle(title).setBody(body).build();
        return FCMUtil.getPreconfiguredMessageBuilder((PushNotificationDTO)request).setNotification(notification).putAllData(data).setTopic(request.getTopic()).build();
    }

    private static String getReactionCodeByReaction(String reactionText) {
        if (reactionText.contains("&#x2B50")) {
            reactionText = reactionText.replace("&#x2B50", "\u2b50");
        } else if (reactionText.contains("&#x1F60D")) {
            reactionText = reactionText.replace("&#x1F60D", "\ud83d\ude0d");
        } else if (reactionText.contains("&#x1F602")) {
            reactionText = reactionText.replace("&#x1F602", "\ud83d\ude02");
        } else if (reactionText.contains("&#x1F44D")) {
            reactionText = reactionText.replace("&#x1F44D", "\ud83d\udc4d");
        } else if (reactionText.contains("&#x1f973")) {
            reactionText = reactionText.replace("&#x1f973", "\ud83e\udd73");
        }
        return reactionText;
    }

    public static Message.Builder getPreconfiguredMessageBuilder(PushNotificationDTO request) {
        AndroidConfig androidConfig = FCMUtil.getAndroidConfig((String)request.getTopic());
        ApnsConfig apnsConfig = FCMUtil.getApnsConfig((String)request.getTopic());
        return Message.builder().setApnsConfig(apnsConfig).setAndroidConfig(androidConfig);
    }

    public static AndroidConfig getAndroidConfig(String topic) {
        return AndroidConfig.builder().setTtl(Duration.ofMinutes(2L).toMillis()).setCollapseKey(topic).setPriority(AndroidConfig.Priority.HIGH).build();
    }

    public static ApnsConfig getApnsConfig(String topic) {
        return ApnsConfig.builder().setAps(Aps.builder().setCategory(topic).setThreadId(topic).build()).build();
    }

    public static BatchResponse sendAndGetResponse(List<Message> messages) throws InterruptedException, ExecutionException {
        return (BatchResponse)FirebaseMessaging.getInstance().sendEachAsync(messages).get();
    }
}

