/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.service;

import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.instructor.view.InstructorView;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.school.service.GetStudentsBySchoolRequest;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.view.StandardView;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SchoolServiceImpl
implements SchoolService {
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    AccessCodeRepository accessCodeRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    InstructorService instructorService;
    @Autowired
    StudentService studentService;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    DistrictService districtService;
    @Autowired
    FreeTrialService freeTrialService;
    @Autowired
    OrganizationAdminService organizationAdminService;
    @Autowired
    AccountService accountService;
    @Autowired
    ClassService classService;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    MessageService messageService;
    @Autowired
    StandardJPARepository standardRepository;
    @Autowired
    EntityManager entityManager;
    @Autowired
    private RestComponent restComponent;

    public School getSchoolById(long school_id) {
        return this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
    }

    public School getSchoolByCleverId(String clever_id) {
        return this.schoolRepository.findByCleverSchoolId(clever_id);
    }

    public List<School> getSchoolByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Page<School> getSchools(String schoolName, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = schoolName == null || schoolName.isEmpty() ? this.schoolRepository.findAllSchools((Pageable)paging) : this.schoolRepository.findBySchoolName(schoolName, (Pageable)paging);
        return pagedResult;
    }

    public List<School> getSchoolsByDistrictId(long district_id) {
        return this.schoolRepository.findByDistrictId(Long.valueOf(district_id));
    }

    public long getStudentsCountBySchoolId(long school_id) {
        return this.studentService.getStudentsCountBySchoolId(school_id);
    }

    public School activeDeactiveSchool(long school_id, boolean active) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        school.setActive(active);
        return (School)this.schoolRepository.save((Object)school);
    }

    public School getSchoolByStudentId(long student_id) {
        Student student = this.restComponent.getStudentById(student_id);
        Instructor instructor = this.restComponent.getInstructorById(student.getInstructor_id());
        return this.getSchoolById(instructor.getSchool_id());
    }

    public Date getRenewalDate(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district != null) {
            if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
                return district.getLicence_key_expiry_date();
            }
            return this.freeTrialService.getFreeTrialByDistrictId(district.getDistrict_id()).getTrial_end_date();
        }
        if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
            return school.getLicence_key_expiry_date();
        }
        return this.freeTrialService.getFreeTrialBySchoolId(school.getSchool_id()).getTrial_end_date();
    }

    public List<School> findByAccountId(long account_id) {
        List schools = this.schoolRepository.findByAccountId(Long.valueOf(account_id));
        if (AppUtils.isNullOrEmpty((List)schools)) {
            List organizationAdmins = this.organizationAdminService.findByOrganizationTypeAndAccountId(OrganizationType.ORGANIZATION.toString(), account_id);
            for (OrganizationAdmin organizationAdmin : organizationAdmins) {
                schools.add(this.schoolRepository.findBySchoolId(Long.valueOf(organizationAdmin.getOrganization_id())));
            }
        }
        return schools;
    }

    public School deleteSchool(long school_id, boolean deleted, boolean isFromFreeTrial) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        school.setDeleted(deleted);
        if (!isFromFreeTrial && school.getDistrict_id() == 0L && AppUtils.isNullOrEmpty((String)school.getLicense_key())) {
            FreeTrial freeTrial = this.freeTrialService.deleteFreeTrial(school.getSchool_id(), OrganizationType.ORGANIZATION, deleted);
        }
        return (School)this.schoolRepository.save((Object)school);
    }

    public School editSchool(long school_id, String school_name, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)school_name)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("school.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)address)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("address.is.null.or.empty"));
        }
        Account account = this.accountService.changeEmail(school.getAccount_id(), email);
        school.setSchool_name(school_name);
        school.setFocus_on(focus_on);
        school.setAddress(address);
        school.setNumber_of_youth(number_of_youth);
        if (school.getDistrict_id() == 0L && AppUtils.isNullOrEmpty((String)school.getLicense_key())) {
            this.freeTrialService.editFreeTrial(school.getSchool_id(), OrganizationType.ORGANIZATION, school_name, focus_on, licence_key_expiry_date);
        } else {
            school.setLicence_key_expiry_date(licence_key_expiry_date);
        }
        return (School)this.schoolRepository.save((Object)school);
    }

    public Page<Object> getStudentsBySchool(long school_Id, GetStudentsBySchoolRequest request) {
        Set<Object> ids;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Long.class);
        Root studentRoot = query.from(Student.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            predicates.add(qb.like(qb.lower((Expression)studentRoot.get("first_name")), "%" + request.getFirst_name().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            predicates.add(qb.like(qb.lower((Expression)studentRoot.get("last_name")), "%" + request.getLast_name().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            Predicate emailPredicate = qb.like((Expression)studentRoot.get("account").get("username"), "%" + request.getEmail() + "%");
            predicates.add(emailPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            ids = this.classService.findClassIdsWhereClassNameLike(request.getClass_name()).stream().map(BigInteger::longValue).collect(Collectors.toSet());
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root sqRoot = sq.correlate(studentRoot);
            Join sqJoin = sqRoot.join("classes");
            if (AppUtils.isNotNullOrEmpty(ids)) {
                sq.where((Expression)sqJoin.get("class_id").in(ids));
            } else {
                sq.where((Expression)sqJoin.get("class_id").in(new Object[]{-1}));
            }
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        ids = AppUtils.isNotNullOrEmpty((String)request.getInstructor_name()) ? this.instructorService.findInstructorIdsWhereInstructorNameLikeAndBySchoolId(request.getInstructor_name(), school_Id).stream().map(BigInteger::longValue).collect(Collectors.toSet()) : new HashSet();
        Predicate instructorsPredicate = AppUtils.isNotNullOrEmpty(ids) ? studentRoot.get("instructor").get("instructor_id").in(ids) : studentRoot.get("school").get("school_id").in(new Object[]{school_Id});
        predicates.add(instructorsPredicate);
        query.select((Selection)studentRoot.get("student_id")).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)studentRoot.get(request.getSortBy())), qb.desc((Expression)studentRoot.get("student_id"))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)studentRoot.get(request.getSortBy())), qb.asc((Expression)studentRoot.get("student_id"))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        TypedQuery result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root studentRootCount = countQuery.from(Student.class);
        countQuery.select((Selection)qb.count((Expression)studentRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result.getResultList(), (Pageable)pageable, count.longValue());
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(student_id -> {
            LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
            StudentView studentView = this.studentRepository.findStudentViewByStudentId(student_id);
            wrapper.put("student_id", studentView.getStudent_id());
            wrapper.put("first_name", studentView.getFirst_name());
            wrapper.put("last_name", studentView.getLast_name());
            AccountView accountView = this.accountRepository.findAccountViewByAccountId(studentView.getAccount_id());
            if (accountView != null) {
                wrapper.put("username", accountView.getUsername());
                wrapper.put("username2", accountView.getUsername2());
            } else {
                wrapper.put("username", null);
                wrapper.put("username2", null);
            }
            AccessCodeView accessCodeView = this.accessCodeRepository.findAccessCodeViewByStudentId(studentView.getStudent_id());
            if (accessCodeView != null) {
                wrapper.put("status", accessCodeView.getStatus());
            } else {
                wrapper.put("status", null);
            }
            InstructorView instructorView = this.instructorRepository.findInstructorViewByInstructorId(studentView.getInstructor_id());
            if (instructorView != null) {
                LinkedHashMap<String, Object> wrapperInstructor = new LinkedHashMap<String, Object>();
                wrapperInstructor.put("instructor_id", instructorView.getInstructor_id());
                wrapperInstructor.put("first_name", instructorView.getFirst_name());
                wrapperInstructor.put("last_name", instructorView.getLast_name());
                wrapper.put("instructor", wrapperInstructor);
            } else {
                wrapper.put("instructor", null);
            }
            StandardView standardView = this.standardRepository.findStandardViewByStandardId(studentView.getStandard_id());
            if (standardView != null) {
                LinkedHashMap<String, Object> wrapperStandard = new LinkedHashMap<String, Object>();
                wrapperStandard.put("standard_id", standardView.getStandard_id());
                wrapperStandard.put("standard_name", standardView.getStandard_name());
                wrapperStandard.put("grade_id", standardView.getGrade_id());
                wrapper.put("standard", wrapperStandard);
            } else {
                wrapper.put("standard", null);
            }
            LinkedList classViews = this.classRepository.findClassViewByStudentId(studentView.getStudent_id().longValue());
            if (!AppUtils.isNullOrEmpty((List)classViews)) {
                LinkedList classes = new LinkedList();
                for (ClassView classView : classViews) {
                    LinkedHashMap<String, String> wrapperClass = new LinkedHashMap<String, String>();
                    wrapperClass.put("class_name", classView.getClass_name());
                    classes.add(wrapperClass);
                }
                wrapper.put("classes", classes);
            } else {
                wrapper.put("classes", new ArrayList());
            }
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public String outOfStudentWhoLoggedBetween(long school_id, Date fromDate, Date toDate, TimeZone timeZone) {
        List instructorIds = this.instructorService.getInstructorIdsBySchoolId(school_id);
        if (AppUtils.isNullOrEmpty((List)instructorIds)) {
            return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        ArrayList studentIds = new ArrayList(this.studentService.getStudentIdsByInstructorIds(instructorIds));
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        List activities = this.activityService.getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(studentIds, DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(fromDate), DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(toDate), timeZone);
        return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", activities.size() + "").replace("<total>", studentIds.size() + "");
    }

    public List<StudentView> getStudentsBySchoolId(long school_id) {
        List instructors = this.instructorService.findBySchoolId(school_id);
        ArrayList<StudentView> studentViews = new ArrayList<StudentView>();
        for (Instructor i : instructors) {
            List classes = this.classService.findByInstructorId(i.getInstructor_id());
            for (Class c : classes) {
                studentViews.addAll(this.classService.findStudentsByClassId(c.getClass_id()));
            }
        }
        return studentViews;
    }

    public List<StudentView> getStudentsForSELAnalyticsBySchoolId(long school_id) {
        List instructors = this.instructorService.findBySchoolId(school_id);
        ArrayList<StudentView> studentViews = new ArrayList<StudentView>();
        for (Instructor i : instructors) {
            List classes = this.classService.findByInstructorId(i.getInstructor_id());
            for (Class c : classes) {
                studentViews.addAll(this.classService.findStudentsByClassIdForSELAnalytics(c.getClass_id()));
            }
        }
        return studentViews;
    }

    public School updateNumberOfYouthBySchoolId(long school_id, long number_of_youth) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The organization is not found!!!");
        }
        school.setNumber_of_youth(number_of_youth);
        return (School)this.schoolRepository.save((Object)school);
    }

    public School renewSubscriptionBySchoolId(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The organization is not found!!!");
        }
        school.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        school.setActive(true);
        return (School)this.schoolRepository.save((Object)school);
    }

    public void addLicenseKey(Invoice invoice) {
        School school = this.getSchoolById(invoice.getOrganization_id());
        school.setLicense_key(invoice.getLicense_key());
        school.setLicence_key_added_date(new Date());
        school.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        school.setActive(true);
        if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            school.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        this.schoolRepository.save((Object)school);
        FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.ORGANIZATION.toString(), school.getSchool_id());
        if (freeTrial != null) {
            this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
        }
    }

    public void updateSubscription(Invoice invoice) {
        if (!AppUtils.isNullOrEmpty((String)invoice.getLicense_key())) {
            this.addLicenseKey(invoice);
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            this.updateNumberOfYouthBySchoolId(invoice.getOrganization_id(), invoice.getNumber_of_youth());
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.RENEW_SUBSCRIPTION)) {
            this.renewSubscriptionBySchoolId(invoice.getOrganization_id());
        }
    }

    public School getSchoolByRegistrationCode(String registration_code) {
        return this.schoolRepository.findByRegistrationCode(registration_code);
    }

    public School save(School school) {
        return (School)this.schoolRepository.save((Object)school);
    }

    public String generateRegistrationCodeForSchool() {
        String registrationCode = null;
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "S" + KeyGenerator.generateUniqueAuthCode();
            School x = this.schoolRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                registrationCode = possible_code;
                continue;
            }
            isUnique = false;
        }
        return registrationCode;
    }

    public List<Instructor> getInstructorsBySchool(long school_id, GetStudentsBySchoolRequest request) {
        return this.instructorRepository.findBySchoolIdOrderByFirstNameASC(Long.valueOf(school_id));
    }

    public List<School> findAllSchoolsOrderBySchoolIdASC() {
        return this.schoolRepository.findAllSchoolsOrderBySchoolIdASC();
    }

    public String getSchoolEmailBySchoolId(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        GetEmailByAccountIdResponse getEmailByAccountIdResponse = this.restComponent.getEmailByAccountId(school.getAccount_id());
        return getEmailByAccountIdResponse.getEmail();
    }
}

