/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postcontent.repository;

import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.postcontent.repository.PostContentRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PostContentRepositoryImpl
implements PostContentRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static PostContentDTO mapRow(ResultSet rs, int i) throws SQLException {
        return PostContentDTO.builder().post_content_id(rs.getLong("post_content_id")).post_id(rs.getLong("post_id")).content_id(rs.getLong("content_id")).build();
    }

    public List<PostContentDTO> create(long post_id, Set<Long> content_ids) {
        String INSERT_SQL = "INSERT INTO post_content (post_id, content_id, created_at, updated_at) VALUES (?,?,?,?)";
        Set insertedIds = (Set)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO post_content (post_id, content_id, created_at, updated_at) VALUES (?,?,?,?)", 1), ps -> {
            for (Long content_id : content_ids) {
                ps.setLong(1, post_id);
                ps.setLong(2, content_id);
                ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
                ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet resultSet = ps.getGeneratedKeys();
            HashSet<Long> ids = new HashSet<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return this.findByIds(insertedIds);
    }

    public List<PostContentDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<PostContentDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM post_content WHERE post_content_id IN(%s) ORDER BY post_content_id ASC";
        List postAndCategoryDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), PostContentRepositoryImpl::mapRow);
        return postAndCategoryDTOS;
    }

    public void delete(long post_id) {
        String SQL = "DELETE FROM post_content WHERE post_id = ?";
        this.jdbcTemplate.update("DELETE FROM post_content WHERE post_id = ?", new Object[]{post_id});
    }

    public List<Long> findPostIdsByContentIds(Set<Long> content_ids) {
        if (AppUtils.isNullOrEmpty(content_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(content_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(post_id) FROM post_content WHERE content_id IN(%s) ORDER BY post_id ASC";
        List post_ids = this.jdbcTemplate.query(String.format(SQL, inSql), content_ids.toArray(), (rs, i) -> rs.getLong(1));
        return post_ids;
    }

    public List<PostContentDTO> findPostContentListByPostIds(Set<Long> post_ids) {
        if (AppUtils.isNullOrEmpty(post_ids)) {
            return new ArrayList<PostContentDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(post_ids.size(), "?"));
        String SQL = "SELECT * FROM post_content WHERE post_id IN(%s) ORDER BY post_id ASC";
        List postContentDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), post_ids.toArray(), PostContentRepositoryImpl::mapRow);
        return postContentDTOS;
    }
}

