/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.socioemotionaltestresult.service;

import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultServiceImpl;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioEmotionalTestResultServiceImpl
implements SocioEmotionalTestResultService {
    @Autowired
    EntityManager entityManager;

    public List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(List<Long> student_ids, TimeLine timeLine) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<SocioEmotionalTestResult>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
        System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
        predicates.add(criteriaBuilder.greaterThan((Expression)root.get("createdAt"), (Comparable)toDate));
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }

    public LinkedHashMap<String[], List<SocioEmotionalTestResult>> getSocioEmotionalTestResultMapByTimeLine(TimeLine timeLine, List<SocioEmotionalTestResult> socioEmotionalTestResultList, String language) {
        LinkedHashMap testResultMap = null;
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$TimeLine[timeLine.ordinal()]) {
            case 1: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getDailyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.dailyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.dailyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 2: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getWeeklyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.getWeekendByDate((Date)testResult.getCreatedAt(), (String)"en");
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.getWeekendByDate((Date)testResult.getCreatedAt(), (String)"es");
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 3: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getMonthlyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.monthlyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.monthlyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 4: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getYearlyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.yearlyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.yearlyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
        }
        return testResultMap;
    }

    private LinkedHashMap<String[], List<SocioEmotionalTestResult>> fillSocioEmotionalTestResultMap(List<String[]> keys) {
        LinkedHashMap<String[], List<SocioEmotionalTestResult>> map = new LinkedHashMap<String[], List<SocioEmotionalTestResult>>();
        for (String[] key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    public List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(LinkedHashSet<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        if (fromDate != null && toDate != null) {
            System.out.println("getSocioEmotionalTestResultByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }
}

