/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.standard.repository;

import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.repository.StandardRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StandardRepositoryImpl
implements StandardRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static StandardDTO mapRow(ResultSet rs, int i) throws SQLException {
        return StandardDTO.builder().standard_id(rs.getLong("standard_id")).standard_name(rs.getString("standard_name")).grade_id(rs.getLong("grade_id")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public List<StandardDTO> findAll() {
        String SQL = "SELECT * FROM standard ORDER BY standard_id ASC ";
        return this.jdbcTemplate.query(SQL, StandardRepositoryImpl::mapRow);
    }

    public List<StandardDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<StandardDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM standard WHERE standard_id IN(%s) ORDER BY standard_id ASC";
        List standardDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), StandardRepositoryImpl::mapRow);
        return standardDTOS;
    }

    public StandardDTO findById(long id) {
        String SQL = "SELECT * FROM standard WHERE standard_id = ? ";
        try {
            return (StandardDTO)this.jdbcTemplate.queryForObject(SQL, StandardRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

