/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.repository;

import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.model.AppType;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.student.wrapper.StudentIdAndStandardIdWrapper;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StudentCoreRepositoryImpl
implements StudentCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public StudentCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static StudentCoreDTO mapRow(ResultSet rs, int i) throws SQLException {
        return StudentCoreDTO.builder().student_id(rs.getLong("student_id")).account_id(rs.getLong("account_id")).avatar_id(rs.getLong("avatar_id")).ethnicity(rs.getString("ethnicity")).first_name(rs.getString("first_name")).gender(rs.getString("gender")).instructor_id(rs.getLong("instructor_id")).last_name(rs.getString("last_name")).verified(rs.getBoolean("is_verified")).fcm_token(rs.getString("fcm_token")).should_force_socio_emotional_assessment(rs.getBoolean("should_force_socio_emotional_assessment")).standard_id(rs.getLong("standard_id")).appType(rs.getString("app_type") == null ? null : AppType.valueOf((String)rs.getString("app_type"))).date_of_birth((Date)rs.getDate("date_of_birth")).browser(rs.getString("browser")).operating_system(rs.getString("operating_system")).new_notificaitons(rs.getBoolean("new_notificaitons")).should_auto_show_assessment(rs.getBoolean("should_auto_show_assessment")).parent_id(rs.getLong("parent_id")).share_your_success(rs.getBoolean("share_your_success")).share_journal_with_instructor(rs.getBoolean("share_journal_with_instructor")).share_journal_with_parents(rs.getBoolean("share_journal_with_parents")).school_id(rs.getLong("school_id")).clever_id(rs.getString("clever_id")).last_sync((Date)rs.getTimestamp("last_sync")).archived(rs.getBoolean("archived")).demo(rs.getBoolean("demo")).access_removed_by_parent(rs.getBoolean("access_removed_by_parent")).language(rs.getString("language")).registration_code(rs.getString("registration_code")).build();
    }

    public List<StudentCoreDTO> findAll() {
        String SQL = "SELECT * FROM student s ORDER BY s.student_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, StudentCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentCoreDTO>();
        }
    }

    public List<StudentIdAndStandardIdWrapper> findStudentIdAndStandardIdByStudentIds(Set<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<StudentIdAndStandardIdWrapper>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "SELECT student_id, standard_id FROM student WHERE student_id IN(%s) ORDER BY student_id ASC";
        try {
            List studentIdAndStandardIdWrappers = this.jdbcTemplate.query(String.format(SQL, inSql), student_ids.toArray(), (rs, i) -> StudentIdAndStandardIdWrapper.builder().student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).build());
            return studentIdAndStandardIdWrappers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentIdAndStandardIdWrapper>();
        }
    }

    public StudentCoreDTO findById(long student_id) {
        String SQL = "SELECT * FROM student s WHERE s.student_id = ? ";
        try {
            return (StudentCoreDTO)this.jdbcTemplate.queryForObject(SQL, StudentCoreRepositoryImpl::mapRow, new Object[]{student_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public StudentCoreDTO findByAccountId(long account_id) {
        String SQL = "SELECT * FROM student s WHERE s.account_id = ? ";
        try {
            return (StudentCoreDTO)this.jdbcTemplate.queryForObject(SQL, StudentCoreRepositoryImpl::mapRow, new Object[]{account_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StudentCoreDTO> findByIds(List<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<StudentCoreDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM student WHERE student_id IN(%s) ORDER BY student_id ASC";
        try {
            List studentCoreDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), StudentCoreRepositoryImpl::mapRow);
            return studentCoreDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentCoreDTO>();
        }
    }

    public List<StudentCoreDTO> findByInstructorId(long instructor_id) {
        String SQL = "SELECT * FROM student WHERE instructor_id = ? ORDER BY student_id";
        try {
            return this.jdbcTemplate.query(SQL, StudentCoreRepositoryImpl::mapRow, new Object[]{instructor_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentCoreDTO>();
        }
    }

    public List<Long> findIdsByInstructorId(long instructor_id) {
        String SQL = "SELECT DISTINCT(student_id) FROM student WHERE instructor_id = ? ORDER BY student_id";
        try {
            return this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong(1), new Object[]{instructor_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public List<StudentCoreDTO> findIdsByInstructorIdAndStatus(long instructor_id, Set<String> status) {
        if (AppUtils.isNullOrEmpty(status)) {
            return new ArrayList<StudentCoreDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(status.size(), "?"));
        String SQL = "SELECT * FROM student s JOIN access_code a ON s.student_id = a.student_id WHERE s.instructor_id = ? AND a.status IN(%s) ORDER BY s.student_id ASC ";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(instructor_id);
        args.addAll(status);
        try {
            List studentCoreDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), StudentCoreRepositoryImpl::mapRow);
            return studentCoreDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StudentCoreDTO>();
        }
    }

    public void setNewNotifications(List<Long> student_ids, boolean new_notifications) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "UPDATE student SET new_notificaitons = ? WHERE student_id IN(%s) ";
        ArrayList<Comparable<Boolean>> args = new ArrayList<Comparable<Boolean>>();
        args.add(Boolean.valueOf(new_notifications));
        args.addAll(student_ids);
        this.jdbcTemplate.update(String.format("UPDATE student SET new_notificaitons = ? WHERE student_id IN(%s) ", inSql), args.toArray());
    }

    public void setShouldForceSocioEmotionalAssessment(List<Long> student_ids, boolean should_force_socio_emotional_assessment) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "UPDATE student SET should_force_socio_emotional_assessment = ? WHERE student_id IN(%s) ";
        ArrayList<Comparable<Boolean>> args = new ArrayList<Comparable<Boolean>>();
        args.add(Boolean.valueOf(should_force_socio_emotional_assessment));
        args.addAll(student_ids);
        this.jdbcTemplate.update(String.format("UPDATE student SET should_force_socio_emotional_assessment = ? WHERE student_id IN(%s) ", inSql), args.toArray());
    }
}

