/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentbadge.service;

import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.badge.repository.BadgeRepository;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.notification.model.AccountIdAndLanguage;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentbadge.entity.StudentBadge;
import com.infinite.focus.server.studentbadge.model.AssignedByType;
import com.infinite.focus.server.studentbadge.repository.StudentBadgeRepository;
import com.infinite.focus.server.studentbadge.service.StudentBadgeService;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedNotification;
import com.infinite.focus.server.studentpushnotification.request.BadgeReceivedNotificationRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class StudentBadgeServiceImpl
implements StudentBadgeService {
    private final StudentBadgeRepository studentBadgeRepository;
    private final ClassRepository classRepository;
    private final BadgeRepository badgeRepository;
    private final ConfigurationRepository configurationRepository;
    private final RestComponent restComponent;

    public StudentBadgeServiceImpl(StudentBadgeRepository studentBadgeRepository, ClassRepository classRepository, BadgeRepository badgeRepository, ConfigurationRepository configurationRepository, RestComponent restComponent) {
        this.studentBadgeRepository = studentBadgeRepository;
        this.classRepository = classRepository;
        this.badgeRepository = badgeRepository;
        this.configurationRepository = configurationRepository;
        this.restComponent = restComponent;
    }

    public StudentBadge create(long student_id, String title, String title_es, String description, String description_es, AssignedByType assigned_by_type, long assigned_by_id, long badge_id) {
        StudentBadge studentBadge = new StudentBadge();
        studentBadge.setStudent_id(student_id);
        studentBadge.setAssigned_by_type(assigned_by_type);
        studentBadge.setAssigned_by_id(assigned_by_id);
        studentBadge.setBadge_id(badge_id);
        Badge badge = this.badgeRepository.findByBadgeId(Long.valueOf(badge_id));
        if (badge != null) {
            title = badge.getTitle();
            title_es = badge.getTitle_es();
            description = badge.getDescription();
            description_es = badge.getDescription_es();
        }
        studentBadge.setTitle(title);
        studentBadge.setTitle_es(title_es);
        studentBadge.setDescription(description);
        studentBadge.setDescription_es(description_es);
        return (StudentBadge)this.studentBadgeRepository.save((Object)studentBadge);
    }

    public void assignBadgeToStudents(List<Long> student_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        HashMap<Long, AccountIdAndLanguage> studentAndAccountIds = new HashMap<Long, AccountIdAndLanguage>();
        for (StudentCoreDTO studentDTO : this.restComponent.getStudentsByIds(student_ids)) {
            studentAndAccountIds.put(studentDTO.getStudent_id(), AccountIdAndLanguage.builder().account_id(studentDTO.getAccount_id()).language(studentDTO.getLanguage()).build());
        }
        this.assignBadgeToStudents(studentAndAccountIds, assigned_by_type, assigned_by_id, name, badge_id, title, title_es, description, description_es);
    }

    @Async
    @Transactional
    public void assignBadgeToStudents(Map<Long, AccountIdAndLanguage> studentAndAccountIds, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        ArrayList<BadgeReceivedNotification> badgeReceivedNotifications = new ArrayList<BadgeReceivedNotification>();
        for (long student_id : studentAndAccountIds.keySet()) {
            try {
                StudentBadge studentBadge = this.create(student_id, title, title_es, description, description_es, assigned_by_type, assigned_by_id, badge_id);
                AccountIdAndLanguage accountIdAndLanguage = studentAndAccountIds.get(student_id);
                BadgeReceivedNotification badgeReceivedRequest = BadgeReceivedNotification.builder().student_id(student_id).account_id(accountIdAndLanguage.getAccount_id()).demo(accountIdAndLanguage.isDemo()).format_text(name).title(studentBadge.getTitle()).title_es(studentBadge.getTitle_es()).language(accountIdAndLanguage.getLanguage()).build();
                badgeReceivedNotifications.add(badgeReceivedRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.restComponent.badgeReceived(BadgeReceivedNotificationRequest.builder().badge_received_push_notifications(badgeReceivedNotifications).build());
    }

    @Async
    @Transactional
    public void assignBadgeToClasses(List<Long> class_ids, AssignedByType assigned_by_type, long assigned_by_id, String name, long badge_id, String title, String title_es, String description, String description_es) {
        HashMap<Long, AccountIdAndLanguage> studentAndAccountIds = new HashMap<Long, AccountIdAndLanguage>();
        for (long id : class_ids) {
            List studentViewsByClassId = this.classRepository.findStudentViewsByClassId(id);
            for (StudentView studentView : studentViewsByClassId) {
                studentAndAccountIds.put(studentView.getStudent_id(), AccountIdAndLanguage.builder().account_id(studentView.getAccount_id().longValue()).demo(studentView.isDemo()).language(studentView.getLanguage()).build());
            }
        }
        if (!studentAndAccountIds.isEmpty()) {
            this.assignBadgeToStudents(studentAndAccountIds, assigned_by_type, assigned_by_id, name, badge_id, title, title_es, description, title_es);
        }
    }

    public List<Badge> getStudentBadgeByStudentId(Long student_id) {
        String badgeImagesPath = this.configurationRepository.getConfiguration().getBadge_images_path();
        List badges = this.badgeRepository.findAllBadgesOrderByBadgeIdAsc();
        ArrayList<Badge> badgeWithIdZero = new ArrayList<Badge>();
        block0: for (StudentBadge studentBadge : this.studentBadgeRepository.findByStudentIdOrderByStudentBadgeIdDESC(student_id)) {
            Badge badge2 = this.badgeRepository.findByBadgeId(Long.valueOf(studentBadge.getBadge_id()));
            if (badge2 != null) {
                for (Badge item : badges) {
                    if (item.getBadge_id() != studentBadge.getBadge_id()) continue;
                    item.setCount(item.getCount() + 1L);
                    continue block0;
                }
                continue;
            }
            Badge badgeWitZeroId = new Badge();
            badgeWitZeroId.setTitle(studentBadge.getTitle());
            badgeWitZeroId.setTitle_es(studentBadge.getTitle_es());
            badgeWitZeroId.setDescription(studentBadge.getDescription());
            badgeWitZeroId.setDescription_es(studentBadge.getDescription_es());
            badgeWitZeroId.setImage("Badge.png");
            badgeWitZeroId.setCount(1L);
            badgeWitZeroId.setShould_show_on_front(true);
            badgeWitZeroId.setCreatedAt(studentBadge.getCreatedAt());
            badgeWithIdZero.add(badgeWitZeroId);
        }
        badges.addAll(badgeWithIdZero);
        return badges.stream().peek(badge -> badge.setImage(badgeImagesPath + badge.getImage())).sorted((c1, c2) -> Long.compare(c2.getCount(), c1.getCount())).collect(Collectors.toList());
    }
}

