/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.accesscode.service;

import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.repository.AccessCodeCoreRepository;
import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.parent.entity.StudentProfileOtp;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AccessCodeServiceImpl
implements AccessCodeService {
    private final EntityManager entityManager;
    private final ParentService parentService;
    private final StudentService studentService;
    private final AccessCodeRepository accessCodeRepository;
    private final AccessCodeCoreRepository accessCodeCoreRepository;
    private final RestComponent restComponent;

    public AccessCodeServiceImpl(EntityManager entityManager, ParentService parentService, StudentService studentService, AccessCodeRepository accessCodeRepository, AccessCodeCoreRepository accessCodeCoreRepository, RestComponent restComponent) {
        this.entityManager = entityManager;
        this.parentService = parentService;
        this.studentService = studentService;
        this.accessCodeRepository = accessCodeRepository;
        this.accessCodeCoreRepository = accessCodeCoreRepository;
        this.restComponent = restComponent;
    }

    public AccessCode getAccessCodeByStudentAccountId(long account_id) {
        Student student = this.studentService.getStudentByAccountId(account_id);
        return this.accessCodeRepository.findByStudentIdAndInstructorId(Long.valueOf(student.getStudent_id()), Long.valueOf(student.getInstructor_id()));
    }

    public AccessCode updateAccessCodeByAccountIdAndStatus(long account_id, Status status) {
        AccessCode accessCode = this.getAccessCodeByStudentAccountId(account_id);
        if (accessCode == null) {
            return null;
        }
        accessCode.setStatus(status);
        return (AccessCode)this.accessCodeRepository.save((Object)accessCode);
    }

    public AccessCode createAccessCode(long student_id, Status status) {
        status = Status.ACCEPTED;
        Student s = this.studentService.getStudentById(student_id);
        if (s == null) {
            return null;
        }
        AccessCode accessCode = this.accessCodeRepository.findByStudentId(Long.valueOf(student_id));
        if (accessCode == null) {
            accessCode = new AccessCode(s, s.getInstructor(), s.getParent());
        }
        accessCode.setInstructor(s.getInstructor());
        accessCode.setParent(s.getParent());
        StudentProfileOtp studentProfileOtp = this.parentService.getStudentProfileOtpByAccountId(s.getAccount().getAccount_id());
        if (s.getParent() != null && s.getParent().getCorporate_id() > 0L) {
            status = Status.ACCEPTED;
        }
        if (s.getDate_of_birth() != null && DateUtils.getAge((Date)s.getDate_of_birth()) >= 13) {
            status = Status.ACCEPTED;
        }
        if (status.equals((Object)Status.ACCEPTED)) {
            studentProfileOtp = this.parentService.updateStudentProfileOtpByAccountIdAndStatus(s.getAccount().getAccount_id(), status);
        }
        if (studentProfileOtp != null) {
            accessCode.setStatus(studentProfileOtp.getStatus());
        } else {
            accessCode.setStatus(status);
        }
        return (AccessCode)this.accessCodeRepository.save((Object)accessCode);
    }

    public AccessCode getAccessCodeByStudentId(long student_id) {
        return this.accessCodeRepository.findByStudentId(Long.valueOf(student_id));
    }

    public Page<AccessCode> getAccessCodesByInstructorIdAndStatus(Long instructor_id, String status, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(AccessCode.class);
        Root root = query.from(AccessCode.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(qb.equal((Expression)root.get("instructor").get("instructor_id"), (Object)instructor_id));
        predicates.add(qb.equal((Expression)root.get("status"), (Object)Status.valueOf((String)status)));
        query.where(predicates.toArray(new Predicate[0]));
        if (orderBy.equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(sortBy))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(sortBy))});
        }
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(AccessCode.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public void saveAll(List<AccessCode> accessCodes) {
        this.accessCodeRepository.saveAll(accessCodes);
    }

    public void save(AccessCode accessCode) {
        this.accessCodeRepository.save((Object)accessCode);
    }

    public List<AccessCodeDTO> getAll() {
        return this.accessCodeCoreRepository.findAll();
    }

    public AccessCodeDTO getById(long access_code_id) {
        return this.accessCodeCoreRepository.findById(access_code_id);
    }

    public AccessCodeDTO getByStudentId(long student_id) {
        return this.accessCodeCoreRepository.findByStudentId(student_id);
    }

    @Async
    public void updateInstructorIdAndParentIdByStudentId(long instructor_id, long parent_id, long student_id) {
        this.accessCodeCoreRepository.updateInstructorIdAndParentIdByStudentId(instructor_id, parent_id, student_id);
    }
}

