/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.askforhelp.controller;

import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByIdRequest;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByStudentIdRequest;
import com.infinite.focus.server.askforhelp.request.GetByStudentAndSchoolIdRequest;
import com.infinite.focus.server.askforhelp.request.SetSOSRequestIdRequest;
import com.infinite.focus.server.askforhelp.service.AskForHelpService;
import com.infinite.focus.server.askforhelp.wrapper.AskForHelpWrapper;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/ask-for-help"})
public class AskForHelpController {
    @Autowired
    private AskForHelpService askForHelpService;
    @Autowired
    private RestComponent restComponent;

    @PostMapping(value={"/get-pending-ask-for-help-by-student-id"})
    ResponseEntity<AskForHelpDTO> getPendingAskForHelpByStudentId(@RequestBody GetAskForHelpByStudentIdRequest request) {
        List askForHelpDTOS = this.askForHelpService.getAskForHelpByStudentId(request.getStudent_id());
        for (AskForHelpDTO askForHelpDTO : askForHelpDTOS) {
            SOSRequestDTO sosRequestDTO = this.restComponent.getSOSRequestByAskForHelpId(askForHelpDTO.getAsk_for_help_id());
            if (sosRequestDTO != null) continue;
            return new ResponseEntity((Object)askForHelpDTO, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/get-ask-for-help-by-student-id"})
    ResponseEntity<AskForHelpDTO> getAskForHelpByStudentId(@RequestBody GetAskForHelpByStudentIdRequest request) {
        List askForHelpDTOS = this.askForHelpService.getAskForHelpByStudentId(request.getStudent_id());
        for (AskForHelpDTO askForHelpDTO : askForHelpDTOS) {
            SOSRequestDTO sosRequestDTO = this.restComponent.getSOSRequestByAskForHelpId(askForHelpDTO.getAsk_for_help_id());
            if (sosRequestDTO != null) continue;
            return new ResponseEntity((Object)askForHelpDTO, HttpStatus.OK);
        }
        Student student = this.restComponent.getStudentById(request.getStudent_id());
        long activeSOSQuestionCount = this.restComponent.getActiveSOSQuestionCount();
        if (activeSOSQuestionCount <= 0L) {
            return new ResponseEntity(HttpStatus.OK);
        }
        SOSTimeDTO sosTimeDTO = this.restComponent.getSOSTimeBySchoolId(student.getSchool_id());
        if (!(sosTimeDTO == null || sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date()))) {
            return new ResponseEntity(HttpStatus.OK);
        }
        List askForHelpMoods = this.restComponent.getAskForHelpMoods();
        List lastThreeMoodsByStudentId = this.restComponent.getLastThreeMoodsByStudentId(request.getStudent_id());
        if (AppUtils.isNullOrEmpty((List)lastThreeMoodsByStudentId) || lastThreeMoodsByStudentId.size() != 3) {
            return new ResponseEntity(HttpStatus.OK);
        }
        long mood_update_id_last = ((MoodUpdateDTO)lastThreeMoodsByStudentId.get(2)).getMood_update_id();
        if (!AppUtils.isNullOrEmpty((List)askForHelpDTOS) && ((AskForHelpDTO)askForHelpDTOS.get(0)).getMood_update_id() >= mood_update_id_last) {
            return new ResponseEntity(HttpStatus.OK);
        }
        for (MoodUpdateDTO moodUpdateDTO : lastThreeMoodsByStudentId) {
            boolean matched = false;
            for (MoodDTO moodDTO : askForHelpMoods) {
                if (moodUpdateDTO.getMood_id() != moodDTO.getMood_id()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.askForHelpService.create(request.getStudent_id(), ((MoodUpdateDTO)lastThreeMoodsByStudentId.get(0)).getMood_update_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/set-sos-request-id"})
    ResponseEntity<AskForHelpDTO> setSOSRequestId(@RequestBody SetSOSRequestIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.setSOSRequestId(request.getAsk_for_help_id(), request.getSos_request_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-ask-for-help-by-id"})
    ResponseEntity<AskForHelpDTO> getPendingAskForHelpByStudentId(@RequestBody GetAskForHelpByIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.getAskForHelpById(request.getAsk_for_help_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id-and-school-id"})
    ResponseEntity<AskForHelpWrapper> getByStudentIdAndSchoolId(@RequestBody GetByStudentAndSchoolIdRequest request) {
        return new ResponseEntity((Object)this.askForHelpService.getByStudentIdAndSchoolId(request.getStudent_id(), request.getSchool_id()), HttpStatus.OK);
    }
}

