/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.security.advice;

import com.infinite.focus.server.auth.exception.NotFoundException;
import com.infinite.focus.server.auth.exception.TimeOutException;
import com.infinite.focus.server.security.response.CustomExceptionResponse;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ResponseStatusException;

@RestControllerAdvice
public class CustomExceptionHandler {
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<CustomExceptionResponse> exception(Exception ex, HttpServletRequest httpServletRequest) {
        CustomExceptionResponse.CustomExceptionResponseBuilder builder = CustomExceptionResponse.builder().timestamp(new Date()).status(Integer.valueOf(500)).error(ex.getMessage()).message(ex.getLocalizedMessage()).path(httpServletRequest.getServletPath());
        if (ex instanceof RuntimeException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof NullPointerException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof InterruptedException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof ExecutionException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof TimeOutException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof TimeOutException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof NotFoundException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof IOException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof UnsupportedEncodingException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof MessagingException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof SQLException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof JpaSystemException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof GenericJDBCException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)409).value())).error(ex.getClass().getCanonicalName()).message(ex.getMessage());
        }
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)ex;
            builder.status(Integer.valueOf(responseStatusException.getStatus().value())).error(responseStatusException.getStatus().getReasonPhrase()).message(responseStatusException.getReason());
        }
        if (ex instanceof BadCredentialsException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)401).value())).error("access_denied_reason").message("Authentication Failure");
        }
        if (ex instanceof AccessDeniedException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)403).value())).error("access_denied_reason").message("not_authorized!");
        }
        if (ex instanceof SignatureException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)403).value())).error("access_denied_reason").message("JWT Signature not valid");
        }
        if (ex instanceof ExpiredJwtException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)403).value())).error("access_denied_reason").message("JWT Token already expired!");
        }
        if (ex instanceof EmptyResultDataAccessException) {
            builder.status(Integer.valueOf(HttpStatus.valueOf((int)404).value())).error("record_not_found").message("Record is not found!");
        }
        CustomExceptionResponse exceptionResponse = builder.build();
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.valueOf((int)exceptionResponse.getStatus()));
    }
}

