/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.favorite.repository;

import com.infinite.focus.server.favorite.dto.FavoriteDTO;
import com.infinite.focus.server.favorite.repository.FavoriteRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class FavoriteRepositoryImpl
implements FavoriteRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static FavoriteDTO mapRow(ResultSet rs, int i) throws SQLException {
        return FavoriteDTO.builder().favorite_id(rs.getLong("favorite_id")).post_id(rs.getLong("post_id")).student_id(rs.getLong("student_id")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public FavoriteDTO create(long post_id, long student_id) {
        String INSERT_SQL = "INSERT INTO favorite (post_id, student_id, created_at) VALUES (?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO favorite (post_id, student_id, created_at) VALUES (?,?,?)", 1);
            ps.setLong(1, post_id);
            ps.setLong(2, student_id);
            ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int favorite_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)favorite_id);
    }

    public FavoriteDTO findById(long id) {
        String SQL = "SELECT * FROM favorite WHERE favorite_id = ? ";
        try {
            FavoriteDTO favoriteDTO = (FavoriteDTO)this.jdbcTemplate.queryForObject(SQL, FavoriteRepositoryImpl::mapRow, new Object[]{id});
            return favoriteDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM favorite WHERE favorite_id = ? ";
        try {
            this.jdbcTemplate.update(SQL, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteByStudentIds(List<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "DELETE FROM favorite WHERE student_id IN(%S)";
        try {
            this.jdbcTemplate.update(String.format(SQL, inSql), student_ids.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> findPostIdsByStudentId(long student_id) {
        String SQL = "SELECT DISTINCT(post_id) FROM favorite WHERE student_id = ? ORDER BY post_id ASC";
        List post_ids = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong(1), new Object[]{student_id});
        return post_ids;
    }

    public List<FavoriteDTO> findByStudentId(Long student_id) {
        String SQL = "SELECT * FROM favorite WHERE student_id = ? ORDER BY post_id ASC";
        List favoriteDTOS = this.jdbcTemplate.query(SQL, FavoriteRepositoryImpl::mapRow, new Object[]{student_id});
        return favoriteDTOS;
    }

    public FavoriteDTO findByPostIdAndStudentId(long post_id, long student_id) {
        String SQL = "SELECT * FROM favorite WHERE post_id = ? AND student_id = ? ";
        try {
            FavoriteDTO favoriteDTO = (FavoriteDTO)this.jdbcTemplate.queryForObject(SQL, FavoriteRepositoryImpl::mapRow, new Object[]{post_id, student_id});
            return favoriteDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

