/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.relationshipskills.service;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.relationshipskills.dto.RelationshipSkillsUpdateDTO;
import com.infinite.focus.server.relationshipskills.entity.RelationshipSkillsUpdate;
import com.infinite.focus.server.relationshipskills.model.DataSetIdAndText;
import com.infinite.focus.server.relationshipskills.repository.RelationshipSkillsUpdateCriteriaRepository;
import com.infinite.focus.server.relationshipskills.repository.RelationshipSkillsUpdateRepository;
import com.infinite.focus.server.relationshipskills.service.RelationshipSkillsUpdateService;
import com.infinite.focus.server.relationshipskills.wrapper.RelationshipSkillsUpdateDataSetWrapper;
import com.infinite.focus.server.relationshipskills.wrapper.RelationshipSkillsUpdateWrapper;
import com.infinite.focus.server.responsibledecisionmaking.model.AssessmentOccurrenceByStandards;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class RelationshipSkillsUpdateServiceImpl
implements RelationshipSkillsUpdateService {
    private final EntityManager entityManager;
    private final MessageService messageService;
    private final RelationshipSkillsUpdateRepository relationshipSkillsUpdateRepository;
    private final RelationshipSkillsUpdateCriteriaRepository relationshipSkillsUpdateCriteriaRepository;
    private final DataSetService dataService;
    private final RestComponent restComponent;

    public RelationshipSkillsUpdateServiceImpl(EntityManager entityManager, MessageService messageService, RelationshipSkillsUpdateRepository relationshipSkillsUpdateRepository, RelationshipSkillsUpdateCriteriaRepository relationshipSkillsUpdateCriteriaRepository, DataSetService dataService, RestComponent restComponent) {
        this.entityManager = entityManager;
        this.messageService = messageService;
        this.relationshipSkillsUpdateRepository = relationshipSkillsUpdateRepository;
        this.relationshipSkillsUpdateCriteriaRepository = relationshipSkillsUpdateCriteriaRepository;
        this.dataService = dataService;
        this.restComponent = restComponent;
    }

    public RelationshipSkillsUpdate createRelationshipSkillsUpdate(RelationshipSkillsUpdate relationshipSkillsUpdate) {
        if (relationshipSkillsUpdate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.relationship.skills.update.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)relationshipSkillsUpdate.getData_set_ids())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.ids.are.not.found"));
        }
        List<String> data_set_ids = Arrays.asList(relationshipSkillsUpdate.getData_set_ids().split("\\s*,\\s*"));
        if (AppUtils.isNullOrEmpty(data_set_ids) || data_set_ids.size() < 4) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("all.data.set.ids.are.not.found"));
        }
        DataSet dataSetCommunication = null;
        DataSet dataSetWorkingTogether = null;
        DataSet dataSetAskingForHelp = null;
        DataSet dataSetPeerPressure = null;
        for (String dataSetId : data_set_ids) {
            DataSet dataSet = this.dataService.getDataSetById(Long.parseLong(dataSetId));
            if (dataSet == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
            }
            AssessmentChildCategory assessmentChildCategory = dataSet.getAssessment_child_category();
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.COMMUNICATION)) {
                dataSetCommunication = dataSet;
                continue;
            }
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.WORKING_TOGETHER)) {
                dataSetWorkingTogether = dataSet;
                continue;
            }
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.ASK_FOR_HELP)) {
                dataSetAskingForHelp = dataSet;
                continue;
            }
            if (!assessmentChildCategory.equals((Object)AssessmentChildCategory.PEER_PRESSURE)) continue;
            dataSetPeerPressure = dataSet;
        }
        if (dataSetCommunication == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.communication.is.not.found"));
        }
        if (dataSetWorkingTogether == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.working.together.is.not.found"));
        }
        if (dataSetAskingForHelp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.asking.for.help.is.not.found"));
        }
        if (dataSetPeerPressure == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        relationshipSkillsUpdate.setData_set_ids(dataSetCommunication.getData_set_id() + "," + dataSetWorkingTogether.getData_set_id() + "," + dataSetAskingForHelp.getData_set_id() + "," + dataSetPeerPressure.getData_set_id());
        relationshipSkillsUpdate.setOriginal_scores(dataSetCommunication.getScore() + "," + dataSetWorkingTogether.getScore() + "," + dataSetAskingForHelp.getScore() + "," + dataSetPeerPressure.getScore());
        double score = dataSetCommunication.getScore() + dataSetWorkingTogether.getScore() + dataSetAskingForHelp.getScore() + dataSetPeerPressure.getScore();
        relationshipSkillsUpdate.setScore(score / 4.0);
        relationshipSkillsUpdate.setText(dataSetCommunication.getText_to_display() + "," + dataSetWorkingTogether.getText_to_display() + "," + dataSetAskingForHelp.getText_to_display() + "," + dataSetPeerPressure.getText_to_display());
        relationshipSkillsUpdate.setText_es(dataSetCommunication.getText_to_display_es() + "," + dataSetWorkingTogether.getText_to_display_es() + "," + dataSetAskingForHelp.getText_to_display_es() + "," + dataSetPeerPressure.getText_to_display_es());
        return (RelationshipSkillsUpdate)this.relationshipSkillsUpdateRepository.save((Object)relationshipSkillsUpdate);
    }

    public Page<RelationshipSkillsUpdateWrapper> getRelationshipSkillsUpdateLogByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.relationshipSkillsUpdateRepository.findByStudentId(student_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(log -> {
            List<String> texts_es;
            RelationshipSkillsUpdateWrapper wrapper = new RelationshipSkillsUpdateWrapper();
            RelationshipSkillsUpdateDataSetWrapper dataSetCommunication = new RelationshipSkillsUpdateDataSetWrapper();
            RelationshipSkillsUpdateDataSetWrapper dataSetWorkingTogether = new RelationshipSkillsUpdateDataSetWrapper();
            RelationshipSkillsUpdateDataSetWrapper dataSetAskingForHelp = new RelationshipSkillsUpdateDataSetWrapper();
            RelationshipSkillsUpdateDataSetWrapper dataSetPeerPressure = new RelationshipSkillsUpdateDataSetWrapper();
            List<String> data_set_ids = Arrays.asList(log.getData_set_ids().split("\\s*,\\s*"));
            for (String dataSetId : data_set_ids) {
                DataSet dataSet = this.dataService.getDataSetById(Long.parseLong(dataSetId));
                if (dataSet == null) {
                    throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
                }
                this.dataService.addDataSetImages(dataSet);
                AssessmentChildCategory assessmentChildCategory = dataSet.getAssessment_child_category();
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.COMMUNICATION)) {
                    dataSetCommunication.setData_set_id(dataSet.getData_set_id());
                    dataSetCommunication.setColor(dataSet.getColor());
                    dataSetCommunication.setImage(dataSet.getImage());
                    continue;
                }
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.WORKING_TOGETHER)) {
                    dataSetWorkingTogether.setData_set_id(dataSet.getData_set_id());
                    dataSetWorkingTogether.setColor(dataSet.getColor());
                    dataSetWorkingTogether.setImage(dataSet.getImage());
                    continue;
                }
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.ASK_FOR_HELP)) {
                    dataSetAskingForHelp.setData_set_id(dataSet.getData_set_id());
                    dataSetAskingForHelp.setColor(dataSet.getColor());
                    dataSetAskingForHelp.setImage(dataSet.getImage());
                    continue;
                }
                if (!assessmentChildCategory.equals((Object)AssessmentChildCategory.PEER_PRESSURE)) continue;
                dataSetPeerPressure.setData_set_id(dataSet.getData_set_id());
                dataSetPeerPressure.setColor(dataSet.getColor());
                dataSetPeerPressure.setImage(dataSet.getImage());
            }
            List<String> texts = Arrays.asList(log.getText().split("\\s*,\\s*"));
            if (AppUtils.isNotNullOrEmpty(texts) && texts.size() == 4) {
                dataSetCommunication.setText(texts.get(0));
                dataSetWorkingTogether.setText(texts.get(1));
                dataSetAskingForHelp.setText(texts.get(2));
                dataSetPeerPressure.setText(texts.get(3));
            }
            if (AppUtils.isNotNullOrEmpty(texts_es = Arrays.asList(log.getText_es().split("\\s*,\\s*"))) && texts_es.size() == 4) {
                dataSetCommunication.setText_es(texts.get(0));
                dataSetWorkingTogether.setText_es(texts.get(1));
                dataSetAskingForHelp.setText_es(texts.get(2));
                dataSetPeerPressure.setText_es(texts.get(3));
            }
            wrapper.setRelationship_skills_update_id(log.getRelationship_skills_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setCommunication(dataSetCommunication);
            wrapper.setWorking_together(dataSetWorkingTogether);
            wrapper.setAsking_for_help(dataSetAskingForHelp);
            wrapper.setPeer_pressure(dataSetPeerPressure);
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public RelationshipSkillsUpdate getRelationshipSkillsUpdateById(long relationship_skills_update_id) {
        return this.relationshipSkillsUpdateRepository.findByRelationshipSkillsUpdateId(relationship_skills_update_id);
    }

    public CategoryAndScore getCategoryAndScoreByRelationshipSkillsUpdateIdAndScore(long relationship_skills_update_id, double score) {
        RelationshipSkillsUpdate relationshipSkillsUpdate = this.getRelationshipSkillsUpdateById(relationship_skills_update_id);
        List<String> data_set_ids = Arrays.asList(relationshipSkillsUpdate.getData_set_ids().split("\\s*,\\s*"));
        CategoryDTO category = this.dataService.getCategoryByDataSetId(Long.parseLong(data_set_ids.get(0)));
        CategoryAndScore categoryAndScore = new CategoryAndScore();
        categoryAndScore.setCategory(category);
        categoryAndScore.setScore(score);
        return categoryAndScore;
    }

    public List<String[]> getTextList() {
        HashSet<Object[]> texts = new HashSet<Object[]>();
        for (Object[] commaSeparatedText : this.relationshipSkillsUpdateRepository.getTextList()) {
            List<String> list0 = Arrays.asList(((String)commaSeparatedText[0]).split("\\s*,\\s*"));
            List<String> list1 = Arrays.asList(((String)commaSeparatedText[1]).split("\\s*,\\s*"));
            for (int i = 0; i < list0.size(); ++i) {
                Object[] newItem = new String[]{list0.get(i), list1.get(i)};
                boolean contains = false;
                for (Object[] oldItem : texts) {
                    if (!Arrays.equals(oldItem, newItem)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                texts.add(newItem);
            }
        }
        return new ArrayList<String[]>(texts);
    }

    public List<String[]> getTextList(AssessmentChildCategory assessmentChildCategory) {
        List<Object> dataSetIdAndTexts = new ArrayList();
        for (Object[] item : this.relationshipSkillsUpdateRepository.getTextAndDataSetIdsList()) {
            Object dataSetIdAndText;
            boolean isContains;
            String string = (String)item[0];
            String commaSeparatedText_es = (String)item[1];
            String commaSeparatedDataSetIds = (String)item[2];
            List<String> textList = Arrays.asList(string.split("\\s*,\\s*"));
            List<String> list = Arrays.asList(commaSeparatedText_es.split("\\s*,\\s*"));
            List<String> idsList = Arrays.asList(commaSeparatedDataSetIds.split("\\s*,\\s*"));
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.COMMUNICATION)) {
                isContains = false;
                for (DataSetIdAndText dataSetIdAndText2 : dataSetIdAndTexts) {
                    if (!dataSetIdAndText2.getText().equalsIgnoreCase(textList.get(0))) continue;
                    isContains = true;
                    break;
                }
                if (!isContains) {
                    dataSetIdAndText = new DataSetIdAndText();
                    dataSetIdAndText.setId(Long.parseLong(idsList.get(0)));
                    dataSetIdAndText.setText(textList.get(0));
                    dataSetIdAndText.setText_es(list.get(0));
                    dataSetIdAndTexts.add(dataSetIdAndText);
                }
            }
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.WORKING_TOGETHER)) {
                isContains = false;
                for (DataSetIdAndText dataSetIdAndText3 : dataSetIdAndTexts) {
                    if (!dataSetIdAndText3.getText().equalsIgnoreCase(textList.get(1))) continue;
                    isContains = true;
                    break;
                }
                if (!isContains) {
                    dataSetIdAndText = new DataSetIdAndText();
                    dataSetIdAndText.setId(Long.parseLong(idsList.get(1)));
                    dataSetIdAndText.setText(textList.get(1));
                    dataSetIdAndText.setText_es(list.get(1));
                    dataSetIdAndTexts.add(dataSetIdAndText);
                }
            }
            if (assessmentChildCategory.equals((Object)AssessmentChildCategory.ASK_FOR_HELP)) {
                isContains = false;
                for (DataSetIdAndText dataSetIdAndText4 : dataSetIdAndTexts) {
                    if (!dataSetIdAndText4.getText().equalsIgnoreCase(textList.get(2))) continue;
                    isContains = true;
                    break;
                }
                if (!isContains) {
                    dataSetIdAndText = new DataSetIdAndText();
                    dataSetIdAndText.setId(Long.parseLong(idsList.get(2)));
                    dataSetIdAndText.setText(textList.get(2));
                    dataSetIdAndText.setText_es(list.get(2));
                    dataSetIdAndTexts.add(dataSetIdAndText);
                }
            }
            if (!assessmentChildCategory.equals((Object)AssessmentChildCategory.PEER_PRESSURE)) continue;
            isContains = false;
            for (DataSetIdAndText dataSetIdAndText5 : dataSetIdAndTexts) {
                if (!dataSetIdAndText5.getText().equalsIgnoreCase(textList.get(3))) continue;
                isContains = true;
                break;
            }
            if (isContains) continue;
            dataSetIdAndText = new DataSetIdAndText();
            dataSetIdAndText.setId(Long.parseLong(idsList.get(3)));
            dataSetIdAndText.setText(textList.get(3));
            dataSetIdAndText.setText_es(list.get(3));
            dataSetIdAndTexts.add(dataSetIdAndText);
        }
        dataSetIdAndTexts = dataSetIdAndTexts.stream().sorted(Comparator.comparing(DataSetIdAndText::getId)).collect(Collectors.toList());
        ArrayList<String[]> textList = new ArrayList<String[]>();
        for (DataSetIdAndText dataSetIdAndText : dataSetIdAndTexts) {
            System.out.println("DataSetIdAndText id: " + dataSetIdAndText.getId() + " text: " + dataSetIdAndText.getText());
            Object[] newItem = new String[]{dataSetIdAndText.getText(), dataSetIdAndText.getText_es()};
            boolean contains = false;
            for (Object[] objectArray : textList) {
                if (!Arrays.equals(objectArray, newItem)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            textList.add((String[])newItem);
        }
        return textList;
    }

    public List<RelationshipSkillsUpdate> findByStudentIdAndBetweenFromDateAndEndDate(long student_id, String fromDate, String toDate) {
        return this.relationshipSkillsUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(student_id, fromDate, toDate);
    }

    public List<RelationshipSkillsUpdateDTO> getRelationshipSkillsUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Object[].class);
        Root root = query.from(RelationshipSkillsUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<RelationshipSkillsUpdateDTO>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getRelationshipSkillsUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.multiselect(this.getRelationshipSkillsUpdateDTOSelection(root)).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List relationshipSkillsUpdateList = this.mapRelationshipSkillsUpdateObjectsToStudentDTOs(typedQuery);
        System.out.println("RelationshipSkillsUpdate Count = " + relationshipSkillsUpdateList.size());
        return relationshipSkillsUpdateList;
    }

    private List<Selection<?>> getRelationshipSkillsUpdateDTOSelection(Root<RelationshipSkillsUpdate> root) {
        ArrayList selectionList = new ArrayList();
        selectionList.add((Selection<?>)root.get("relationship_skills_update_id"));
        selectionList.add((Selection<?>)root.get("student_id"));
        selectionList.add((Selection<?>)root.get("text"));
        selectionList.add((Selection<?>)root.get("text_es"));
        return selectionList;
    }

    private List<RelationshipSkillsUpdateDTO> mapRelationshipSkillsUpdateObjectsToStudentDTOs(TypedQuery<Object[]> typedQuery) {
        List<RelationshipSkillsUpdateDTO> relationshipSkillsUpdateDTOS = typedQuery.getResultList().stream().map(item -> RelationshipSkillsUpdateDTO.builder().relationship_skills_update_id(((Long)item[0]).longValue()).student_id(((Long)item[1]).longValue()).text((String)item[2]).text_es((String)item[3]).standard_id(0L).score(0.0).build()).collect(Collectors.toList());
        return relationshipSkillsUpdateDTOS;
    }

    public List<RelationshipSkillsUpdate> getAllOrderByRelationshipSkillsUpdateId() {
        return this.relationshipSkillsUpdateRepository.getAllOrderByRelationshipSkillsUpdateId();
    }

    public RelationshipSkillsUpdate save(RelationshipSkillsUpdate relationshipSkillsUpdate) {
        return (RelationshipSkillsUpdate)this.relationshipSkillsUpdateRepository.save((Object)relationshipSkillsUpdate);
    }

    public AssessmentOccurrenceByStandards getByStudentIdsAndFromDateAndToDateAndAssessmentChildCategory(Set<Long> student_ids, Date fromDate, Date toDate, AssessmentChildCategory assessmentChildCategory) {
        List relationshipSkillsUpdateDTOS = this.relationshipSkillsUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, fromDate, toDate);
        AssessmentOccurrenceByStandards byStandards = AssessmentOccurrenceByStandards.builder()._3_5(new ArrayList(this.relationshipSkillsUpdateCriteriaRepository.getTextToDisplay2(assessmentChildCategory)))._6_12(new ArrayList(this.relationshipSkillsUpdateCriteriaRepository.getTextToDisplay2(assessmentChildCategory))).build();
        Set _3_5_standard_ids = this.restComponent.get3_5StandardIds();
        Set _6_12_standard_ids = this.restComponent.get6_12StandardIds();
        this.setRelationshipSkillsByStandard(student_ids, _3_5_standard_ids, byStandards.get_3_5(), relationshipSkillsUpdateDTOS, assessmentChildCategory);
        this.setRelationshipSkillsByStandard(student_ids, _6_12_standard_ids, byStandards.get_6_12(), relationshipSkillsUpdateDTOS, assessmentChildCategory);
        return byStandards;
    }

    public RelationshipSkillsUpdateDTO getById(long relationship_skills_update_id) {
        return this.relationshipSkillsUpdateCriteriaRepository.findById(relationship_skills_update_id);
    }

    public List<OccurrenceAndOccurrenceAverage> getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDateAndAssessmentChildCategory(Set<Long> student_ids, Date from_date, Date to_date, AssessmentChildCategory assessmentChildCategory) {
        List relationshipSkillsUpdateDTOS = this.relationshipSkillsUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        List occurrenceAndOccurrenceAverages = this.setRelationshipSkills(student_ids, this.relationshipSkillsUpdateCriteriaRepository.getTextToDisplay3(assessmentChildCategory), relationshipSkillsUpdateDTOS, assessmentChildCategory);
        return occurrenceAndOccurrenceAverages;
    }

    private void setRelationshipSkillsByStandard(Set<Long> student_ids, Set<Long> standardIds, List<AssessmentOccurrence> assessmentOccurrences, List<RelationshipSkillsUpdateDTO> responsibleDecisionMakingUpdateDTOS, AssessmentChildCategory assessmentChildCategory) {
        Set byStandards = responsibleDecisionMakingUpdateDTOS.stream().filter(r -> standardIds.contains(r.getStandard_id())).collect(Collectors.toSet());
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            for (RelationshipSkillsUpdateDTO dto : byStandards) {
                String text = dto.getText().split(",")[this.relationshipSkillsUpdateCriteriaRepository.getPosition(assessmentChildCategory) - 1];
                String text_es = dto.getText_es().split(",")[this.relationshipSkillsUpdateCriteriaRepository.getPosition(assessmentChildCategory) - 1];
                if (!text.equalsIgnoreCase(assessmentOccurrence.getText_to_display()) || !text_es.equalsIgnoreCase(assessmentOccurrence.getText_to_display_es())) continue;
                assessmentOccurrence.setOccurrence(assessmentOccurrence.getOccurrence() + 1L);
            }
            try {
                assessmentOccurrence.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)assessmentOccurrence.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            try {
                assessmentOccurrence.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)assessmentOccurrence.getOccurrence(), (Long)Long.valueOf(byStandards.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<OccurrenceAndOccurrenceAverage> setRelationshipSkills(Set<Long> student_ids, List<OccurrenceAndOccurrenceAverage> occurrenceAndOccurrenceAverages, List<RelationshipSkillsUpdateDTO> responsibleDecisionMakingUpdateDTOS, AssessmentChildCategory assessmentChildCategory) {
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            for (RelationshipSkillsUpdateDTO dto : responsibleDecisionMakingUpdateDTOS) {
                String text = dto.getText().split(",")[this.relationshipSkillsUpdateCriteriaRepository.getPosition(assessmentChildCategory) - 1];
                String text_es = dto.getText_es().split(",")[this.relationshipSkillsUpdateCriteriaRepository.getPosition(assessmentChildCategory) - 1];
                if (!text.equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display()) || !text_es.equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display_es())) continue;
                occurrenceAndOccurrenceAverage.setOccurrence(occurrenceAndOccurrenceAverage.getOccurrence() + 1L);
            }
            try {
                occurrenceAndOccurrenceAverage.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)occurrenceAndOccurrenceAverage.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            try {
                occurrenceAndOccurrenceAverage.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)occurrenceAndOccurrenceAverage.getOccurrence(), (Long)Long.valueOf(responsibleDecisionMakingUpdateDTOS.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return occurrenceAndOccurrenceAverages;
    }
}

