/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.content;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.content.StreakContentService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StreakContentServiceImpl
implements StreakContentService {
    private final PostRepository postRepository;
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final StreakHelper streakHelper;

    public StreakContentServiceImpl(PostRepository postRepository, StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, StreakHelper streakHelper) {
        this.postRepository = postRepository;
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.streakHelper = streakHelper;
    }

    public StreakDTO addStreakSELCurriculumArticle(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.SEL_CURRICULUM_ARTICLE);
    }

    public StreakDTO addStreakEnergizingExercises(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.ENERGIZING_EXERCISES);
    }

    public StreakDTO addStreakCopingCues(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.COPING_CUES);
    }

    public StreakDTO addStreakMindfulStretches(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFUL_STRETCHES);
    }

    public StreakDTO addStreakMindfulnessVideos(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.MINDFULNESS_VIDEOS);
    }

    public StreakDTO addStreakGrowthMindsets(Long student_id, List<Activity> activities) {
        return this.addStreakByStreakType(student_id.longValue(), activities, StreakType.GROWTH_MINDSETS);
    }

    private StreakDTO addStreakByStreakType(long student_id, List<Activity> activities, StreakType streakType) {
        Set posts;
        if (!AppUtils.isNullOrEmpty(activities) && !AppUtils.isNullOrEmpty(posts = activities.stream().map(activity -> this.postRepository.findById(activity.getEntity_id())).filter(post -> post.getContents().stream().filter(content -> content.getStreak_type().equals((Object)streakType)).findFirst().orElse(null) != null).map(PostDTO::getPost_id).collect(Collectors.toSet()))) {
            List streaks = this.streakRepository.findByStreakType(streakType.name());
            for (StreakDTO streak : streaks) {
                if (streak.getOccurrence() != posts.size() || this.studentStreakRepository.findByStudentIdAndStreakId(Long.valueOf(student_id), Long.valueOf(streak.getStreak_id())) != null) continue;
                return this.streakHelper.saveStudentStreak(student_id, streak);
            }
        }
        return null;
    }
}

