/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.repository;

import com.infinite.focus.server.activity.repository.ActivityCoreRepository;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityCoreRepositoryImpl
implements ActivityCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public ActivityCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<EmotionCountAndAverage> findMoodInsightsPostBeforeByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate, String language) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<EmotionCountAndAverage>();
        }
        long moodInsightsCount = this.findMoodInsightsPostCountByStudentIdsAndFromDateAndToDate(student_ids, fromDate, toDate);
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Comparable<Long>> args = new ArrayList<Comparable<Long>>();
        args.add(Long.valueOf(moodInsightsCount));
        args.addAll(student_ids);
        args.add(new Timestamp(fromDate.getTime()));
        args.add(new Timestamp(toDate.getTime()));
        String SQL_BEFORE = "SELECT ac.mood_update_before AS emotion, count(*) AS count, COALESCE(ROUND((count(*) / ?) * 100, 2), 0.00) AS average FROM activity ac JOIN student st ON ac.student_id = st.student_id WHERE ac.activity_type_id = 4 AND st.student_id IN(%S) AND ac.start_date_time BETWEEN ? AND ? GROUP BY ac.mood_update_before ";
        List emotionCountAndAveragesBefore = this.jdbcTemplate.query(String.format(SQL_BEFORE, inSql), args.toArray(), (rs, i) -> EmotionCountAndAverage.builder().emotion(rs.getString("emotion")).count(rs.getLong("count")).average(rs.getDouble("average")).emotion_id(0L).build());
        return emotionCountAndAveragesBefore;
    }

    public List<EmotionCountAndAverage> findMoodInsightsPostAfterByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate, String language) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<EmotionCountAndAverage>();
        }
        long moodInsightsCount = this.findMoodInsightsPostCountByStudentIdsAndFromDateAndToDate(student_ids, fromDate, toDate);
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Comparable<Long>> args = new ArrayList<Comparable<Long>>();
        args.add(Long.valueOf(moodInsightsCount));
        args.addAll(student_ids);
        args.add(new Timestamp(fromDate.getTime()));
        args.add(new Timestamp(toDate.getTime()));
        String SQL_AFTER = "SELECT ac.mood_update_after AS emotion, count(*) AS count, COALESCE(ROUND((count(*) / ?) * 100, 2), 0.00) AS average FROM activity ac JOIN student st ON ac.student_id = st.student_id WHERE ac.activity_type_id = 4 AND st.student_id IN(%S) AND ac.start_date_time BETWEEN ? AND ? GROUP BY ac.mood_update_after ";
        List emotionCountAndAveragesAfter = this.jdbcTemplate.query(String.format(SQL_AFTER, inSql), args.toArray(), (rs, i) -> EmotionCountAndAverage.builder().emotion(rs.getString("emotion")).count(rs.getLong("count")).average(rs.getDouble("average")).emotion_id(0L).build());
        return emotionCountAndAveragesAfter;
    }

    public long findMoodInsightsPostCountByStudentIdsAndFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0L;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String SQL = "SELECT COUNT(*) AS activities_count FROM activity ac JOIN student st ON ac.student_id = st.student_id WHERE ac.activity_type_id = 4 AND st.student_id IN(%S) AND ac.start_date_time BETWEEN ? AND ? ";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(String.format(SQL, inSql), args.toArray(), (rs, rowNum) -> rs.getInt(1));
        return count == null ? 0L : count.longValue();
    }
}

