/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.repository;

import com.infinite.focus.server.notification.entity.Notification;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface NotificationRepository
extends JpaRepository<Notification, Long> {
    @Query(value="SELECT * FROM notification WHERE notification_id = ?1 ", nativeQuery=true)
    public Notification findById(long var1);

    @Query(value="SELECT * FROM notification WHERE instructor_id = ?1 ORDER BY created_at DESC", nativeQuery=true)
    public List<Notification> findByInstructorId(Long var1);

    @Query(value="SELECT COUNT(*) FROM notification WHERE instructor_id = ?1 AND viewed_instructor = ?2 ORDER BY created_at DESC", nativeQuery=true)
    public long getCountByInstructorId(Long var1, Boolean var2);

    @Query(value="SELECT COUNT(*) FROM notification WHERE parent_id = ?1 AND viewed_parent = ?2 ORDER BY created_at DESC", nativeQuery=true)
    public long getCountByParentId(Long var1, Boolean var2);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM notification WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM notification WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM notification", nativeQuery=true)
    public Page<Notification> findAllNotifications(Pageable var1);

    @Query(value="SELECT * FROM notification WHERE instructor_id = ?1", nativeQuery=true)
    public Page<Notification> findByNotificationsByInstructorId(Long var1, Pageable var2);
}

