/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpost.component;

import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.utils.AppUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WallPostBadWordFilterComponent {
    private Map<String, String[]> words = new HashMap();
    private Map<String, String> words2 = new HashMap();
    private int largestWordLength = 0;
    private final ConfigurationService configurationService;

    public WallPostBadWordFilterComponent(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.loadConfigs();
    }

    public void loadConfigs() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.configurationService.getConfiguration().getBad_words_file()).openConnection().getInputStream()));
            String line = "";
            int counter = 0;
            while ((line = reader.readLine()) != null) {
                ++counter;
                String[] content = null;
                try {
                    content = line.split(",");
                    if (content.length == 0) continue;
                    String word = content[0];
                    String[] ignore_in_combination_with_words = new String[]{};
                    if (content.length > 1) {
                        ignore_in_combination_with_words = content[1].split("_");
                    }
                    if (word.length() > this.largestWordLength) {
                        this.largestWordLength = word.length();
                    }
                    this.words.put(word.replaceAll(" ", ""), ignore_in_combination_with_words);
                    this.words2.put(word.replaceAll(" ", ""), word);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Loaded " + counter + " words to filter out");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> badWordsFound(String input) {
        if (input == null) {
            return new ArrayList<String>();
        }
        input = input.replaceAll("1", "i");
        input = input.replaceAll("!", "i");
        input = input.replaceAll("3", "e");
        input = input.replaceAll("4", "a");
        input = input.replaceAll("@", "a");
        input = input.replaceAll("5", "s");
        input = input.replaceAll("7", "t");
        input = input.replaceAll("0", "o");
        input = input.replaceAll("9", "g");
        ArrayList<String> badWords = new ArrayList<String>();
        input = input.toLowerCase().replaceAll("[^a-zA-Z]", "");
        for (int start = 0; start < input.length(); ++start) {
            for (int offset = 1; offset < input.length() + 1 - start && offset < this.largestWordLength; ++offset) {
                String wordToCheck = input.substring(start, start + offset);
                if (!this.words.containsKey(wordToCheck)) continue;
                String[] ignoreCheck = (String[])this.words.get(wordToCheck);
                boolean ignore = false;
                for (int s = 0; s < ignoreCheck.length; ++s) {
                    if (!input.contains(ignoreCheck[s])) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                badWords.add(wordToCheck);
            }
        }
        for (String s : badWords) {
            System.out.println(s + " qualified as a bad word in a username");
        }
        return badWords;
    }

    public String filterText(String input, String username) {
        ArrayList badWords = this.badWordsFound(input);
        if (badWords.size() > 0) {
            return "This message was blocked because a bad word was found. If you believe this word should not be blocked, please message support.";
        }
        return input;
    }

    public Boolean isThereAnyBadWordInText(String input) {
        if (AppUtils.isNullOrEmpty((String)input)) {
            return false;
        }
        int size = this.badWordsFoundCompareWordsOnly(input.trim()).size() + this.badWordsFoundCompareWordsOnly2(input.trim()).size();
        return size > 0;
    }

    public ArrayList<String> badWordsFoundCompareWordsOnly(String input) {
        if (AppUtils.isNullOrEmpty((String)input)) {
            return new ArrayList<String>();
        }
        input = input.replaceAll("1", "i");
        input = input.replaceAll("!", "i");
        input = input.replaceAll("3", "e");
        input = input.replaceAll("4", "a");
        input = input.replaceAll("@", "a");
        input = input.replaceAll("5", "s");
        input = input.replaceAll("7", "t");
        input = input.replaceAll("0", "o");
        input = input.replaceAll("9", "g");
        ArrayList<String> badWords = new ArrayList<String>();
        String[] strSplit = input.split(" ");
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(strSplit));
        for (String s : strList) {
            if (!this.words.containsKey(s = s.replaceAll("[&\\/\\\\#,+()$~%!.\u201e'\":*\u201a^_\u00a4?<>|@\u00aa{\u00ab\u00bb\u00a7}\u00a9\u00ae\u2122 ]", "").toLowerCase(Locale.getDefault()))) continue;
            badWords.add(s);
        }
        return badWords;
    }

    public ArrayList<String> badWordsFoundCompareWordsOnly2(String input) {
        if (AppUtils.isNullOrEmpty((String)input)) {
            return new ArrayList<String>();
        }
        input = input.replaceAll("1", "i");
        input = input.replaceAll("!", "i");
        input = input.replaceAll("3", "e");
        input = input.replaceAll("4", "a");
        input = input.replaceAll("@", "a");
        input = input.replaceAll("5", "s");
        input = input.replaceAll("7", "t");
        input = input.replaceAll("0", "o");
        input = input.replaceAll("9", "g");
        ArrayList<String> badWords = new ArrayList<String>();
        String inputWithSpace = input;
        input = StringUtils.deleteWhitespace((String)input.toLowerCase());
        block0: for (String key : this.words2.keySet()) {
            if (AppUtils.isNullOrEmpty((String)input) || AppUtils.isNullOrEmpty((String)key) || !input.contains(key.toLowerCase(Locale.getDefault()))) continue;
            String sentence = (String)this.words2.get(key);
            String[] wordsInKey = sentence.split("\\s+");
            if (wordsInKey.length == 1) {
                String[] parts;
                for (String part : parts = inputWithSpace.split(" ")) {
                    if (!part.toLowerCase(Locale.getDefault()).equals(sentence.toLowerCase(Locale.getDefault()))) continue;
                    badWords.add(sentence);
                    continue block0;
                }
                continue;
            }
            badWords.add(sentence);
        }
        return badWords;
    }
}

