/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.repository;

import com.infinite.focus.server.activity.entity.Activity;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import javax.persistence.Tuple;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface ActivityRepository
extends JpaRepository<Activity, Long> {
    @Query(value="SELECT entity_id AS id, COUNT(*) AS count FROM activity WHERE activity_type_id = 2 AND student_id != 0 GROUP BY entity_id ORDER BY count DESC", nativeQuery=true)
    public List<Object[]> getVideoViewListOrderByCountDesc();

    @Query(value="SELECT entity_id AS id, COUNT(*) AS count FROM activity WHERE activity_type_id = 2 AND student_id != 0 GROUP BY entity_id ORDER BY count ASC", nativeQuery=true)
    public List<Object[]> getVideoViewListOrderByCountASC();

    @Query(value="SELECT le.lesson_id, COALESCE((SELECT COUNT(*) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count DESC),0) AS count, concat(round(COALESCE((((SELECT COUNT(*) AS count FROM activity a LEFT JOIN lesson l ON a.entity_id = l.lesson_id WHERE a.entity_id = le.lesson_id AND a.activity_type_id = 2 AND a.student_id != 0 AND a.watch_duration >= l.video_duration GROUP BY a.entity_id ORDER BY count DESC) / COUNT(*)) * 100),0),2),'%') AS total_watch, COALESCE((SELECT SUM(a.watch_duration * 1000) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count DESC),0) AS time, COALESCE((SELECT (SUM(a.watch_duration * 1000)/ COUNT(*)) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count DESC),0) AS avg_time FROM lesson le LEFT JOIN activity act ON le.lesson_id = act.entity_id GROUP BY le.lesson_id ORDER BY count DESC", nativeQuery=true)
    public List<Object[]> getVideoViewListOrderByCountAndFullWatchedPercentageDesc();

    @Query(value="SELECT le.lesson_id, COALESCE((SELECT COUNT(*) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count ASC),0) AS count, concat(round(COALESCE((((SELECT COUNT(*) AS count FROM activity a LEFT JOIN lesson l ON a.entity_id = l.lesson_id WHERE a.entity_id = le.lesson_id AND a.activity_type_id = 2 AND a.student_id != 0 AND a.watch_duration >= l.video_duration GROUP BY a.entity_id ORDER BY count ASC) / COUNT(*)) * 100),0),2),'%') AS total_watch, COALESCE((SELECT SUM(a.watch_duration * 1000) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count ASC),0) AS time, COALESCE((SELECT (SUM(a.watch_duration * 1000)/ COUNT(*)) AS count FROM activity a WHERE a.activity_type_id = 2 AND a.student_id != 0 AND a.entity_id = le.lesson_id GROUP BY a.entity_id ORDER BY count ASC),0) AS avg_time FROM lesson le LEFT JOIN activity act ON le.lesson_id = act.entity_id GROUP BY le.lesson_id ORDER BY count ASC", nativeQuery=true)
    public List<Object[]> getVideoViewListOrderByCountAndFullWatchedPercentageASC();

    @Query(value="SELECT COUNT(DISTINCT a.student_id) FROM activity a where activity_type_id = 2 AND student_id != 0 AND a.entity_id = ?1", nativeQuery=true)
    public Long getCountOfStudentsWhoWatchedVideoByEnitityId(Long var1);

    @Query(value="select a.student_id as repeate_count from activity a where activity_type_id = 2 AND student_id != 0 AND a.entity_id = ?1 group by a.student_id having count(a.student_id) > 1", nativeQuery=true)
    public List<Long> getRepeteVideoWatchStudentIdListByEntityId(Long var1);

    @Query(value="SELECT * FROM activity act WHERE act.activity_type_id = 2 AND act.student_id != 0", nativeQuery=true)
    public List<Activity> getAllVideoActivities();

    @Query(value="SELECT TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time) AS seconds FROM activity act WHERE activity_type_id = 2 AND act.activity_id = ?1", nativeQuery=true)
    public Long getDifferenceBetweenStartDateTimeAndEndDateTimeInSecondsByActivityId(Long var1);

    @Query(value="SELECT * FROM activity act ORDER BY activity_id DESC LIMIT 0,1", nativeQuery=true)
    public Activity getLstCreatedActivity();

    @Query(value="SELECT activity_id FROM activity act ORDER BY activity_id DESC LIMIT 0,1", nativeQuery=true)
    public long getLastRecordId();

    @Query(value="SELECT COUNT(*) as view_count, COALESCE(SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)),0) AS total_time_in_seconds, COALESCE(SEC_TO_TIME((SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)))), 'N/A') AS total_time_in_string, COALESCE(SEC_TO_TIME(ROUND(( SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)) ))), 'N/A') AS average_time_in_string FROM activity act WHERE act.activity_type_id = ?1 AND act.entity_id = ?2", nativeQuery=true)
    public List<Object[]> getAllActivitiesByActivityTypeIdAndEntityId(Long var1, Long var2);

    @Query(value="SELECT COUNT(*) as view_count, COALESCE(SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)),0) AS total_time_in_seconds, COALESCE(SEC_TO_TIME((SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)))), 'N/A') AS total_time_in_string, COALESCE(SEC_TO_TIME(ROUND(( SUM(TIMESTAMPDIFF(SECOND, act.start_date_time, act.end_date_time)) ))), 'N/A') AS average_time_in_string FROM activity act WHERE act.activity_type_id = ?1 AND act.entity_id = ?2 AND act.start_date_time BETWEEN ?3 AND ?4", nativeQuery=true)
    public List<Object[]> getAllActivitiesByActivityTypeIdAndEntityIdAndBetweenFromDateAndToDate(Long var1, Long var2, String var3, String var4);

    @Query(value="SELECT DISTINCT(student_id) FROM activity act WHERE act.activity_type_id = 1 AND act.student_id IN(?1) AND act.start_date_time BETWEEN ?2 AND ?3 AND TIME(CONVERT_TZ(act.start_date_time, ?4, ?5)) BETWEEN TIME(CONVERT_TZ(?2, ?4, ?5)) AND TIME(CONVERT_TZ(?3, ?4, ?5))", nativeQuery=true)
    public List<BigInteger> getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(List<Long> var1, String var2, String var3, String var4, String var5);

    @Query(value="SELECT * FROM activity WHERE student_id = ?1 ORDER BY activity_id ASC", nativeQuery=true)
    public List<Activity> findByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM activity WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM activity WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM activity WHERE activity_type_id = ?1 AND student_id = ?2 ORDER BY activity_id ASC", nativeQuery=true)
    public List<Activity> findByActivityTypeIdAndStudentIdOrderByActivityIdASC(long var1, long var3);

    @Query(value="SELECT * FROM activity WHERE activity_type_id = ?1 AND instructor_id = ?2 ORDER BY start_date_time DESC LIMIT 0,1", nativeQuery=true)
    public Activity findLastByActivityTypeIdAndInstructorIdOrderByStartDateTimeDESC(long var1, long var3);

    @Query(value="SELECT * FROM activity WHERE activity_type_id = ?1 AND student_id = ?2 AND start_date_time BETWEEN ?3 AND ?4 ORDER BY activity_id ASC", nativeQuery=true)
    public List<Activity> findByActivityTypeIdAndStudentIdAndBetweenFromDateAndToDateOrderByActivityIdASC(long var1, long var3, String var5, String var6);

    @Query(value="CALL PAGE_PERFORMANCE_ANALYTICS(?1, ?2, ?3)", nativeQuery=true)
    public List<Tuple> PAGE_PERFORMANCE_ANALYTICS(long var1, Date var3, Date var4);
}

