/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.badge.service;

import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.badge.repository.BadgeRepository;
import com.infinite.focus.server.badge.service.BadgeService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class BadgeServiceImpl
implements BadgeService {
    @Autowired
    BadgeRepository badgeRepository;

    public List<Badge> getBadgesOrderByBadgeIdAsc() {
        return this.badgeRepository.findAllBadgesOrderByBadgeIdAsc();
    }

    public Page<Badge> getBadges(String title, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = AppUtils.isNullOrEmpty((String)title) ? this.badgeRepository.findAllBadges((Pageable)paging) : this.badgeRepository.findByTitle(title, (Pageable)paging);
        return pagedResult;
    }

    public Badge createBadge(String image, String title, String title_es, String description, String description_es, boolean should_show_on_front) {
        Badge badge = new Badge();
        badge.setImage(image);
        badge.setTitle(title);
        badge.setTitle_es(title_es);
        badge.setDescription(description);
        badge.setDescription_es(description_es);
        badge.setShould_show_on_front(should_show_on_front);
        return (Badge)this.badgeRepository.save((Object)badge);
    }
}

