/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.parent;

import com.infinite.focus.server.clever.model.CleverParent;
import com.infinite.focus.server.clever.model.CleverParentWrapper;
import com.infinite.focus.server.clever.response.GetCleverParentsResponse;
import com.infinite.focus.server.clever.response.GetParentByIdResponse;
import com.infinite.focus.server.clever.service.parent.CleverParentApiService;
import com.infinite.focus.server.clever.service.parent.CleverParentService;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverParentServiceImpl
implements CleverParentService {
    private CleverParentApiService service;

    public CleverParentServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.clever.com/v3.0/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverParentApiService)retrofit.create(CleverParentApiService.class);
    }

    public Set<CleverParent> getCleverParents(String access_token) {
        try {
            Call getCleverParentsResponseCall = this.service.getCleverParents("Bearer " + access_token, "contact");
            Response response = getCleverParentsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverParentsResponse)response.body()).getData() != null) {
                return ((GetCleverParentsResponse)response.body()).getData().stream().map(CleverParentWrapper::getData).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CleverParent getCleverParentById(String access_token, String id) {
        try {
            Call getParentByIdResponseCall = this.service.getCleverParentById("Bearer " + access_token, id);
            Response response = getParentByIdResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetParentByIdResponse)response.body()).getData() != null) {
                return ((GetParentByIdResponse)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

