/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.cronjob;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.clever.request.SyncAllRequest;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.corporatenotification.service.CorporateNotificationService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructorsurveychoice.service.InstructorSurveyChoiceService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.largeorganizationsurveychoice.service.LargeOrganizationSurveyChoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationsurveychoice.service.OrganizationSurveyChoiceService;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.quote.entity.Quote;
import com.infinite.focus.server.quote.repository.QuoteRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentstreak.service.duration.StreakDurationService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.toppicks.entity.TopPicks;
import com.infinite.focus.server.toppicks.repository.TopPicksRepository;
import com.infinite.focus.server.unsubscribe.model.UnsubscribeType;
import com.infinite.focus.server.unsubscribe.service.UnsubscribeService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.wallpost.component.WallPostBadWordFilterComponent;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.repository.WallPostRepository;
import com.infinite.focus.server.wallpostrequest.entity.WallPostRequest;
import com.infinite.focus.server.wallpostrequest.request.WallPostRequestRepository;
import com.infinite.focus.server.youthsurveychoice.service.YouthSurveyChoiceService;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTasks {
    private final RestComponent restComponent;
    private final QuoteRepository qouteRepository;
    private final TopPicksRepository topPicksRepository;
    private final CorporateService corporateService;
    private final CorporateNotificationService corporateNotificationService;
    private final ParentService parentService;
    private final MessageService messageService;
    private final StudentRepository studentRepository;
    private final InstructorRepository instructorRepository;
    private final ActivityRepository activityRepository;
    private final StreakDurationService streakDurationService;
    private final ValidationService validationService;
    private final EmailSenderService emailSenderService;
    private final TemplateService templateService;
    private final WallPostRepository wallPostRepository;
    private final WallPostRequestRepository wallPostRequestRepository;
    private final UnsubscribeService unsubscribeService;
    private final WallPostBadWordFilterComponent badWordFilterComponent;
    private final YouthSurveyChoiceService youthSurveyChoiceService;
    private final InstructorSurveyChoiceService instructorSurveyChoiceService;
    private final OrganizationSurveyChoiceService organizationSurveyChoiceService;
    private final LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService;
    private final AccountRepository accountRepository;
    private final StudentCoreRepository studentCoreRepository;
    private final SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;

    public ScheduledTasks(RestComponent restComponent, QuoteRepository qouteRepository, TopPicksRepository topPicksRepository, ParentService parentService, CorporateService corporateService, MessageService messageService, CorporateNotificationService corporateNotificationService, StudentRepository studentRepository, StreakDurationService streakDurationService, ValidationService validationService, InstructorRepository instructorRepository, ActivityRepository activityRepository, EmailSenderService emailSenderService, TemplateService templateService, WallPostRepository wallPostRepository, WallPostRequestRepository wallPostRequestRepository, UnsubscribeService unsubscribeService, WallPostBadWordFilterComponent badWordFilterComponent, YouthSurveyChoiceService youthSurveyChoiceService, InstructorSurveyChoiceService instructorSurveyChoiceService, OrganizationSurveyChoiceService organizationSurveyChoiceService, LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService, AccountRepository accountRepository, StudentCoreRepository studentCoreRepository, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository) {
        this.restComponent = restComponent;
        this.qouteRepository = qouteRepository;
        this.topPicksRepository = topPicksRepository;
        this.parentService = parentService;
        this.corporateService = corporateService;
        this.messageService = messageService;
        this.corporateNotificationService = corporateNotificationService;
        this.studentRepository = studentRepository;
        this.streakDurationService = streakDurationService;
        this.validationService = validationService;
        this.instructorRepository = instructorRepository;
        this.activityRepository = activityRepository;
        this.emailSenderService = emailSenderService;
        this.templateService = templateService;
        this.wallPostRepository = wallPostRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.unsubscribeService = unsubscribeService;
        this.badWordFilterComponent = badWordFilterComponent;
        this.youthSurveyChoiceService = youthSurveyChoiceService;
        this.instructorSurveyChoiceService = instructorSurveyChoiceService;
        this.organizationSurveyChoiceService = organizationSurveyChoiceService;
        this.largeOrganizationSurveyChoiceService = largeOrganizationSurveyChoiceService;
        this.accountRepository = accountRepository;
        this.studentCoreRepository = studentCoreRepository;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
    }

    @Scheduled(fixedRate=86400000L)
    public void reportCurrentTime() {
        this.setDailyQuoteRandamly();
        this.setDailyTopPicksRandamly();
    }

    private void setDailyQuoteRandamly() {
        List quotes = this.qouteRepository.findAll();
        if (AppUtils.isNotNullOrEmpty((List)quotes)) {
            for (Quote q : quotes) {
                q.setIsDailyQuote(Boolean.valueOf(false));
                this.qouteRepository.save((Object)q);
            }
            Random randomizer = new Random();
            int random_index = randomizer.nextInt(quotes.size());
            Quote random = (Quote)quotes.get(random_index);
            random.setIsDailyQuote(Boolean.valueOf(true));
            this.qouteRepository.save((Object)random);
        }
    }

    private void setDailyTopPicksRandamly() {
        List topPicksList = this.topPicksRepository.findAll();
        if (AppUtils.isNotNullOrEmpty((List)topPicksList)) {
            for (TopPicks topPicks : topPicksList) {
                topPicks.setCreatedAt(topPicks.getCreatedAt());
                topPicks.setUpdateAt(new Date());
                topPicks.setIsDailyTopPicks(Boolean.valueOf(false));
                this.topPicksRepository.save((Object)topPicks);
            }
            Random randomizerTopPicks = new Random();
            int random_index_topPicks = randomizerTopPicks.nextInt(topPicksList.size());
            TopPicks random_topPicks = (TopPicks)topPicksList.get(random_index_topPicks);
            random_topPicks.setCreatedAt(random_topPicks.getCreatedAt());
            random_topPicks.setIsDailyTopPicks(Boolean.valueOf(true));
            random_topPicks.setUpdateAt(new Date());
            this.topPicksRepository.save((Object)random_topPicks);
        }
    }

    @Scheduled(cron="0 0 11 * * ?")
    public void cronJobSch() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date now = new Date();
        String strDate = sdf.format(now);
        System.out.println("Java cron job expression:: " + strDate);
        this.parentService.sendEmailToParentDidNotAcceptChildProfile();
    }

    @Scheduled(cron="0 30 11 * * ?")
    public void sendRemindersToInstructorsAboutWOWAfterNotBeingApprovedAfterOneWeekAndInstructorsWhoDoNotLoginAfterTwoDays() {
        Set instructors = this.instructorRepository.findAllOrderByInstructorIdASC().stream().filter(instructor -> {
            try {
                return instructor.getAccount() != null && this.validationService.isValidInstructor(instructor.getInstructor_id()).isValid();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }).collect(Collectors.toSet());
        List wallPostRequests = this.wallPostRequestRepository.findAll();
        Set instructorIds = wallPostRequests.stream().map(WallPostRequest::getInstructor_id).collect(Collectors.toSet());
        Iterator iterator = instructorIds.iterator();
        while (iterator.hasNext()) {
            long instructorId = (Long)iterator.next();
            try {
                Instructor instructor2 = instructors.stream().filter(item -> item.getInstructor_id() == instructorId).findFirst().orElse(null);
                if (instructor2 == null || instructor2.getAccount() == null || AppUtils.isNullOrEmpty((String)instructor2.getAccount().getUsername()) || this.unsubscribeService.getByEmailAddressAndUnsubscribeType(instructor2.getAccount().getUsername(), UnsubscribeType.WOW_AFTER_NOT_BEING_APPROVED_AFTER_ONE_WEEK.getNumericValue()) != null) continue;
                List wallPostRequestsByInstructor = wallPostRequests.stream().filter(wallPostRequest -> wallPostRequest.getInstructor_id() == instructor2.getInstructor_id()).collect(Collectors.toList());
                long count = 0L;
                for (WallPostRequest wallPostRequest2 : wallPostRequestsByInstructor) {
                    long weeksCount;
                    WallPost wallPost = this.wallPostRepository.findByWallPostId(wallPostRequest2.getWall_post_id());
                    if (wallPost == null || this.badWordFilterComponent.isThereAnyBadWordInText(wallPost.getText()).booleanValue() || (weeksCount = DateUtils.getWeeksCountBetweenFromDateAndToDate((Date)wallPost.getCreatedAt(), (Date)new Date())) <= 1L) continue;
                    ++count;
                }
                System.out.println("Details of Instructor: " + instructor2.getInstructor_id() + " " + instructor2.getFirst_name() + "  Post Count: " + count);
                if (count <= 0L) continue;
                try {
                    this.emailSenderService.sendHtmlMail(instructor2.getAccount().getUsername(), count + " WoW " + (count == 1L ? (Language.isSpanish((String)instructor2.getLanguage()) ? "Publicar en" : "Post") : (Language.isSpanish((String)instructor2.getLanguage()) ? "Puestos" : "Posts")) + (Language.isSpanish((String)instructor2.getLanguage()) ? " Pendiente de aprobaci\u00f3n." : " Pending Approval!"), this.templateService.getWoWPostOrPostsPendingApproval(instructor2.getAccount().getUsername(), instructor2.getFirst_name(), count, instructor2.getLanguage()));
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Instructor instructor3 : instructors) {
            try {
                Activity activity;
                if (instructor3 == null || instructor3.getAccount() == null || AppUtils.isNullOrEmpty((String)instructor3.getAccount().getUsername()) || this.unsubscribeService.getByEmailAddressAndUnsubscribeType(instructor3.getAccount().getUsername(), UnsubscribeType.DID_NOT_LOGIN_AFTER_TWO_DAYS.getNumericValue()) != null || (activity = this.activityRepository.findLastByActivityTypeIdAndInstructorIdOrderByStartDateTimeDESC(1L, instructor3.getInstructor_id())) == null) continue;
                long countBusinessDaysAfterLastLogin = DateUtils.countBusinessDaysBetween((Date)activity.getStart_date_time(), (Date)new Date());
                System.out.println(DateUtils.setTimeToFromDate((Date)activity.getStart_date_time()) + " " + DateUtils.setTimeToToDate((Date)new Date()) + " Count: " + countBusinessDaysAfterLastLogin);
                if (countBusinessDaysAfterLastLogin < 2L) continue;
                try {
                    this.emailSenderService.sendHtmlMail(instructor3.getAccount().getUsername(), Language.isSpanish((String)instructor3.getLanguage()) ? "\u00a1Te echo de menos en Clymb!" : "Missing you on Clymb!", this.templateService.getMissingYouOnClymb(instructor3.getAccount().getUsername(), instructor3.getFirst_name(), instructor3.getLanguage()));
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Scheduled(cron="0 30 11 * * ?")
    public void cronJobSchStreakDuration() {
        List students = this.studentRepository.findAllOrderByIdAsc();
        if (!AppUtils.isNullOrEmpty((List)students)) {
            try {
                for (StudentView student : students) {
                    try {
                        Account account;
                        ValidationResponse validationResponse = this.validationService.isValidStudent(student.getStudent_id().longValue());
                        if (!validationResponse.isValid() || (account = this.accountRepository.findByAccountId(student.getAccount_id().longValue())) == null || account.getCreatedAt() == null) continue;
                        this.streakDurationService.addStreakDays(student);
                        this.streakDurationService.addStreakWeek(student);
                        this.streakDurationService.addStreakMonth(student);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Scheduled(cron="0 0 9 * * ?")
    public void cronJobCorporateNotification() {
        TheDailyClymbRequest theDailyClymbRequest = new TheDailyClymbRequest();
        theDailyClymbRequest.setToday(ZonedDateTime.now());
        HashMap<Long, Long> corporate_ids_and_account_ids = new HashMap<Long, Long>();
        for (Corporate corporate : this.corporateService.getCorporates()) {
            if (!this.corporateService.theDailyClymb(corporate, theDailyClymbRequest).isHalfOfTheClymbersHaveReachedHappinessAltitude()) continue;
            corporate_ids_and_account_ids.put(corporate.getCorporate_id(), corporate.getAccount_id());
        }
        if (!corporate_ids_and_account_ids.isEmpty()) {
            this.corporateNotificationService.addNotificationByCorporateId(corporate_ids_and_account_ids, this.messageService.getMessage().getHave_reached_happiness_altitude(), this.messageService.getMessage().getHave_reached_happiness_altitude_es());
        }
    }

    @Scheduled(cron="0 30 11 * * ?")
    public void assignSurvey() {
        try {
            this.youthSurveyChoiceService.assignSurveyToYouth(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.instructorSurveyChoiceService.assignSurveyToInstructor(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.organizationSurveyChoiceService.assignSurveyToOrganization(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.largeOrganizationSurveyChoiceService.assignSurveyToLargeOrganization(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Scheduled(cron="0 0 5 * * ?")
    public void cleverSync() {
        this.restComponent.cleverSyncAll(SyncAllRequest.builder().build());
    }

    @Scheduled(cron="0 0 4 * * ?")
    public void is30DaysPassedToLastSocioEmotionalTest() {
        Date today = new Date();
        List student_ids = this.studentCoreRepository.findAllWhoCanGiveSocioEmotionalTest();
        if (!AppUtils.isNullOrEmpty((List)student_ids)) {
            List ids = student_ids.stream().map(arg_0 -> ((SocioEmotionalTestResultRepository)this.socioEmotionalTestResultRepository).getLastSubmitedSocioEmotionalTestByStudentId(arg_0)).filter(Objects::nonNull).filter(s -> DateUtils.countDaysBetweenFromDateAndToDate((Date)s.getCreatedAt(), (Date)today) >= 30L).map(SocioEmotionalTestResult::getStudent_id).collect(Collectors.toList());
            if (!AppUtils.isNullOrEmpty(ids)) {
                this.studentCoreRepository.setShouldAutoShowAssessmentAndShouldForceSocioEmotionalAssessment(ids, true, true);
            }
        }
    }
}

