/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.logging.helper.LoggingHelper;
import com.infinite.focus.server.logging.service.LoggingService;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class RequestBodyInterceptor
extends RequestBodyAdviceAdapter {
    private final LoggingService loggingService;
    private final HttpServletRequest httpServletRequest;
    private final ObjectMapper objectMapper;

    public RequestBodyInterceptor(LoggingService loggingService, HttpServletRequest httpServletRequest, ObjectMapper objectMapper) {
        this.loggingService = loggingService;
        this.httpServletRequest = httpServletRequest;
        this.objectMapper = objectMapper;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        this.displayReq(this.httpServletRequest, body);
        return super.afterBodyRead(body, inputMessage, parameter, targetType, converterType);
    }

    public boolean supports(MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public void displayReq(HttpServletRequest request, Object body) {
        String requestBody;
        String url = request.getRequestURI();
        String authorization = request.getHeader("Authorization");
        String method = request.getMethod();
        Map headers = LoggingHelper.getHeaders((HttpServletRequest)request);
        Map parameters = LoggingHelper.getParameters((HttpServletRequest)request);
        try {
            requestBody = this.objectMapper.writeValueAsString(body);
        }
        catch (Exception e) {
            requestBody = e.toString();
        }
        this.loggingService.saveRequest(authorization, url, method, headers, parameters, requestBody);
    }
}

