/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodandcolor.repository;

import com.infinite.focus.server.moodandcolor.dto.MoodAndColorDTO;
import com.infinite.focus.server.moodandcolor.repository.MoodAndColorRepository;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class MoodAndColorRepositoryImpl
implements MoodAndColorRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public MoodAndColorDTO create(Long mood_id, String color_primary, String color_secondary, String color_tertiary) {
        String INSERT_SQL = "INSERT INTO mood_and_color (mood_id, color_primary, color_secondary, color_tertiary, created_at, updated_at) VALUES (?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO mood_and_color (mood_id, color_primary, color_secondary, color_tertiary, created_at, updated_at) VALUES (?,?,?,?,?,?)", 1);
            ps.setLong(1, mood_id);
            ps.setString(2, color_primary);
            ps.setString(3, color_secondary);
            ps.setString(4, color_tertiary);
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(6, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int mood_and_color_id = Objects.requireNonNull(holder.getKey()).intValue();
        return MoodAndColorDTO.builder().mood_and_color_id((long)mood_and_color_id).mood_id(mood_id.longValue()).color_primary(color_primary).color_secondary(color_secondary).color_tertiary(color_tertiary).build();
    }

    public MoodAndColorDTO getMoodAndColorByMoodId(Long mood_id) {
        String SQL = "SELECT * FROM mood_and_color WHERE mood_id = ?";
        return (MoodAndColorDTO)this.jdbcTemplate.queryForObject(SQL, (rs, i) -> MoodAndColorDTO.builder().mood_and_color_id(rs.getLong("mood_and_color_id")).mood_id(rs.getLong("mood_id")).color_primary(rs.getString("color_primary")).color_secondary(rs.getString("color_secondary")).color_tertiary(rs.getString("color_tertiary")).build(), new Object[]{mood_id});
    }
}

